<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
        data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', App\Models\Plan::class)): ?>
        <li>
            <a href="<?php echo e(route('c-panel.plans.index', $item->id)); ?>" class="dropdown-item">
                <i class="ri-eye-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Plans')); ?>

            </a>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $item)): ?>
        <li>
            <a class="dropdown-item edit-item-btn" data-bs-toggle="modal" data-bs-target="#edit-item-<?php echo e($item->id); ?>">
                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Edit')); ?>

            </a>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $item)): ?>
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#delete-item-<?php echo e($item->id); ?>">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Delete')); ?>

            </a>
        </li>
        <?php endif; ?>
    </ul>
</div>


<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $item)): ?>
<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" <?php echo e(route('c-panel.groups.destroy',$item->id)); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                            <p class="text-muted mx-4 mb-0"><?php echo e(__('Are you Sure You want to Remove this Record ?')); ?></p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn w-sm btn-danger " id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
<?php endif; ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $item)): ?>
<!-- Edit Modal -->
<div class="modal fade" id="edit-item-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light p-3">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Edit Services Group')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
            </div>
            <form action="<?php echo e(route('c-panel.groups.update', $item->id )); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <label for="image"><?php echo e(__('Image')); ?></label>
                    <div class="mb-3">
                        <div class="position-relative d-inline-block" style="width: 60%">
                            <input type='file'
                                onchange="loadFile_image<?php echo e($item->id); ?>(image<?php echo e($item->id); ?>)"
                                name="image" id="image<?php echo e($item->id); ?>"
                                class="<?php $__errorArgs = ['image<?php echo e($item->id); ?>'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                style="display:none;" />
                            <button id="output_image<?php echo e($item->id); ?>" type="button" class="bg-light"
                                onclick="document.getElementById('image<?php echo e($item->id); ?>').click();"
                                value="emad"
                                style="
                                    width: 100%;
                                    height: 150px;
                                    border-radius: 2px;
                                    background-repeat: no-repeat;
                                    background-image: url(<?php echo e(asset('storage/' . ($item->image ?? ''))); ?>);
                                    background-size: cover;
                                    background-position: center;
                                    border:none;
                                    "></button>
                            <div class="position-absolute top-100 start-100 translate-middle">
                                <label for="product-image-input"
                                    onclick="document.getElementById('image<?php echo e($item->id); ?>').click();"
                                    class="mb-0" title="Select Image">
                                    <div class="avatar-xs">
                                        <div
                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                            <i class="ri-image-fill"></i>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        <script>
                            var loadFile_image<?php echo e($item->id); ?> = function(image<?php echo e($item->id); ?>) {
                                var image<?php echo e($item->id); ?> = document.getElementById('output_image<?php echo e($item->id); ?>');
                                var src = URL.createObjectURL(event.target.files[0]);
                                image<?php echo e($item->id); ?>.style.backgroundImage = 'url(' + src + ')';
                            };
                        </script>
                    </div>
                    <div class="mb-3">
                        <label for="name_ar" class="form-label"><?php echo e(__('Arabic Group Name')); ?></label>
                        <input type="text" id="name_ar" name="name_ar" value="<?php echo e($item->name_ar); ?>" class="form-control" required />
                    </div>
                    <div class="mb-3">
                        <label for="name" class="form-label"><?php echo e(__('English Group Name')); ?></label>
                        <input type="text" id="name" name="name" value="<?php echo e($item->name); ?>" class="form-control" required />
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label"><?php echo e(__('English Description')); ?></label>
                        <textarea  id="description" name="description" class="form-control" rows="3" ><?php echo e(old('description', $item->description)); ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="description_ar" class="form-label"><?php echo e(__('Arabic Description')); ?></label>
                        <textarea  id="description_ar" name="description_ar" class="form-control" rows="3"><?php echo e(old('description_ar', $item->description_ar)); ?></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="hstack gap-2 justify-content-end">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-success" id="add-btn"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!--end edit modal -->
<?php endif; ?>
<?php /**PATH /home/crmdivvat/public_html/resources/views/admin/groups/datatable/buttons.blade.php ENDPATH**/ ?>