<?php $__env->startSection('content'); ?>

    <div class="col-xxl-9" style="margin-top: 30px;">
        <div class="card mt-xxl-n5">
            <div class="card-header">
                <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#generalSetting" role="tab">
                            <i class="fas fa-home"></i> <?php echo e(__('General Setting')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#socialMediaSetting" role="tab">
                            <i class="fas fa-home"></i> <?php echo e(__('Social Media Setting')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#seoSetting" role="tab">
                            <i class="fas fa-home"></i> <?php echo e(__('SEO Setting')); ?>

                        </a>
                    </li>
                </ul>
            </div>
            <div class="card-body p-4">
                <form action="<?php echo e(route('c-panel.setting')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="tab-content">
                        <div class="tab-pane active" id="generalSetting" role="tabpanel">
                            <div class="row">
                                <div class="col-lg-6">
                                    <label><?php echo e(__('Main Logo')); ?></label>
                                    <div class="mb-3">
                                        <div class="profile-user position-relative d-inline-block mx-auto  mb-4">
                                            <img src="<?php if($setting->main_logo ?? false): ?> <?php echo e(asset('storage/' . $setting->main_logo)); ?> <?php else: ?><?php echo e(asset('client-logo.jpeg')); ?> <?php endif; ?>"
                                                class="img-thumbnail user-profile-image" id="main-logo-image"
                                                style="border-radius: 2%; height:200px; width:200px;"
                                                alt="user-profile-image">
                                            <div class="avatar-xs p-0 rounded-circle profile-photo-edit">
                                                <input id="main_logo" name="main_logo" type="file"
                                                    class="profile-img-file-input">
                                                <label for="main_logo" class="profile-photo-edit avatar-xs">
                                                    <span class="avatar-title rounded-circle bg-light text-body">
                                                        <i class="ri-camera-fill"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <label><?php echo e(__('Footer Logo')); ?></label>
                                    <div class="mb-3">
                                        <div class="profile-user position-relative d-inline-block mx-auto  mb-4">
                                            <img src="<?php if($setting->footer_logo ?? false): ?> <?php echo e(asset('storage/' . $setting->footer_logo)); ?> <?php else: ?><?php echo e(asset('client-logo.jpeg')); ?> <?php endif; ?>"
                                                class="img-thumbnail user-profile-image" id="footer-logo-image"
                                                style="border-radius: 2%; height:200px; width:200px;"
                                                alt="user-profile-image">
                                            <div class="avatar-xs p-0 rounded-circle profile-photo-edit">
                                                <input id="footer_logo" name="footer_logo" type="file"
                                                    class="profile-img-file-input">
                                                <label for="footer_logo" class="profile-photo-edit avatar-xs">
                                                    <span class="avatar-title rounded-circle bg-light text-body">
                                                        <i class="ri-camera-fill"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label"><?php echo e(__('English Website Title')); ?></label>
                                        <input type="text" class="form-control" id="title" name="title"
                                            value="<?php echo e(old('title', $setting->title ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="title_ar" class="form-label"><?php echo e(__('Arabic Website Title')); ?></label>
                                        <input type="text" class="form-control" id="title_ar" name="title_ar"
                                            value="<?php echo e(old('title_ar', $setting->title_ar ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            value="<?php echo e(old('email', $setting->email ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="phone" class="form-label"><?php echo e(__('Phone Number')); ?></label>
                                        <input type="text" class="form-control" id="phone" name="phone"
                                            value="<?php echo e(old('phone', $setting->phone ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="address" class="form-label"><?php echo e(__('English Address')); ?></label>
                                        <input type="text" class="form-control" id="address" name="address"
                                            value="<?php echo e(old('address', $setting->address ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="address_ar" class="form-label"><?php echo e(__('Arabic Address')); ?></label>
                                        <input type="text" class="form-control" id="address_ar" name="address_ar"
                                            value="<?php echo e(old('address_ar', $setting->address_ar ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="bio" class="form-label"><?php echo e(__('English Bio')); ?></label>
                                        <textarea class="form-control" id="bio" name="bio" rows="3"><?php echo e(old('bio', $setting->bio ?? '')); ?></textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="bio_ar" class="form-label"><?php echo e(__('Arabic Bio')); ?></label>
                                        <textarea class="form-control" id="bio_ar" name="bio_ar" rows="3"><?php echo e(old('bio_ar', $setting->bio_ar ?? '')); ?></textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="map_url" class="form-label"><?php echo e(__('Map URL')); ?></label>
                                        <textarea class="form-control" id="map_url" name="map_url" rows="3"><?php echo e(old('map_url', $setting->map_url ?? '')); ?></textarea>
                                    </div>
                                </div>
                                <!--end col-->

                                <!--end col-->
                            </div>
                            <!--end row-->
                        </div>
                        <!--end tab-pane-->
                        <div class="tab-pane" id="socialMediaSetting" role="tabpanel">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="facebook" class="form-label"><?php echo e(__('Facebook')); ?></label>
                                        <input type="text" class="form-control" id="facebook" name="facebook"
                                            value="<?php echo e(old('facebook', $setting->facebook ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="twitter" class="form-label"><?php echo e(__('Twitter')); ?></label>
                                        <input type="text" class="form-control" id="twitter" name="twitter"
                                            value="<?php echo e(old('twitter', $setting->twitter ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="instagram" class="form-label"><?php echo e(__('Instagram')); ?></label>
                                        <input type="text" class="form-control" id="instagram" name="instagram"
                                            value="<?php echo e(old('instagram', $setting->instagram ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="youtube" class="form-label"><?php echo e(__('Youtube')); ?></label>
                                        <input type="text" class="form-control" id="youtube" name="youtube"
                                            value="<?php echo e(old('youtube', $setting->youtube ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="whatsapp" class="form-label"><?php echo e(__('Whatsapp')); ?></label>
                                        <input type="text" class="form-control" id="whatsapp" name="whatsapp"
                                            value="<?php echo e(old('whatsapp', $setting->whatsapp ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="linkedin" class="form-label"><?php echo e(__('Linkedin')); ?></label>
                                        <input type="text" class="form-control" id="linkedin" name="linkedin"
                                            value="<?php echo e(old('linkedin', $setting->linkedin ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="behance" class="form-label"><?php echo e(__('Behance')); ?></label>
                                        <input type="text" class="form-control" id="behance" name="behance"
                                            value="<?php echo e(old('behance', $setting->behance ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="github" class="form-label"><?php echo e(__('Github')); ?></label>
                                        <input type="text" class="form-control" id="github" name="github"
                                            value="<?php echo e(old('github', $setting->github ?? '')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </div>
                        <!--end tab-pane-->
                        <div class="tab-pane" id="seoSetting" role="tabpanel">
                            <div class="row">
                                <div class="col-lg-12">
                                    <label><?php echo e(__('SEO Image')); ?></label>
                                    <div class="mb-3">
                                        <div class="profile-user position-relative d-inline-block mx-auto  mb-4">
                                            <img src="<?php if($setting->seo_image ?? false): ?> <?php echo e(asset('storage/' . $setting->seo_image)); ?> <?php else: ?><?php echo e(asset('client-logo.jpeg')); ?> <?php endif; ?>"
                                                class="img-thumbnail user-profile-image" id="seo-image"
                                                style="border-radius: 2%; height:200px; width:200px;"
                                                alt="user-profile-image">
                                            <div class="avatar-xs p-0 rounded-circle profile-photo-edit">
                                                <input id="seo_image" name="seo_image" type="file"
                                                    class="profile-img-file-input">
                                                <label for="seo_image" class="profile-photo-edit avatar-xs">
                                                    <span class="avatar-title rounded-circle bg-light text-body">
                                                        <i class="ri-camera-fill"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="seo_description"
                                            class="form-label"><?php echo e(__('English SEO Description')); ?></label>
                                        <textarea class="form-control" id="seo_description" name="seo_description" rows="10"><?php echo e(old('seo_description', $setting->seo_description ?? '')); ?></textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="seo_description_ar"
                                            class="form-label"><?php echo e(__('Arabic SEO Description')); ?></label>
                                        <textarea class="form-control" id="seo_description_ar" name="seo_description_ar" rows="10"><?php echo e(old('seo_description_ar', $setting->seo_description_ar ?? '')); ?></textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="seo_tags" class="form-label"><?php echo e(__('English SEO Tags')); ?></label>
                                        <input type="text" class="form-control" id="seo_tags" name="seo_tags"
                                            <?php if(old('seo_tags')): ?> value="<?php echo e(old('seo_tags')); ?>" <?php elseif($setting->seo_tags ?? null): ?> value="<?php $__currentLoopData = $setting->seo_tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($tag); ?><?php if(!$loop->last): ?><?php echo e(','); ?> <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>" <?php endif; ?>>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="seo_tags_ar" class="form-label"><?php echo e(__('Arabic SEO Tags')); ?></label>
                                        <input type="text" class="form-control" id="seo_tags_ar" name="seo_tags_ar"
                                            <?php if(old('seo_tags_ar')): ?> value="<?php echo e(old('seo_tags_ar')); ?>" <?php elseif($setting->seo_tags_ar ?? null): ?> value="<?php $__currentLoopData = $setting->seo_tags_ar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($tag); ?><?php if(!$loop->last): ?><?php echo e(','); ?> <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>" <?php endif; ?>>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </div>
                        <!--end tab-pane-->

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Updates')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!--end col-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
    <!-- profile-setting init js -->
    <script>
        document.querySelector("#main_logo") && document.querySelector("#main_logo").addEventListener("change", function() {
            var o = document.querySelector("#main-logo-image"),
                e = document.querySelector("#main_logo").files[0],
                i = new FileReader;
            i.addEventListener("load", function() {
                o.src = i.result
            }, !1), e && i.readAsDataURL(e)
        });

        document.querySelector("#footer_logo") && document.querySelector("#footer_logo").addEventListener("change",
            function() {
                var o = document.querySelector("#footer-logo-image"),
                    e = document.querySelector("#footer_logo").files[0],
                    i = new FileReader;
                i.addEventListener("load", function() {
                    o.src = i.result
                }, !1), e && i.readAsDataURL(e)
            });

        document.querySelector("#seo_image") && document.querySelector("#seo_image").addEventListener("change", function() {
            var o = document.querySelector("#seo-image"),
                e = document.querySelector("#seo_image").files[0],
                i = new FileReader;
            i.addEventListener("load", function() {
                o.src = i.result
            }, !1), e && i.readAsDataURL(e)
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmdivvat/public_html/resources/views/admin/setting.blade.php ENDPATH**/ ?>