<!DOCTYPE html>
<html lang="ar" dir="rtl" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <!-- App favicon -->
    <link rel="shortcut icon"
        href="<?php if($setting->footer_logo): ?> <?php echo e(asset('storage/' . $setting->footer_logo)); ?><?php else: ?><?php echo e(asset('assets/images/favicon.ico')); ?> <?php endif; ?>">

    <!-- Site Title  -->
    <title>
        <?php if(LaravelLocalization::getCurrentLocale() == 'ar'): ?>
            <?php echo e($setting->title_ar); ?><?php else: ?><?php echo e($setting->title); ?>

        <?php endif; ?> | <?php echo e(__('تسجيل دخول')); ?>

    </title>
    <!-- Bundle and Base CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/vendor.bundle.css?ver=200')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/style-salvia.css?ver=200')); ?>">

    <!-- Extra CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/theme.css?ver=200')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/rtl.css?ver=200')); ?>">
</head>

<body class="nk-body body-wider bg-light-alt has-rtl" dir="rtl">
    <div class="nk-wrap">
        <main class="nk-pages nk-pages-centered bg-theme">
            <div class="ath-container">
                <div class="ath-header text-center">
                    <a href="<?php echo e(route('view.home')); ?>" class="ath-logo"><img src="<?php echo e(asset('storage/' . $setting->footer_logo)); ?>"
                            srcset="<?php echo e(asset('storage/' . $setting->footer_logo)); ?>" width="200" alt="logo"></a>
                </div>
                <div class="ath-body">
                    <h5 class="ath-heading title"><?php echo e(__('اشتراك')); ?> <small class="tc-default"><?php echo e(__('قم بإنشاء حساب توكن ويز جديد')); ?></small></h5>
                    <form action="<?php echo e(route('register')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="text" class="input-bordered" name="name" placeholder="<?php echo e(__('اسمك')); ?>">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="email" class="input-bordered" placeholder="<?php echo e(__('بريدك الالكتروني')); ?>" name="email">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="password" class="input-bordered" name="password" placeholder="<?php echo e(__('كلمة المرور')); ?>">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="password" class="input-bordered" name="password_confirmation" placeholder="<?php echo e(__('أعد كلمة المرور')); ?>">
                            </div>
                        </div>
                        <div class="field-item">
                            <input class="input-checkbox" id="agree-term-2" name="policy" value="1" type="checkbox">
                            <label for="agree-term-2"><?php echo e(__('أوافق على Icos')); ?> <a href="#"><?php echo e(__('سياسة خصوصية')); ?></a> <?php echo e(__('و')); ?> <a href="#"><?php echo e(__('شروط')); ?></a></label>
                        </div>
                        <button type="submit" class="btn btn-primary btn-block btn-md"> <?php echo e(__('اشتراك')); ?></button>
                    </form>
                    
                </div>
                <div class="ath-note text-center tc-light"> <?php echo e(__('هل لديك حساب؟')); ?> <a href="<?php echo e(route('client.login')); ?>"> <strong><?php echo e(__('تسجيل الدخول هنا')); ?></strong></a>
                </div>
            </div>
        </main>
    </div>
    <!-- Preloader -->
    <div class="preloader"><span class="spinner spinner-round"></span></div>
    <!-- JavaScript -->

    <script src="<?php echo e(asset('front/assets/js/jquery.bundle.js?ver=200')); ?>"></script>
    <script src="<?php echo e(asset('front/assets/js/scripts.js?ver=200')); ?>"></script>
    <script src="<?php echo e(asset('front/assets/js/charts.js?ver=200')); ?>"></script>
    <script src="<?php echo e(asset('front/assets/js/charts.js?ver=200')); ?>"></script>
</body>

</html>
<?php /**PATH /home/crmdivvat/public_html/resources/views/auth/client/register.blade.php ENDPATH**/ ?>