<?php $__env->startSection('pageTitle'); ?>
<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0"><?php echo e(__('Edit Plan')); ?></h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e($group->name); ?></a></li>
                    <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(__('Plans')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(__('Edit Plan')); ?></li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row justify-content-center">
    <div class="col-xxl-9">
        <div class="card">
            <form action="<?php echo e(route('c-panel.plans.update', $plan->id)); ?>" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate id="invoice_form">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="card-body p-4">
                    <div class="row g-3">
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="title"><?php echo e(__('Plan Title')); ?></label>
                                <input type="text" class="form-control " value="<?php echo e(old('title', $plan->title)); ?>" id="title" name="title">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="description"><?php echo e(__('Description')); ?></label>
                                <textarea class="form-control" rows="3" id="description"  name="description"><?php echo e(old('description', $plan->description)); ?></textarea>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="invoice-table table table-borderless table-nowrap mb-0 text-center">
                            <thead class="align-middle">
                                <tr class="table-active">
                                    <th scope="col" style="width: 20%;"><?php echo e(__('Quarterly')); ?></th>
                                    <th scope="col" style="width: 20%;"><?php echo e(__('Biannual')); ?></th>
                                    <th scope="col" style="width: 20%;"><?php echo e(__('Annual')); ?></th>
                                    <th scope="col" style="width: 20%;"><?php echo e(__('Two Years')); ?></th>
                                    <th scope="col" style="width: 20%;"><?php echo e(__('Three Years')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="align-middle">
                                <?php
                                    $check_1 = false;
                                    $check_2 = false;
                                    $check_3 = false;
                                    $check_4 = false;
                                    $check_5 = false;

                                    $price_1 = $plan->prices()->where('type', 1)->first()->price ?? null;
                                    if($price_1)
                                    {
                                        $check_1 = true;
                                    }
                                    $price_2 = $plan->prices()->where('type', 2)->first()->price ?? null;
                                    if($price_2)
                                    {
                                        $check_2 = true;
                                    }
                                    $price_3 = $plan->prices()->where('type', 3)->first()->price ?? null;
                                    if($price_3)
                                    {
                                        $check_3 = true;
                                    }
                                    $price_4 = $plan->prices()->where('type', 4)->first()->price ?? null;
                                    if($price_4)
                                    {
                                        $check_4 = true;
                                    }
                                    $price_5 = $plan->prices()->where('type', 5)->first()->price ?? null;
                                    if($price_5)
                                    {
                                        $check_5 = true;
                                    }
                                ?>
                                <tr style="height: 62.5px">
                                    <td>
                                        <input type="text" class="form-control" name="price_1" id="price_1" value="<?php echo e(old('price_1', $price_1)); ?>" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_2" id="price_2" value="<?php echo e(old('price_2', $price_2)); ?>" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_3" id="price_3" value="<?php echo e(old('price_3', $price_3)); ?>" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_4" id="price_4" value="<?php echo e(old('price_4', $price_4)); ?>" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_5" id="price_5" value="<?php echo e(old('price_5', $price_5)); ?>" style="display: none;">
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot class="align-middle">
                                <tr>
                                    <td><input type="checkbox" name="check_1" onchange="showPrice()" id="check_1" <?php if(old('check_1') || $check_1): ?> checked <?php endif; ?> value="1"></td>
                                    <td><input type="checkbox" name="check_2" onchange="showPrice()" id="check_2" <?php if(old('check_2') || $check_2): ?> checked <?php endif; ?> value="1"></td>
                                    <td><input type="checkbox" name="check_3" onchange="showPrice()" id="check_3" <?php if(old('check_3') || $check_3): ?> checked <?php endif; ?> value="1"></td>
                                    <td><input type="checkbox" name="check_4" onchange="showPrice()" id="check_4" <?php if(old('check_4') || $check_4): ?> checked <?php endif; ?> value="1"></td>
                                    <td><input type="checkbox" name="check_5" onchange="showPrice()" id="check_5" <?php if(old('check_5') || $check_5): ?> checked <?php endif; ?> value="1"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="invoice-table table table-borderless table-nowrap mb-0">
                            <thead class="align-middle">
                                <tr class="table-active">
                                    <th scope="col" style="width: 50px;">#</th>
                                    <th scope="col"><?php echo e(__('Features')); ?></th>
                                    <th scope="col" style="width: 120px;"></th>
                                </tr>
                            </thead>
                            <tbody id="newlink">
                                <?php if(old('features') && count(old('features')) != 0): ?>
                                    <?php $__currentLoopData = old('features'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($key+1); ?>" class="product">
                                            <th scope="row" class="product-id"><?php echo e($key+1); ?></th>
                                            <td class="text-start">
                                                <div class="mb-2">
                                                    <input type="text" class="form-control bg-light border-0" id="feature-<?php echo e($key+1); ?>" value="<?php echo e(old('features')[$key]); ?>" name="features[]" required />
                                                </div>
                                            </td>
                                            <td class="product-removal">
                                                <a href="javascript:void(0)" class="btn btn-success"><?php echo e(__('Delete')); ?></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif($plan->features && count($plan->features) != 0): ?>
                                    <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($key+1); ?>" class="product">
                                            <th scope="row" class="product-id"><?php echo e($key+1); ?></th>
                                            <td class="text-start">
                                                <div class="mb-2">
                                                    <input type="text" class="form-control bg-light border-0" id="feature-<?php echo e($key+1); ?>" value="<?php echo e($item->name); ?>" name="features[]" required />
                                                </div>
                                            </td>
                                            <td class="product-removal">
                                                <a href="javascript:void(0)" class="btn btn-success"><?php echo e(__('Delete')); ?></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr id="1" class="product">
                                        <th scope="row" class="product-id">1</th>
                                        <td class="text-start">
                                            <div class="mb-2">
                                                <input type="text" class="form-control bg-light border-0" id="feature-1" name="features[]" required />
                                            </div>
                                        </td>
                                        <td class="product-removal">
                                            <a href="javascript:void(0)" class="btn btn-success"><?php echo e(__('Delete')); ?></a>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                            <tbody>
                                <tr id="newForm" style="display: none;"><td class="d-none" colspan="5"><p><?php echo e(__('Add New Form')); ?></p></td></tr>
                                <tr>
                                    <td colspan="8">
                                        <a href="javascript:new_link()" id="add-item" class="btn btn-soft-secondary fw-medium"><i class="ri-add-fill me-1 align-bottom"></i> <?php echo e(__('Add Item')); ?></a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <!--end table-->
                    </div>

                    <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                        <button type="submit" class="btn btn-success"><i class="ri-printer-line align-bottom me-1"></i> <?php echo e(__('Save')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!--end col-->
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- cleave.js -->
<script src="<?php echo e(asset('assets/libs/cleave.js/cleave.min.js')); ?>"></script>

<!--Invoice create init js-->
<script>
    window.onload = function() {
        showPrice();
    };
    var count = 1;
    document.addEventListener("DOMContentLoaded", function(){
        <?php if(old('features') && count(old('features')) != 0): ?>
            <?php $__currentLoopData = old('features'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                calc(<?php echo e($key+1); ?>);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        remove();
        resetRow();
        showPrice();
    });

    <?php if(old('features') && count(old('features')) != 0): ?>
        <?php $__currentLoopData = old('features'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($key != 0): ?>
                count++;
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    function new_link() {
        count++;
        var e = document.createElement("tr"),
            t = (e.id = count, e.className = "product", '<tr><th scope="row" class="product-id">' + count + '</th><td class="text-start"><div class="mb-2"><input class="form-control bg-light border-0" type="text" name="features[]" id="feature-' + count + '" ></div></td><td class="product-removal"><a class="btn btn-success"><?php echo e(__("Delete")); ?></a></td></tr>'),
            t = (e.innerHTML = document.getElementById("newForm").innerHTML + t, document.getElementById("newlink").appendChild(e), document.querySelectorAll("[data-trigger]"));
        Array.from(t).forEach(function(e) {
            new Choices(e, {
                placeholderValue: "This is a placeholder set in the config",
                searchPlaceholderValue: "This is a search placeholder"
            })
        }), remove(), resetRow()
    }

    function remove() {
        Array.from(document.querySelectorAll(".product-removal a")).forEach(function(e) {
            e.addEventListener("click", function(e) {
                count--;
                removeItem(e), resetRow()
            })
        })
    }

    function removeItem(e) {
        e.target.closest("tr").remove()
    }

    function resetRow() {
        Array.from(document.getElementById("newlink").querySelectorAll("tr")).forEach(function(e, t) {
            t += 1;
            e.querySelector(".product-id").innerHTML = t
        })
    }

    function showPrice() {
        // Get the checkbox
        var check_1 = document.getElementById("check_1");
        var check_2 = document.getElementById("check_2");
        var check_3 = document.getElementById("check_3");
        var check_4 = document.getElementById("check_4");
        var check_5 = document.getElementById("check_5");
        // Get the output text
        var price_1 = document.getElementById("price_1");
        var price_2 = document.getElementById("price_2");
        var price_3 = document.getElementById("price_3");
        var price_4 = document.getElementById("price_4");
        var price_5 = document.getElementById("price_5");

        // If the checkbox is checked, display the output text
        if (check_1.checked == true){
            price_1.style.display = "block";
        } else {
            price_1.style.display = "none";
            price_1.value = "";
        }

        if (check_2.checked == true){
            price_2.style.display = "block";
        } else {
            price_2.style.display = "none";
            price_2.value = "";
        }

        if (check_3.checked == true){
            price_3.style.display = "block";
        } else {
            price_3.style.display = "none";
            price_3.value = "";
        }

        if (check_4.checked == true){
            price_4.style.display = "block";
        } else {
            price_4.style.display = "none";
            price_4.value = "";
        }

        if (check_5.checked == true){
            price_5.style.display = "block";
        } else {
            price_5.style.display = "none";
            price_5.value = "";
        }

    }

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmdivvat/public_html/resources/views/admin/groups/plans/edit.blade.php ENDPATH**/ ?>