<?php

use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\Admin\BillsController;
use App\Http\Controllers\Admin\ContactsController;
use App\Http\Controllers\Admin\CustomersController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\DepartmentsController;
use App\Http\Controllers\Admin\DominsController;
use App\Http\Controllers\Admin\GroupsController;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\OffersController;
use App\Http\Controllers\Admin\PartnersController;
use App\Http\Controllers\Admin\PlansController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\SubscriptionsController;
use App\Http\Controllers\Admin\TeamsController;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\WorksController;
use App\Http\Controllers\Front\HomeController;
use App\Models\WebsiteSetting;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::middleware('auth')
        ->prefix('c-panel')
        ->as('c-panel.')
        ->group(function() {

            Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
            Route::get('/my-dashboard', [DashboardController::class, 'clientDashboard'])->name('client-dashboard');

            // departments routes
            Route::resource('departments', DepartmentsController::class)->except(['create', 'edit', 'show']);
            Route::delete('departments/selectors/bulk-delete',[DepartmentsController::class,'bulkDelete'])->name('departments.bulk-delete');

            // groups routes
            Route::resource('groups', GroupsController::class)->except(['create', 'edit', 'show']);
            Route::delete('groups/selectors/bulk-delete',[GroupsController::class,'bulkDelete'])->name('groups.bulk-delete');

            // setting routs
            Route::get('setting', [SettingController::class, 'index'])->name('setting');
            Route::post('setting', [SettingController::class, 'store']);

            // sliders routes
            Route::resource('sliders', SliderController::class)->except(['create', 'edit', 'show']);
            Route::delete('sliders/selectors/bulk-delete',[SliderController::class,'bulkDelete'])->name('sliders.bulk-delete');

            // works routes
            Route::resource('works', WorksController::class)->except(['create', 'edit', 'show']);
            Route::delete('works/selectors/bulk-delete',[WorksController::class,'bulkDelete'])->name('works.bulk-delete');

            // teams routes
            Route::resource('teams', TeamsController::class);
            Route::delete('teams/selectors/bulk-delete',[TeamsController::class,'bulkDelete'])->name('teams.bulk-delete');

            // teams routes
            Route::resource('partners', PartnersController::class);
            Route::delete('partners/selectors/bulk-delete',[PartnersController::class,'bulkDelete'])->name('partners.bulk-delete');

            // about routs
            Route::get('about', [AboutController::class, 'index'])->name('about');
            Route::post('about', [AboutController::class, 'store']);

            // contacts routes
            Route::resource('contacts', ContactsController::class)->except(['store', 'edit', 'update', 'create']);
            Route::delete('contacts/selectors/bulk-delete', [ContactsController::class,'bulkDelete'])->name('contacts.bulk-delete');

            // menus routes
            Route::resource('menus', MenuController::class)->except(['create', 'store', 'edit', 'show', 'destroy']);

            // plans routes
            Route::get('plans/{group}', [PlansController::class, 'index'])->name('plans.index');
            Route::get('plans/{group}/create', [PlansController::class, 'create'])->name('plans.create');
            Route::post('plans/{group}/create', [PlansController::class, 'store'])->name('plans.store');
            Route::resource('plans', PlansController::class)->except(['index', 'create', 'store']);
            Route::delete('plans/selectors/bulk-delete',[PlansController::class,'bulkDelete'])->name('plans.bulk-delete');

            // domins routes
            Route::resource('domins', DominsController::class)->except(['create', 'edit', 'show']);
            Route::delete('domins/selectors/bulk-delete',[DominsController::class,'bulkDelete'])->name('domins.bulk-delete');

            // subscriptions routes
            Route::resource('subscriptions', SubscriptionsController::class);
            Route::delete('subscriptions/selectors/bulk-delete',[SubscriptionsController::class,'bulkDelete'])->name('subscriptions.bulk-delete');
            Route::get('group/ajax/{group}', [SubscriptionsController::class, 'getPlans']);
            Route::get('plan/ajax/{plan}', [SubscriptionsController::class, 'getPrices']);
            Route::get('group/price/ajax/{type}/{plan}', [SubscriptionsController::class, 'getGroupPrice']);
            Route::get('domin/price/ajax/{domin}', [SubscriptionsController::class, 'getDominPrice']);
            Route::get('my-subscriptions', [SubscriptionsController::class, 'muSubscriptions'])->name('subscriptions.my-subscriptions');
            Route::get('subscriptionsdue', [SubscriptionsController::class, 'subscriptionsdue'])->name('subscriptionsdue');

            // offers routes
            Route::resource('offers', OffersController::class);
            Route::delete('offers/selectors/bulk-delete',[OffersController::class,'bulkDelete'])->name('offers.bulk-delete');
            Route::put('offers/update-status/{offer}', [OffersController::class, 'updateStatus'])->name('offers.update-status');
            Route::get('my-offers', [OffersController::class, 'myOffers'])->name('offers.my-offers');

            // bills routes
            Route::resource('bills', BillsController::class);
            Route::delete('bills/selectors/bulk-delete',[BillsController::class,'bulkDelete'])->name('bills.bulk-delete');
            Route::put('bills/update-status/{bill}', [BillsController::class, 'updateStatus'])->name('bills.update-status');
            Route::get('my-bills', [BillsController::class, 'myBills'])->name('bills.my-bills');

            // roles routes
            Route::resource('roles', RoleController::class);

            // customers routes
            Route::resource('customers', CustomersController::class);
            Route::get('customer-subscriptions/{customer}', [CustomersController::class, 'customerSubscriptions'])->name('subscriptions.customer-subscriptions');
            Route::get('customer-bills/{customer}', [CustomersController::class, 'customerBills'])->name('bills.customer-bills');

            // users routes
            Route::resource('users', UsersController::class);

        });

Route::as('view.')
       ->group(function() {
            Route::get('/', [HomeController::class, 'index'])->name('home');
            Route::get('/about', [HomeController::class, 'about'])->name('about');
            Route::get('/about-2', [HomeController::class, 'about2'])->name('about-2');
            Route::get('/partners', [HomeController::class, 'partners'])->name('partners');
            Route::get('/our-jobs', [HomeController::class, 'ourWorks'])->name('our-job');
            Route::post('/', [HomeController::class, 'contactPost'])->name('contact');
       });
require __DIR__.'/auth.php';
