@extends('front.layout.app')

@section('title')
    @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.home'] }}@else{{ $menu['en']['view.home'] }}
    @endif
@stop

@section('slider')
    <!-- Banner -->
    <div class="header-banner bg-theme-grad-s2">
        <div class="nk-banner">
            <div class="banner banner-fs banner-single banner-s1">
                <div class="banner-wrap my-auto">
                    <div class="container container-xxl">
                        <div class="row align-items-center justify-content-center justify-content-lg-between gutter-vr-60px">
                            <div class="col-lg-6 col-xl-5 text-center text-lg-start">
                                <div class="banner-caption tc-light animated" data-animate="fadeInUp" data-delay="1.25">
                                    <div class="cpn-head mt-0">
                                        <h1 class="title-lg-s2">
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $main_slider->title_ar }}@else{{ $main_slider->title }}
                                            @endif
                                        </h1>
                                    </div>
                                    <div class="cpn-text cpn-text-s3 pb-2">
                                        <p class="lead-s3 pb-1">
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $main_slider->sub_title_ar }}@else{{ $main_slider->sub_title }}
                                            @endif
                                        </p>
                                        <p>
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $main_slider->description_ar }}@else{{ $main_slider->description }}
                                            @endif
                                        </p>
                                    </div>
                                    <div class="cpn-btns">
                                        <ul class="btn-grp">
                                            <li> <a class="btn btn-lg btn-secondary" href="#"> {{ __('طلب خدمة') }}
                                                </a> </li>
                                        </ul>
                                    </div>
                                </div>
                            </div><!-- .col -->
                            <div class="col-lg-6 col-xl-7 col-md-8 col-sm-9">
                                <div class="banner-gfx banner-gfx-s2 position-relative animated" data-animate="fadeInUp"
                                    data-delay="1.35">
                                    <img src="{{ asset('front/images/app-screens/sc-mockup.png') }}" alt="mockup">
                                    <div class="gfx-slider gfx-screen round" data-slide-speed="2500" data-slide-show="true"
                                        data-anim-loop="true" data-anim-speed="1500">
                                        <ul class="slides">
                                            @foreach ($sliders as $slider)
                                                <li class="gfx-slide">
                                                    <div class="bg-image round">
                                                        <img src="{{ asset('storage/' . $slider->image) }}"
                                                            alt="{{ $slider->title }}">
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div><!-- .col -->
                        </div><!-- .row -->
                    </div>
                </div>
                <div class="banner-bottom w-100 pb-5 animated" data-animate="fadeInUp" data-delay="1.45">
                    <div class="container container-xxl">
                        <ul class="social pt-3 pt-md-0 text-right">
                            @if ($setting->facebook)
                                <li><a href="{{ $setting->facebook }}"><em class="social-icon fab fa-facebook-f"></em></a>
                                </li>
                            @endif
                            @if ($setting->twitter)
                                <li><a href="{{ $setting->twitter }}"><em class="social-icon fab fa-twitter"></em></a></li>
                            @endif
                            @if ($setting->youtube)
                                <li><a href="{{ $setting->youtube }}"><em class="social-icon fab fa-youtube"></em></a></li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div><!-- .nk-banner -->
        <div class="nk-ovm shape-z6">
            <div class="nk-ovm-inner"></div>
        </div>
    </div>
    <!-- .header-banner -->
@endsection

@section('content')

    <main class="nk-pages">
        <div class="section animated" data-animate="fadeInUp" data-delay=".1">
            <div class="container">
                <div class="nk-block">
                    <div class="row justify-content-center">
                        <div class="col-lg-12 col-mb-12">
                            <div class="nk-block-text text-center">
                                <h2 class="title title-normal"> {{ __('هذا ما نبدع به') }} </h2>
                                <p> {{ __('نسعي لتقديم كافة الخدمات التقنية التي تساهم في نجاح مشروعك') }} </p>

                                <div class="nk-block nk-block-features mgb-m30 mt-5">
                                    <div class="row">
                                        @foreach ($groups as $group)
                                            <div class="col-lg-4">
                                                <div class="feature  text-left">
                                                    <div class="feature-icon dot">
                                                        <img src="{{ asset('storage/' . $group->image) }}" height="60"
                                                            width="60" alt="">
                                                    </div>
                                                    <div class="feature-text">
                                                        <h5 class="title title-sm">
                                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                                {{ $group->name_ar }}@else{{ $group->name }}
                                                            @endif
                                                        </h5>
                                                        <p>
                                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                                {{ $group->description_ar }}@else{{ $group->description }}
                                                            @endif
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- // -->

        <section class="section bg-light" id="benifits">
            <div class="ui-shape ui-shape-s2"></div>
            <div class="container">
                <div class="section-head section-head-s8 wide-auto-sm text-center">
                    <h2 class="title title-semibold">{{ __('من أعمالنا') }}</h2>
                    <p> {{ __('لقد صممنا تصميمًا رائعًا جديدًا تمامًا والعديد من الميزات ، ويدعم أحدث إصدار من النموذج') }} </p>
                </div><!-- .nk-block -->
                <!-- Block -->
                <div class="nk-block nk-block-features">
                    <div class="feature-carousel-s1 has-carousel has-carousel-overlap carousel-nav-center carousel-nav-s1 owl-carousel owl-loaded owl-drag"
                        data-items="1" data-navs="true" data-loop="true" data-animate-out="fadeOut">


                        <div class="owl-stage-outer">
                            <div class="owl-stage"
                                style="transform: translate3d(-2280px, 0px, 0px); transition: all 0s ease 0s; width: 6840px;">
                                @foreach($works as $work)
                                <div class="owl-item @if($loop->first) active @else cloned @endif" style="width: 1110px; margin-right: 30px;">
                                    <div class="feature">
                                        <div class="row g-0">
                                            <div class="col-md-6 col-sm-12 animate-left delay-5ms">
                                                <div class="feature-s10 feature-s10-left round bg-white">
                                                    <h2 class="title title-bold title-s4">
                                                        @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                            {{ $work->title_ar }}@else{{ $work->title }}
                                                        @endif
                                                    </h2>
                                                    <h5 class="title-sm">
                                                        @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                            {{ $work->group->name_ar }}@else{{ $work->group->name }}
                                                        @endif
                                                    </h5>
                                                    @if($work->description_ar && $work->description)
                                                    <ul class="list list-dot list-dot-s2">
                                                        <li style="width: 350px;">
                                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                                {{ $work->description_ar }}@else{{ $work->description }}
                                                            @endif
                                                        </li>
                                                    </ul>
                                                    @endif
                                                </div>
                                            </div><!-- .col -->
                                            <div class="col-md-6 col-sm-12 animate-right delay-7ms">
                                                <div class="feature-s10 feature-s10-right round bg-theme tc-light">
                                                    <div class="project-img">
                                                        <img class="img-fluid" src="{{ asset('storage/'.$work->image) }}">
                                                    </div>
                                                </div>
                                            </div><!-- .col -->
                                        </div><!-- .row -->
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="owl-nav"><button type="button" role="presentation"
                                class="owl-prev"></button><button type="button" role="presentation"
                                class="owl-next"></button></div>
                        <div class="owl-dots disabled"></div>
                    </div>
                </div><!-- .block -->
            </div>
        </section>
        <section class="section">
            <div class="container">
                <div class="nk-block nk-block-token">
                    <div class="section-head section-head-s7 wide-auto-sm text-center">
                        <h2 class="title title-thin"> {{ __('الباقات والعروض') }} </h2>
                        <p class="lead"> {{ __('باقات تصميم مواقع تناسب جميع الأعمال الناشئة والمتوسطة والشركات العملاقة') }}
                        </p>
                    </div>
                    <div class="row gutter-vr-30px">
                        <div class="row">
                            @foreach($plans as $plan)
                            <div class="col-sm-4">
                                <div class="token-stage text-center animated fadeInUp" data-animate="fadeInUp"
                                    data-delay=".4" style="visibility: visible; animation-delay: 0.4s;">
                                    <div class="token-stage-title token-stage-pre">{{ $plan->title }}</div>
                                    <div class="token-stage-date">
                                        <h3>{{ $plan->prices()->first()->price }}</h3>
                                        <span>{{ __('تدفع لمرة واحدة') }}</span>
                                    </div>
                                    <div class="token-stage-info">
                                        @foreach ($plan->features as $feature)
                                        <p>{{ $feature->name }}</p>
                                        @endforeach
                                        <br>
                                        <a href="#" class="subscrip">{{ __('اشتراك') }}</a>
                                    </div>


                                </div>
                            </div><!-- .col -->
                            @endforeach
                        </div><!-- row -->
                        <div class="token-action-box text-center animated fadeInUp" data-animate="fadeInUp"
                            data-delay=".7" style="visibility: visible; animation-delay: 0.7s;">
                            <div class="token-action-date">
                                <h5>
                                    {{ __('لطلب برمجة خاصة يمكنكم التواصل معنا وتقديم طلب') }}
                                </h5>
                            </div>
                            <div class="token-action-btn">
                                <a href="#" class="btn btn-lg btn-grad">{{ __('طلب خدمة') }}</a>
                            </div>
                        </div>

                    </div><!-- .row -->
                </div>
            </div>
        </section>
        <!-- // -->
        <div class="section bg-theme-alt tc-light">
            <div class="container">
                <div class="nk-block">
                    <h2 class="title text-center">{{ __('عملاءنا المميزين') }}</h2>
                    <div class="has-carousel carousel-nav-center partner-list owl-carousel owl-rtl owl-loaded owl-drag"
                        data-items="6" data-dots="true">

                        <div class="owl-stage-outer">
                            <div class="owl-stage"
                                style="transform: translate3d(0px, 0px, 0px); transition: all 0s ease 0s; width: 1710px;">
                                @foreach($partners as $key => $partner)
                                <div class="owl-item @if($key < 6) active @endif" style="width: 160px; margin-left: 30px;">
                                    <div class="partner-logo">
                                        <img src="{{ asset('storage/'.$partner->image) }}" alt="">
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="owl-nav disabled"><button type="button" role="presentation"
                                class="owl-prev"></button><button type="button" role="presentation"
                                class="owl-next"></button></div>
                        {{-- <div class="owl-dots"><button role="button" class="owl-dot active"><span></span></button><button
                                role="button" class="owl-dot"><span></span></button></div> --}}
                    </div>
                </div>
            </div>
        </div>
        <!-- // -->
        <div class="section section-contact bg-white ov-h" id="contactSection">
            <div class="container">
                <!-- Block -->
                <div class="nk-block nk-block-contact">
                    <div class="row justify-content-between align-items-center gutter-vr-50px">
                        <div class="col-lg-6">
                            <div class="nk-block-text">
                                <div class="nk-block-text-head">
                                    <h2 class="title title-lg ttu">{{ __('تواصل معنا') }}</h2>
                                    <p>
                                        {{ __('نحن دائمًا متواجدون ونرحب بك والأسئلة التي لديك . إذا كنت ترغب في الاتصال ، يرجى ملء النموذج أدناه. سيرد عليك أحد أعضاء فريقنا قريبًا.') }}
                                    </p>
                                </div>
                                <form id="contactForm" action="{{ route('view.contact') }}" method="post"
                                    novalidate="novalidate">
                                    @csrf
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="field-item">
                                                <label class="field-label ttu">{{ __('الاسم') }}</label>
                                                <div class="field-wrap">
                                                    <input name="name" id="contactName" placeholder="{{ __('يرجي كتابة الاسم') }}" value="{{ old('name') }}"
                                                        type="text" class="input-bordered required">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="field-item">
                                                <label class="field-label ttu">{{ __('البريد الالكتروني') }}</label>
                                                <div class="field-wrap">
                                                    <input name="email" id="contactEmail" placeholder="{{ __('ادخل بريدك الالكتروني') }}" value="{{ old('email') }}"
                                                        type="email" class="input-bordered required email">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="field-item">
                                        <label class="field-label ttu">{{ __('رسالتك') }}</label>
                                        <div class="field-wrap">
                                            <textarea name="message" id="contactMassage" placeholder="{{ __('اكتب رسالتك او استفسارك هنا') }}" value="{{ old('message') }}"
                                                class="input-bordered input-textarea required"></textarea>
                                        </div>
                                    </div>
                                    <input type="text" class="d-none" name="form-anti-honeypot" value="">
                                    <div class="row">
                                        <div class="col-sm-5 text-end">
                                            <button type="button" id="submitContact" onclick="submitContactForm()" class="btn btn-primary">{{ __('ارسال') }}</button>
                                        </div>
                                        <div class="col-sm-7 order-sm-first">
                                            <div class="form-results"></div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-lg-5 text-center order-lg-first">
                            <div class="nk-block-contact nk-block-contact-s1">
                                <ul class="contact-list">
                                    @if($setting->phone)
                                    <li>
                                        <em class="contact-icon fas fa-phone"></em>
                                        <div class="contact-text">
                                            <span>{{ $setting->phone }}</span>
                                        </div>
                                    </li>
                                    @endif
                                    @if($setting->email)
                                    <li>
                                        <em class="contact-icon fas fa-envelope"></em>
                                        <div class="contact-text">
                                            <span>{{ $setting->email }}</span>
                                        </div>
                                    </li>
                                    @endif
                                </ul>
                                <div class="nk-circle-animation nk-df-center accent-alt small"></div>
                                <!-- .circle-animation -->
                            </div>
                            <ul class="social-links social-links-s2 justify-content-center">
                                @if($setting->twitter)<li><a href="{{ $setting->twitter }}"><em class="fab fa-twitter"></em></a></li>@endif
                                @if($setting->facebook)<li><a href="{{ $setting->facebook }}"><em class="fab fa-facebook-f"></em></a></li>@endif
                                @if($setting->youtube)<li><a href="{{ $setting->youtube }}"><em class="fab fa-youtube"></em></a></li>@endif

                            </ul>
                        </div>
                    </div>
                </div><!-- .block -->
            </div>
        </div>
        <!-- // -->
    </main>
@endsection

@section('js')
    <script>
        function submitContactForm(){
            var contactName = document.getElementById('contactName'), contactMassage = document.getElementById('contactMassage'),
                contactEmail = document.getElementById('contactEmail');

            if(contactName.value != '' && contactMassage.value != '' && contactEmail.value != ''){
                console.log(contactName);
                $('#submitContact').prop('disabled', true);
                $('#contactForm').submit();
            }
        }
    </script>
@endsection

