@extends('front.layout.app')

@section('title')
    @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.about'] }}@else{{ $menu['en']['view.about'] }}
    @endif
@stop

@section('slider')
     <!-- Banner  -->
     <div class="header-banner bg-theme-grad-s2">
        <div class="nk-banner">
            <div class="banner banner-page">
                <div class="banner-wrap">
                    <div class="container">
                        <div class="row justify-content-center align-items-center">
                            <div class="col-xl-6 col-lg-9">
                                <div class="banner-caption cpn tc-light text-center">
                                    <div class="cpn-head">
                                        @if($about)
                                        <h2 class="title ttu">
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $about->title_ar }}@else{{ $about->title }}
                                            @endif
                                        </h2>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- .nk-banner -->
        <div class="nk-ovm shape-z6-sm">
        </div>
    </div>
    <!-- .header-banner -->
    <!-- Secondary Menu  -->
    <div class="secondary-navbar">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <nav class="secondary-menu">
                        <ul class="secondary-menu-list">
                            <li class = "Secondary-menu-item"> <a href="{{ route('view.about') }}" class="secondary-menu-link menu-link"> {{ __('نبذة عنا') }} </a> </li>
                            <li class = "Secondary-menu-item"> <a href="{{ route('view.about-2') }}" class="secondary-menu-link menu-link"> {{ __('المهمة والرؤية') }} </a> </li>
                            <li class = "Secondary-menu-item"> <a href="{{ route('view.partners') }}" class="secondary-menu-link menu-link"> {{ __('الشركاء') }} </a> </li>
                            {{-- <li class = "Secondary-menu-item"> <a href="page-career.html" class="secondary-menu-link menu-link"> مهنة </a> </li> --}}
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- Secondary Menu -->
@endsection

@section('content')

<main class="nk-pages">
    @if($about)
    <section class="section pb-0 ov-h">
        <div class="container">
            <div class="nk-block">
                <div class="section-head text-center">
                    <h2 class="title">
                        @if (LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $about->sub_title_ar }}@else{{ $about->sub_title }}
                        @endif
                    </h2>
                </div>
                <div class="row gutter-vr-15px justify-content-center">
                    <div class="col-lg-12 col-mb-10">
                        <div class="nk-block-text">
                            <p>
                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $about->description_ar }}@else{{ $about->description }}
                                @endif
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- // -->
    @endif
    <section class="section section-team bg-white">
        <div class="container">
            <!-- Section Head @s -->
            <div class="section-head text-center wide-auto">
                <h2 class="title title-lg title-dark">{{ __('الفريق الأساسي') }}</h2>
            </div><!-- .section-head @e -->
            <!-- Block @s -->
            <div class="nk-block nk-block-team-list team-list">
                <div class="row justify-content-center">
                    @foreach($teams as $key => $team)
                    <div class="col-md-3 col-6">
                        <div class="team animated" data-animate="fadeInUp" data-delay=".2">
                            <div class="team-photo">
                                <img src="{{ asset('storage/'.$team->image) }}" alt="team">
                                <a href="#team-popup-{{ $key }}" class="team-show content-popup"></a>

                            </div>
                            <h5 class = "team-name title-sm">
                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $team->name_ar }}@else{{ $team->name }}
                                @endif
                            </h5>
                            <span class = "team-position">
                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $team->position_ar }}@else{{ $team->position }}
                                @endif
                            </span>
                        </div>
                        <!-- Start .team-profile  -->
                        <div id="team-popup-{{ $key }}" class="team-popup mfp-hide">
                            <a title="Close" class="mfp-close">×</a>
                            <div class="row align-items-start">
                                <div class="col-md-6">
                                    <div class="team-photo">
                                        <img src="{{ asset('storage/'.$team->image) }}" alt="team">
                                    </div>
                                </div><!-- .col  -->
                                <div class="col-md-6">
                                    <div class="team-popup-info ps-md-3">
                                        <h3 class="team-name title title-lg pt-4">
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $team->name_ar }}@else{{ $team->name }}
                                            @endif
                                        </h3>
                                        <p class="team-position">
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $team->position_ar }}@else{{ $team->position }}
                                            @endif
                                        </p>

                                        <p>
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $team->description_ar }}@else{{ $team->description }}
                                            @endif
                                        </p>
                                        {{-- <div class="progress-list">
                                            <div class="progress-wrap">
                                                <div class="progress-title">بلوكشين <span class="progress-amount">85%</span></div>
                                                <div class="progress-bar progress-bar-xs bg-black-10">
                                                    <div class="progress-percent bg-primary" data-percent="85"></div>
                                                </div>
                                            </div>
                                            <div class="progress-wrap">
                                                <div class="progress-title">اللامركزية <span class="progress-amount">68%</span></div>
                                                <div class="progress-bar progress-bar-xs bg-black-10">
                                                    <div class="progress-percent bg-primary" data-percent="68"></div>
                                                </div>
                                            </div>
                                        </div> --}}
                                    </div>
                                </div><!-- .col  -->
                            </div><!-- .row  -->
                        </div><!-- .team-profile  -->
                    </div><!-- .col -->
                    @endforeach
                </div><!-- .row -->
            </div>
            <!-- Block @r -->
        </div>
    </section>
    <!-- // -->
    {{-- <section class="section">
        <div class="container">
            <div class="nk-block nk-block-feature">
                <div class="row justify-content-center">
                    <div class="col-lg-8 col-mb-10">
                        <div class="section-head text-center">
                            <h2 class="title title-regular">اريد معرفة المزيد؟</h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-6 col-mb-10">
                        <div class="feature feature-inline card card-s3 flex-wrap flex-sm-nowrap">
                            <div class="feature-icon feature-icon-lg-s3 mt-0">
                                <img src="images/icons/icon-t12.png" alt="icon">
                            </div>
                            <div class="feature-text">
                                <h5 class = "title title-md"> الامتثال </h5>
                                    <p style="height: 55.78px;"> نعتقد أن الامتثال القانوني هو المفتاح لنمو التمويل الرقمي. </p>
                                    <a href="#" class="btn btn-secondary btn-md"> اعرف المزيد <em class = "ti ti-arrow-left pe-2"> </em> </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-mb-10">
                        <div class="feature feature-inline card card-s3 flex-wrap flex-sm-nowrap">
                            <div class="feature-icon feature-icon-lg-s3 mt-0">
                                <img src="images/icons/icon-t13.png" alt="icon">
                            </div>
                            <div class="feature-text">
                                <h5 class = "title title-md"> إدارة الأموال </h5>
                                    <p style="height: 55.78px;"> يعمل تشفير ICO على تبسيط لوريم إيبسوم دولور سوميت في التكرار. </p>
                                <a href="#" class="btn btn-secondary btn-md"> اعرف المزيد <em class = "ti ti-arrow-left pe-2"> </em> </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section> --}}
    <!-- // -->
</main>
@endsection
