{{-- @dd(old('service_name')) --}}
@extends('admin.layout.app')

@section('css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<script src="//cdn.ckeditor.com/4.16.0/full/ckeditor.js"></script>

@stop

@section('pageTitle')
<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">{{ __('Edit Subscription') }}</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Subscriptions') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Edit Subscription') }}</li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->
@stop

@section('content')

<div class="row justify-content-center">
    <div class="col-xxl-9">
        <div class="card">
            <form action="{{ route('c-panel.subscriptions.update', $subscription->id) }}" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate id="invoice_form">
                @csrf
                @method('PUT')
                <div class="card-body p-4">
                    <div class="row g-3 mb-5">
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="customer_id">{{ __('Customer') }}</label>
                                @can('createCustomer', App\Models\User::class)
                                <button type="button" class="btn btn-outline-success" style="padding: 0px 4px;margin: 6px 10px;" data-bs-toggle="modal" data-bs-target="#addSeller">
                                    <i class="ri-add-circle-line"></i>
                                </button>
                                @endcan
                                <select class="js-example-basic-single" name="customer_id">
                                    @foreach($customers as $customer)
                                        <option @if(old('customer_id', $subscription->user_id) == $customer->id) selected @endif value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="type">{{ __('Subscription Type') }}</label>
                                <select class="form-control " id="type" name="type">
                                    <option @if(old('type', $subscription->type) == '0') selected @endif value="0">{{ __('Service') }}</option>
                                    <option @if(old('type', $subscription->type) == '1') selected @endif value="1">{{ __('Domin') }}</option>
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <div id="service"  style="display: none;">
                        <div class="row g-3 mb-3" >
                            <div class="col-lg-4 col-sm-12">
                                <label for="group_id">{{ __('Services') }}</label>
                                <select class="form-control " id="group_id" name="group_id">
                                    <option value="">{{ __('Choose Service') }}</option>
                                    @foreach (App\Models\Group::get() as $group)
                                        <option @if(old('group_id', $subscription->plan->group_id ?? 0) == $group->id) selected @endif value="{{ $group->id }}">{{ $group->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <!--end col-->
                            <div class="col-lg-4 col-sm-12">
                                <label for="plan_id">{{ __('Plan') }}</label>
                                <select class="form-control " id="plan_id" name="plan_id">
                                    @if($subscription->plan_id)
                                        <option value="">{{ __('Choose Plan') }}</option>
                                        @foreach (App\Models\Plan::where('group_id', $subscription->plan->group_id)->get() as $plan)
                                            <option @if(old('plan_id', $subscription->plan_id ?? 0) == $plan->id) selected @endif value="{{ $plan->id }}">{{ $plan->title }}</option>
                                        @endforeach
                                    @else
                                        <option value="">{{ __('Choose Service First') }}</option>
                                    @endif
                                </select>
                            </div>
                            <!--end col-->
                            <div class="col-lg-4 col-sm-12">
                                <label for="price_type">{{ __('Price Type') }}</label>
                                <select class="form-control " id="price_type" name="price_type">
                                    @if($subscription->plan_id)
                                        <option value="">{{ __('Choose Period') }}</option>
                                        @foreach ($subscription->plan->prices as $price)
                                            @php
                                                $name = '';
                                                if($price->type == 1){
                                                    $name = __("Quarterly");
                                                } else if($price->type == 2) {
                                                    $name = __("Biannual");
                                                } else if($price->type == 3) {
                                                    $name = __("Annual");
                                                } else if($price->type == 4) {
                                                    $name = __("Two Years");
                                                } else if($price->type == 5) {
                                                    $name = __("Three Years");
                                                }
                                            @endphp
                                            <option @if(old('price_type', $subscription->price_type ?? 0) == $price->type) selected @endif value="{{ $price->type }}">{{ $name }}</option>
                                        @endforeach
                                    @else
                                    <option value="">{{ __('Choose Plan first') }}</option>
                                    @endif
                                </select>
                            </div>
                            <!--end col-->
                        </div>
                    </div>
                    <div id="domin" style="display: none;">
                        <div class="row g-3 mb-3" >
                            <div class="col-lg-12 col-sm-12">
                                <div>
                                    <label for="domin_id">{{ __('Domins') }}</label>
                                    <select class="form-control " id="domin_id" name="domin_id">
                                        <option value="">{{ __('Choose Domin') }}</option>
                                        @foreach (App\Models\Domin::get() as $domin)
                                            <option @if(old('domin_id', $subscription->domin_id) == $domin->id) selected @endif value="{{ $domin->id }}">{{ $domin->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!--end col-->
                        </div>
                    </div>
                    <div class="row g-3 mb-5">
                        <div class="col-lg-4 col-sm-12">
                            <div>
                                <label for="price">{{ __('Price') }}</label>
                                <input type="text" class="form-control" value="{{ $subscription->price }}" data-price="{{ $subscription->price }}" name="price" id="price" readonly>
                            </div> 
                        </div>
                        <div class="col-lg-4 col-sm-12">
                            <div>
                                <label for="tax">{{ __('Tax') }}</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="tax" onkeyup="calcPrice()" id="tax" value="{{ old('tax', $subscription->tax) }}">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-12">
                            <div>
                                <label for="discount">{{ __('Discount') }}</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="discount" onkeyup="calcPrice()" id="discount" value="{{ old('discount', $subscription->discount) }}">
                                    <span class="input-group-text">%</span> 
                                </div>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <div class="row g-3">
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="start_date">{{ __('Service Start Date') }}</label>
                                <input type="date" class="form-control " value="{{ old('start_date', $subscription->start_date) }}" id="start_date" name="start_date">
                            </div>{{ old('start_date', $subscription->start_date) }}
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="subscrip_date">{{ __('Subscription Date') }}</label>
                                <input type="date" class="form-control " value="{{ old('subscrip_date', $subscription->subscrip_date) }}" id="subscrip_date" name="subscrip_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="due_date">{{ __('Due Date') }}</label>
                                <input type="date" class="form-control " value="{{ old('due_date', $subscription->due_date) }}" id="due_date" name="due_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="end_date">{{ __('Service End Date') }}</label>
                                <input type="date" class="form-control " id="end_date" value="{{ old('end_date', $subscription->end_date) }}" name="end_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="status1">{{ __('Subscription Status') }}</label>
                                <select class="form-control" id="status1" name="status">
                                    <option @if(old('status', $subscription->status) == "0") selected @endif value="0">{{ __('Active') }}</option>
                                    <option @if(old('status', $subscription->status) == "1") selected @endif value="1">{{ __('Canceled') }}</option>
                                    <option @if(old('status', $subscription->status) == "2") selected @endif value="2">{{ __('Stopped') }}</option>
                                    <option @if(old('status', $subscription->status) == "3") selected @endif value="3">{{ __('Not Enabled') }}</option>
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="status1">{{ __('Payment Status') }}</label>
                                <select class="form-control" id="status_0" name="status_0">
                                    <option @if(old('status_0', $subscription->status_0) == "0") selected @endif value="0">{{ __('Paid') }}</option>
                                    <option @if(old('status_0', $subscription->status_0) == "1") selected @endif value="1">{{ __('Worthy') }}</option>
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                    <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                        <button type="submit" class="btn btn-success"><i class="ri-printer-line align-bottom me-1"></i> {{ __('Save') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!--end col-->
</div>
@can('createCustomer', App\Models\User::class)
 <!-- Modal -->
 <div class="modal fade zoomIn" id="addSeller" tabindex="-1" aria-labelledby="addSellerLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addSellerLabel">{{ __('Add Customer') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('c-panel.customers.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <label for="firstnameInput" class="form-label">{{ __('Image') }}</label>
                        <div class="col-lg-12">
                            <div class="mb-3">
                                <div class="position-relative d-inline-block">
                                    <input type='file' onchange="loadFile_image(image)" name="image" id="image"
                                        class="@error('image') is-invalid @enderror" style="display:none;" />
                                    <button id="output_image" type="button" class="bg-light"
                                        onclick="document.getElementById('image').click();" value="emad"
                                        style="
                                                width: 100px;
                                                height: 100px;
                                                border-radius: 2px;
                                                background-repeat: no-repeat;
                                                background-size: cover;
                                                background-position: center;
                                                border:none;
                                                "></button>
                                    <div class="position-absolute top-100 start-100 translate-middle">
                                        <label for="product-image-input"
                                            onclick="document.getElementById('image').click();" class="mb-0"
                                            title="Select Image">
                                            <div class="avatar-xs">
                                                <div
                                                    class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                    <i class="ri-image-fill"></i>
                                                </div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                <script>
                                    var loadFile_image = function(image) {
                                        var image = document.getElementById('output_image');
                                        var src = URL.createObjectURL(event.target.files[0]);
                                        image.style.backgroundImage = 'url(' + src + ')';
                                    };
                                </script>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">{{ __('Name') }}</label>
                                <input type="text" class="form-control" id="name" name="name"
                                    value="{{ old('name') }}" placeholder="{{ __('Enter customer name') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="department_id" class="form-label">{{ __('Department') }}</label>
                                <select class="form-control" name="department_id" id="department_id">
                                    @foreach (App\Models\Department::get() as $department)
                                        <option @if (old('department_id') == $department->id) selected @endif
                                            value="{{ $department->id }}">{{ $department->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="association" class="form-label">{{ __('Association') }}</label>
                                <input type="text" class="form-control" id="association" name="association"
                                    value="{{ old('association') }}"
                                    placeholder="{{ __('Enter association name') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                                <input type="text" class="form-control" id="phone" name="phone"
                                    value="{{ old('phone') }}" placeholder="{{ __('Enter phone number') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="country" class="form-label">{{ __('Country') }}</label>
                                <input type="text" class="form-control" id="country" name="country"
                                    value="{{ old('country') }}" placeholder="{{ __('Enter country') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="city" class="form-label">{{ __('City') }}</label>
                                <input type="text" class="form-control" id="city" name="city"
                                    value="{{ old('city') }}" placeholder="{{ __('Enter city') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="website" class="form-label">{{ __('Website') }}</label>
                                <input type="text" class="form-control" id="website" name="website"
                                    value="{{ old('website') }}" placeholder="{{ __('Enter website') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">{{ __('Email') }}</label>
                                <input type="email" class="form-control" id="email" name="email"
                                    value="{{ old('email') }}" placeholder="{{ __('Enter customer email') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="password" class="form-label">{{ __('Password') }}</label>
                                <input type="password" class="form-control" id="password" name="password"
                                    value="{{ old('password') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="password_confirmation"
                                    class="form-label">{{ __('Confirm Password') }}</label>
                                <input type="password" class="form-control" id="password_confirmation"
                                    name="password_confirmation" value="{{ old('password_confirmation') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-12">
                            <div class="hstack gap-2 justify-content-end">
                                <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                    data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                    {{ __('Close') }}</button>
                                <button type="submit" class="btn btn-primary"><i
                                        class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </form>
            </div>
        </div>
    </div>
</div>
<!--end modal-->
@endcan
@stop

@section('js')
<!-- cleave.js -->
<script src="{{ asset('assets/libs/cleave.js/cleave.min.js') }}"></script>

<!--Invoice create init js-->
<script>
    
        var type = document.getElementById('type'),
            service = document.getElementById('service'),
            domin = document.getElementById('domin');
            
            type.onchange = function () {
            selectService()
        };
        function selectService() {
            if(type.value == '0'){
                service.style.display = 'block';
                domin.style.display = 'none';
                $('#price').val('');
                document.getElementById('price').setAttribute('data-price',0);
                getPlanPrice($('#price_type').val(),$('#plan_id').val());
            } else {
                service.style.display = 'none';
                domin.style.display = "block";
                $('#price').val('');
                document.getElementById('price').setAttribute('data-price',0);
                getDominPrice($('#domin_id').val());
            }
        }

        

        // Department Change
        $('#group_id').change(function () {

            // Department id
            var id = $(this).val();
            getPlans(id);

        });

        // Department Change
        $('#plan_id').change(function () {

            // Department id
            var id = $(this).val();
            getPlanPrices(id);

        });

        // Department Change
        $('#price_type').change(function () {

            // Department id
            var price_type = $(this).val();
            var plan = $('#plan_id').val()

            getPlanPrice(price_type, plan);
        });

        // Department Change
        $('#domin_id').change(function () {

            // Department id
            var id = $(this).val();
            getDominPrice(id);

        });

        function getPlans(id){
            // AJAX request
            $.ajax({
                url: '/c-panel/group/ajax/' + id,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('');
                    document.getElementById('price').setAttribute('data-price',0);
                    $('#plan_id').empty();
                    $('#plan_id').append('<option value="">{{ __("Choose Plan") }}</option>')
                    $.each(data, function (key, value) {
                        // console.log(value.name)
                        $('#plan_id').append('<option value="' + value.id + '">' + value.title + '</option>')
                    });

                }
            });
        }

        function getPlanPrices(id){
            // AJAX request
            $.ajax({
                url: '/c-panel/plan/ajax/' + id,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('');
                    document.getElementById('price').setAttribute('data-price',0);
                    $('#price_type').empty();
                    $('#price_type').append('<option value="">{{ __("Choose Pierod") }}</option>')
                    $.each(data, function (key, value) {
                        // console.log(value.name)
                        var name = '';
                        if(value.type == 1){
                            name = '{{ __("Quarterly") }}';
                        } else if(value.type == 2) {
                            name = '{{ __("Biannual") }}';
                        } else if(value.type == 3) {
                            name = '{{ __("Annual") }}';
                        } else if(value.type == 4) {
                            name = '{{ __("Two Years") }}';
                        } else if(value.type == 5) {
                            name = '{{ __("Three Years") }}';
                        }

                        $('#price_type').append('<option value="' + value.type + '">' + name + '</option>')
                    });

                }
            });
        }

        function getPlanPrice(price_type, plan){
            // AJAX request
            $.ajax({
                url: '/c-panel/group/price/ajax/' + price_type + '/' + plan,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('')
                    $('#price').val(data.price);
                    document.getElementById('price').setAttribute('data-price',data.price);
                    calcPrice();
                }
            });
        }

        function getDominPrice(id){
            // AJAX request
            $.ajax({
                url: '/c-panel/domin/price/ajax/' + id,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('')
                    $('#price').val(data.price);
                    document.getElementById('price').setAttribute('data-price',data.price);
                    calcPrice();
                }
            });
        }

        window.onload = function() {
            selectService();
            calcPrice();
            if(type == '0'){
                getPlans($('#group_id').val());
                getPlanPrices($('#plan_id').val());
                getPlanPrice($('#price_type').val(),$('#plan_id').val());
            } else {
                getDominPrice($('#domin_id').val());
            }
        };


        function calcPrice(){
            var priceInput = document.getElementById('price');
            var tax = document.getElementById('tax');
            var discount = document.getElementById('discount');
            var price = document.getElementById('price').getAttribute('data-price');

            // console.log(price.value + '-' + discount.value + '-' + tax.value);
            if (discount.value < 0) discount.value = 0;
            if (discount.value > 100) discount.value = 100;
            if (tax.value < 0) tax.value = 0;
            if (tax.value > 100) tax.value = 100;

            var totelTax = 0, totelDiscount = 0;
            var totelValue = 0;

            if(discount.value)
            {
                totelDiscount = (discount.value * price)/100;
            }

            if(tax.value)
            {
                totelTax = (tax.value * price)/100;
            }

            totelValue = (parseFloat(price) + parseFloat(totelTax)) - parseFloat(totelDiscount);

            priceInput.value = Number(totelValue.toFixed(2));
        }

</script>

<!--select2 cdn-->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script src="{{ asset('assets/js/pages/select2.init.js') }}"></script>
@stop
