{{-- @dd(old('service_name')) --}}
@extends('admin.layout.app')

@section('css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<script src="//cdn.ckeditor.com/4.16.0/full/ckeditor.js"></script>

@stop

@section('pageTitle')
<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">{{ __('Edit Offer') }}</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Offers') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Edit Offer') }}</li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->
@stop

@section('content')

<div class="row justify-content-center">
    <div class="col-xxl-9">
        <div class="card">
            <form action="{{ route('c-panel.offers.update', $offer->id) }}" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate id="invoice_form">
                @csrf
                <div class="card-body p-4">
                    <div class="row g-3 mb-5">
                        <div class="col-lg-4 col-sm-12">
                            <div>
                                <label for="customer_id">{{ __('Customer') }}</label>
                                @can('createCustomer', App\Models\User::class)
                                <button type="button" class="btn btn-outline-success" style="padding: 0px 4px;margin: 6px 10px;" data-bs-toggle="modal" data-bs-target="#addSeller">
                                    <i class="ri-add-circle-line"></i>
                                </button>
                                @endcan
                                <select class="js-example-basic-single" name="customer_id">
                                    @foreach($customers as $customer)
                                        <option @if(old('customer_id', $offer->customer_id) == $customer->id) selected @endif value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="date">{{ __('Date Offer') }}</label>
                                <input type="date" class="form-control " value="{{ old('date', $offer->date) }}" id="date" name="date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="end_date">{{ __('End Date') }}</label>
                                <input type="date" class="form-control " id="end_date" value="{{ old('end_date', $offer->end_date) }}" name="end_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <label for="currancy">{{ __('Currency') }}</label>
                            <div class="input-light">
                                <select class="form-control " id="currancy" name="currancy" required>
                                    <option @if(old('currancy', $offer->currancy) == "0") selected @endif value="0">{{ __('Doller') }}</option>
                                    <option @if(old('currancy', $offer->currancy) == "1") selected @endif value="1">{{ __('SAR') }}</option>
                                    <option @if(old('currancy', $offer->currancy) == "2") selected @endif value="2">{{ __('ILS') }}</option>
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="file">{{ __('File') }}</label>
                                @if($offer->file)
                                <a href="{{ asset('storage/'.$offer->file) }}" target="_blank" class="btn btn-outline-success" style="padding: 0px 10px;margin: 6px 10px;">
                                    {{ __('View File') }} <i class="ri-file-text-line"></i>
                                </a>
                                @endif
                                <input type="file" class="form-control" id="file" name="file">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-12 col-sm-12">
                            <label for="currancy">{{ __('Description') }}</label>
                            <textarea class="form-control" name="description" id="description" rows="3">{{ old('description', $offer->description) }}</textarea>
                        </div>
                        <script>
                            CKEDITOR.replace('description');
                        </script>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="invoice-table table table-borderless table-nowrap mb-0">
                            <thead class="align-middle">
                                <tr class="table-active">
                                    <th scope="col" style="width: 50px;">#</th>
                                    <th scope="col">
                                        {{ __('Service Details') }}
                                    </th>
                                    <th scope="col" style="width: 120px;">{{ __('Price') }}</th>
                                    <th scope="col" style="width: 120px;">{{ __('Period') }}</th>
                                    <th scope="col" style="width: 120px;">{{ __('Discount') }}</th>
                                    <th scope="col" style="width: 120px;">{{ __('Tax') }}</th>
                                    <th scope="col" style="width: 120px;">{{ __('Totel') }}</th>
                                    <th scope="col" style="width: 120px;"></th>
                                </tr>
                            </thead>
                            <tbody id="newlink">
                                @if(old('service_name') && count(old('service_name')) != 0)
                                    @foreach(old('service_name') as $key => $item)
                                        <tr id="{{ $key+1 }}" class="product">
                                            <th scope="row" class="product-id">{{ $key+1 }}</th>
                                            <td class="text-start">
                                                <div class="mb-2">
                                                    <input type="text" class="form-control bg-light border-0" id="serviceName-{{ $key+1 }}" value="{{ old('service_name')[$key] }}" name="service_name[]" placeholder="{{ __('Name') }}" required />
                                                    <div class="invalid-feedback">
                                                        {{ __('Please enter a service name') }}
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control product-price bg-light border-0" value="{{ old('service_price')[$key] }}" onkeyup="calc({{ $key+1 }})" id="servicePrice-{{ $key+1 }}" name="service_price[]"  step="0.01" placeholder="0" required />
                                                <div class="invalid-feedback">
                                                    {{ __('Please enter a price') }}
                                                </div>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control product-period bg-light border-0" id="servicePeriod-{{ $key+1 }}" name="service_period[]" value="{{ old('service_period')[$key] }}" required />
                                                <div class="invalid-feedback">
                                                    {{ __('Please enter a period') }}
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" id="serviceDiscount-{{ $key+1 }}" onkeyup="calc({{ $key+1 }})" name="service_discount[]" value="{{ old('service_discount')[$key] }}" placeholder="0" step="0.01" >
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" id="serviceTax-{{ $key+1 }}" onkeyup="calc({{ $key+1 }})" name="service_tax[]" value="{{ old('service_tax')[$key] }}" placeholder="0" step="0.01" >
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </td>
                                            <td class="text-end">
                                                <div>
                                                    <input type="text" class="form-control bg-light border-0 product-line-price" id="serviceTotel-{{ $key+1 }}" name="service_totel[]" value="{{ old('service_totel')[$key] }}" readonly />
                                                </div>
                                            </td>
                                            <td class="product-removal">
                                                <a href="javascript:void(0)" class="btn btn-success">{{ __('Delete') }}</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @elseif($offer->services)
                                    @foreach($offer->services as $key => $item)
                                        <tr id="{{ $key+1 }}" class="product">
                                            <th scope="row" class="product-id">{{ $key+1 }}</th>
                                            <td class="text-start">
                                                <div class="mb-2">
                                                    <input type="text" class="form-control bg-light border-0" id="serviceName-{{ $key+1 }}" value="{{ $item->name }}" name="service_name[]" placeholder="{{ __('Name') }}" required />
                                                    <div class="invalid-feedback">
                                                        {{ __('Please enter a service name') }}
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control product-price bg-light border-0" value="{{ $item->price }}" onkeyup="calc({{ $key+1 }})" id="servicePrice-{{ $key+1 }}" name="service_price[]"  step="0.01" placeholder="0" required />
                                                <div class="invalid-feedback">
                                                    {{ __('Please enter a price') }}
                                                </div>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control product-period bg-light border-0" id="servicePeriod-{{ $key+1 }}" name="service_period[]" value="{{ $item->period }}" required />
                                                <div class="invalid-feedback">
                                                    {{ __('Please enter a period') }}
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" id="serviceDiscount-{{ $key+1 }}" onkeyup="calc({{ $key+1 }})" name="service_discount[]" value="{{ $item->discount }}" placeholder="0" step="0.01" >
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" id="serviceTax-{{ $key+1 }}" onkeyup="calc({{ $key+1 }})" name="service_tax[]" value="{{ $item->tax }}" placeholder="0" step="0.01" >
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </td>
                                            <td class="text-end">
                                                <div>
                                                    <input type="text" class="form-control bg-light border-0 product-line-price" id="serviceTotel-{{ $key+1 }}" name="service_totel[]" value="{{ $item->totel }}" readonly />
                                                </div>
                                            </td>
                                            <td class="product-removal">
                                                <a href="javascript:void(0)" class="btn btn-success">{{ __('Delete') }}</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr id="1" class="product">
                                        <th scope="row" class="product-id">1</th>
                                        <td class="text-start">
                                            <div class="mb-2">
                                                <input type="text" class="form-control bg-light border-0" id="serviceName-1" name="service_name[]" placeholder="{{ __('Name') }}" required />
                                                <div class="invalid-feedback">
                                                    {{ __('Please enter a service name') }}
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control product-price bg-light border-0" onkeyup="calc(1)" id="servicePrice-1" name="service_price[]"  step="0.01" placeholder="0" required />
                                            <div class="invalid-feedback">
                                                {{ __('Please enter a price') }}
                                            </div>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control product-period bg-light border-0" id="servicePeriod-1" name="service_period[]" required />
                                            <div class="invalid-feedback">
                                                {{ __('Please enter a period') }}
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="serviceDiscount-1" onkeyup="calc(1)" name="service_discount[]" placeholder="0" step="0.01" >
                                                <span class="input-group-text">%</span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="serviceTax-1" onkeyup="calc(1)" name="service_tax[]" placeholder="0" step="0.01" >
                                                <span class="input-group-text">%</span>
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <div>
                                                <input type="text" class="form-control bg-light border-0 product-line-price" id="serviceTotel-1" name="service_totel[]" placeholder="0" readonly />
                                            </div>
                                        </td>
                                        <td class="product-removal">
                                            <a href="javascript:void(0)" class="btn btn-success">{{ __('Delete') }}</a>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                            <tbody>
                                <tr id="newForm" style="display: none;"><td class="d-none" colspan="5"><p>{{ __('Add New Form') }}</p></td></tr>
                                <tr>
                                    <td colspan="8">
                                        <a href="javascript:new_link()" id="add-item" class="btn btn-soft-secondary fw-medium"><i class="ri-add-fill me-1 align-bottom"></i> {{ __('Add Item') }}</a>
                                    </td>
                                </tr>
                                <tr class="border-top border-top-dashed mt-2">
                                    <td colspan="6"></td>
                                    <td colspan="2" class="p-0">
                                        <table class="table table-borderless table-sm table-nowrap align-middle mb-0">
                                            <tbody>
                                                <tr>
                                                    <th scope="row">{{ __('Total Price') }}</th>
                                                    <td style="width:150px;">
                                                        <input type="number" class="form-control bg-light border-0" id="totel" value="{{ $offer->totel }}" name="totel" placeholder="0.00" readonly />
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <!--end table-->
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <!--end table-->
                    </div>

                    <div class="row g-3">
                        <div class="col-lg-12 col-sm-12">
                            <label for="currancy">{{ __('Implementation Terms') }}</label>
                            <textarea class="form-control" name="note" id="note" rows="3">{{ old('note', $offer->note) }}</textarea>
                        </div>
                        <script>
                            CKEDITOR.replace('note');
                        </script>
                        <!--end col-->
                    </div>
                    <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                        <button type="submit" class="btn btn-success"><i class="ri-printer-line align-bottom me-1"></i> {{ __('Save') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!--end col-->
</div>

@can('createCustomer', App\Models\User::class)
 <!-- Modal -->
 <div class="modal fade zoomIn" id="addSeller" tabindex="-1" aria-labelledby="addSellerLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addSellerLabel">{{ __('Add Customer') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('c-panel.customers.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <label for="firstnameInput" class="form-label">{{ __('Image') }}</label>
                        <div class="col-lg-12">
                            <div class="mb-3">
                                <div class="position-relative d-inline-block">
                                    <input type='file' onchange="loadFile_image(image)" name="image" id="image"
                                        class="@error('image') is-invalid @enderror" style="display:none;" />
                                    <button id="output_image" type="button" class="bg-light"
                                        onclick="document.getElementById('image').click();" value="emad"
                                        style="
                                                width: 100px;
                                                height: 100px;
                                                border-radius: 2px;
                                                background-repeat: no-repeat;
                                                background-size: cover;
                                                background-position: center;
                                                border:none;
                                                "></button>
                                    <div class="position-absolute top-100 start-100 translate-middle">
                                        <label for="product-image-input"
                                            onclick="document.getElementById('image').click();" class="mb-0"
                                            title="Select Image">
                                            <div class="avatar-xs">
                                                <div
                                                    class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                    <i class="ri-image-fill"></i>
                                                </div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                <script>
                                    var loadFile_image = function(image) {
                                        var image = document.getElementById('output_image');
                                        var src = URL.createObjectURL(event.target.files[0]);
                                        image.style.backgroundImage = 'url(' + src + ')';
                                    };
                                </script>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">{{ __('Name') }}</label>
                                <input type="text" class="form-control" id="name" name="name"
                                    value="{{ old('name') }}" placeholder="{{ __('Enter customer name') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="department_id" class="form-label">{{ __('Department') }}</label>
                                <select class="form-control" name="department_id" id="department_id">
                                    @foreach (App\Models\Department::get() as $department)
                                        <option @if (old('department_id') == $department->id) selected @endif
                                            value="{{ $department->id }}">{{ $department->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="association" class="form-label">{{ __('Association') }}</label>
                                <input type="text" class="form-control" id="association" name="association"
                                    value="{{ old('association') }}"
                                    placeholder="{{ __('Enter association name') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                                <input type="text" class="form-control" id="phone" name="phone"
                                    value="{{ old('phone') }}" placeholder="{{ __('Enter phone number') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="country" class="form-label">{{ __('Country') }}</label>
                                <input type="text" class="form-control" id="country" name="country"
                                    value="{{ old('country') }}" placeholder="{{ __('Enter country') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="city" class="form-label">{{ __('City') }}</label>
                                <input type="text" class="form-control" id="city" name="city"
                                    value="{{ old('city') }}" placeholder="{{ __('Enter city') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="website" class="form-label">{{ __('Website') }}</label>
                                <input type="text" class="form-control" id="website" name="website"
                                    value="{{ old('website') }}" placeholder="{{ __('Enter website') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">{{ __('Email') }}</label>
                                <input type="email" class="form-control" id="email" name="email"
                                    value="{{ old('email') }}" placeholder="{{ __('Enter customer email') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="password" class="form-label">{{ __('Password') }}</label>
                                <input type="password" class="form-control" id="password" name="password"
                                    value="{{ old('password') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="password_confirmation"
                                    class="form-label">{{ __('Confirm Password') }}</label>
                                <input type="password" class="form-control" id="password_confirmation"
                                    name="password_confirmation" value="{{ old('password_confirmation') }}">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-12">
                            <div class="hstack gap-2 justify-content-end">
                                <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                    data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                    {{ __('Close') }}</button>
                                <button type="submit" class="btn btn-primary"><i
                                        class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </form>
            </div>
        </div>
    </div>
</div>
<!--end modal-->
@endcan
@stop

@section('js')
<!-- cleave.js -->
<script src="{{ asset('assets/libs/cleave.js/cleave.min.js') }}"></script>

<!--Invoice create init js-->
<script>
    var count = 1;
    document.addEventListener("DOMContentLoaded", function(){
        @if(old('service_name') && count(old('service_name')) != 0)
            @foreach(old('service_name') as $key => $item)
                calc({{ $key+1 }});
            @endforeach
        @endif
        remove();
        resetRow();
    });

    @if(old('service_name') && count(old('service_name')) != 0)
        @foreach(old('service_name') as $key => $item)
            @if($key != 0)
                count++;
            @endif
        @endforeach
    @elseif($offer->services && count($offer->services) != 0)
        @foreach($offer->services as $key => $item)
            @if($key != 0)
                count++;
            @endif
        @endforeach
    @endif

    function new_link() {
        count++;
        var e = document.createElement("tr"),
            t = (e.id = count, e.className = "product", '<tr><th scope="row" class="product-id">' + count + '</th><td class="text-start"><div class="mb-2"><input class="form-control bg-light border-0" type="text" name="service_name[]" id="serviceName-' + count + '" placeholder="{{ __("Name") }}"></div></div></td><td><input class="form-control bg-light border-0 product-price" type="number" name="service_price[]" onkeyup="calc(' + count + ')" id="servicePrice-' + count + '" step="0.01" placeholder="0"></td><td><input type="text" class="form-control product-period bg-light border-0" id="servicePeriod-' + count + '" name="service_period[]" required /></td><td><div class="input-group"><input type="text" class="form-control" id="serviceDiscount-' + count + '" name="service_discount[]" onkeyup="calc(' + count + ')" placeholder="0" step="0.01" ><span class="input-group-text">%</span></div></td><td><div class="input-group"><input type="text" class="form-control" id="serviceTax-' + count + '" name="service_tax[]" onkeyup="calc(' + count + ')" placeholder="0" step="0.01" ><span class="input-group-text">%</span></div></td><td><div><input type="text" class="form-control bg-light border-0 product-line-price" name="service_totel[]" id="serviceTotel-' + count + '" placeholder="0" readonly /></div></td><td class="product-removal"><a class="btn btn-success">{{ __("Delete") }}</a></td></tr>'),
            t = (e.innerHTML = document.getElementById("newForm").innerHTML + t, document.getElementById("newlink").appendChild(e), document.querySelectorAll("[data-trigger]"));
        Array.from(t).forEach(function(e) {
            new Choices(e, {
                placeholderValue: "This is a placeholder set in the config",
                searchPlaceholderValue: "This is a search placeholder"
            })
        }), remove(), resetRow()
    }

    function remove() {
        Array.from(document.querySelectorAll(".product-removal a")).forEach(function(e) {
            e.addEventListener("click", function(e) {
                count--;
                removeItem(e), resetRow(), totelCalc()
            })
        })
    }

    function removeItem(e) {
        e.target.closest("tr").remove()
    }

    function resetRow() {
        Array.from(document.getElementById("newlink").querySelectorAll("tr")).forEach(function(e, t) {
            t += 1;
            e.querySelector(".product-id").innerHTML = t
        })
    }

    function totelCalc() {
        var totelPrice = document.getElementById("totel"), totelValue = 0;
        Array.from(document.getElementsByClassName("product")).forEach(function(e) {
            Array.from(e.getElementsByClassName("product-line-price")).forEach(function(e) {
                e.value && (totelValue += parseFloat(e.value))
            })
        })

        totelPrice.value = Number(totelValue.toFixed(2));
    }

    function calc(id){
        var price = document.getElementById("servicePrice-" + id),
            discount = document.getElementById("serviceDiscount-"+id),
            tax = document.getElementById("serviceTax-"+id),
            totel = document.getElementById("serviceTotel-"+id);


        if (discount.value < 0) discount.value = 0;
        if (discount.value > 100) discount.value = 100;
        if (tax.value < 0) tax.value = 0;
        if (tax.value > 100) tax.value = 100;

        var totelTax = 0, totelDiscount = 0;

        if(discount.value)
        {
            totelDiscount = (discount.value * price.value)/100;
        }


        totelWithDiscount = price.value - totelDiscount;

        if(tax.value)
        {
            totelTax = (tax.value * totelWithDiscount)/100;
        }

        var totelValue = totelWithDiscount + totelTax;

        totel.value = Number(totelValue.toFixed(2));

        totelCalc();

    }

</script>

<!--select2 cdn-->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script src="{{ asset('assets/js/pages/select2.init.js') }}"></script>
@stop
