<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
        data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        {{-- <li>
            <a href="#!" class="dropdown-item">
                {{ __('View') }} <i class="ri-eye-fill align-bottom me-2 text-muted"></i>
            </a>
        </li> --}}
        @can('update', $item)
        <li>
            <a href="{{ route('c-panel.offers.edit', $item->id) }}" class="dropdown-item edit-item-btn">
                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> {{ __('Edit') }}
            </a>
        </li>
        @endcan
        @can('delete', $item)
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $item->id }}">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> {{ __('Delete') }}
            </a>
        </li>
        @endcan
        @can('admin', App\Models\User::class)
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#update-status{{ $item->id }}">
                <i class="ri-tools-fill align-bottom me-2 text-muted"></i> {{ __('Update Status') }}
            </a>
        </li>
        @endcan
        @can('admin', App\Models\User::class)
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#convert-invoice-{{ $item->id }}">
                <i class="ri-refresh-line align-bottom me-2 text-muted"></i> {{ __('Convert to Invoice') }}
            </a>
        </li>
        @endcan
    </ul>
</div>


@can('delete', $item)
<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-{{ $item->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" {{ route('c-panel.offers.destroy',$item->id) }}"
                    method="POST">
                    @csrf
                    @method('DELETE')
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4>{{ __('Are you Sure ?') }}</h4>
                            <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Remove this Record ?') }}</p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn w-sm btn-danger " id="delete-record">{{ __('Yes, Delete It!') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
@endcan


@can('admin', App\Models\User::class)
<div class="modal fade" id="update-status{{ $item->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light p-3">
                <h5 class="modal-title" id="exampleModalLabel">{{ __('Update Status') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
            </div>
            <form action="{{ route('c-panel.offers.update-status', $item->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label">{{ __('Status') }}</label>
                        <select name="status" id="status{{ $item->id }}" class="form-select">
                            <option @if($item->status == 0) selected @endif value="0">{{ __('New Offer') }}</option>
                            <option @if($item->status == 1) selected @endif value="1">{{ __('Under Review') }}</option>
                            <option @if($item->status == 2) selected @endif value="2">{{ __('Under Update') }}</option>
                            <option @if($item->status == 3) selected @endif value="3">{{ __('Accepted') }}</option>
                            <option @if($item->status == 4) selected @endif value="4">{{ __('Rejected') }}</option>
                            <option @if($item->status == 5) selected @endif value="5">{{ __('Canceled') }}</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="hstack gap-2 justify-content-end">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-success" id="add-btn">{{ __('Update') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endcan


@can('admin', App\Models\User::class)
<!-- Delete Modal -->
<div class="modal fade zoomIn" id="convert-invoice-{{ $item->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" {{ route('c-panel.offers.update-status',$item->id) }}"
                    method="POST">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="status" value="6">
                    <div class="mt-2 text-center">
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4>{{ __('Are you Sure ?') }}</h4>
                            <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Convert?') }}</p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn w-sm btn-success " id="delete-record">{{ __('Yes, Convert It!') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
@endcan
