{{-- @dd(old('service_name')) --}}
@extends('admin.layout.app')


@section('pageTitle')
<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">{{ __('Create Plan') }}</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $group->name }}</a></li>
                    <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Plans') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Create Plan') }}</li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->
@stop

@section('content')

<div class="row justify-content-center">
    <div class="col-xxl-9">
        <div class="card">
            <form action="{{ route('c-panel.plans.store', $group->id) }}" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate id="invoice_form">
                @csrf
                <div class="card-body p-4">
                    <div class="row g-3">
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="title">{{ __('Plan Title') }}</label>
                                <input type="text" class="form-control " value="{{ old('title') }}" id="title" name="title">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="description">{{ __('Description') }}</label>
                                <input type="text" class="form-control" value="{{ old('description') }}" id="description"  name="description">
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="invoice-table table table-borderless table-nowrap mb-0 text-center">
                            <thead class="align-middle">
                                <tr class="table-active">
                                    <th scope="col" style="width: 20%;">{{ __('Quarterly') }}</th>
                                    <th scope="col" style="width: 20%;">{{ __('Biannual') }}</th>
                                    <th scope="col" style="width: 20%;">{{ __('Annual') }}</th>
                                    <th scope="col" style="width: 20%;">{{ __('Two Years') }}</th>
                                    <th scope="col" style="width: 20%;">{{ __('Three Years') }}</th>
                                </tr>
                            </thead>
                            <tbody class="align-middle">
                                <tr style="height: 62.5px">
                                    <td>
                                        <input type="text" class="form-control" name="price_1" id="price_1" value="{{ old('price_1') }}" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_2" id="price_2" value="{{ old('price_2') }}" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_3" id="price_3" value="{{ old('price_3') }}" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_4" id="price_4" value="{{ old('price_4') }}" style="display: none;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="price_5" id="price_5" value="{{ old('price_5') }}" style="display: none;">
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot class="align-middle">
                                <tr>
                                    <td><input type="checkbox" name="check_1" onchange="showPrice()" id="check_1" @if(old('check_1')) checked @endif value="1"></td>
                                    <td><input type="checkbox" name="check_2" onchange="showPrice()" id="check_2" @if(old('check_2')) checked @endif value="1"></td>
                                    <td><input type="checkbox" name="check_3" onchange="showPrice()" id="check_3" @if(old('check_3')) checked @endif value="1"></td>
                                    <td><input type="checkbox" name="check_4" onchange="showPrice()" id="check_4" @if(old('check_4')) checked @endif value="1"></td>
                                    <td><input type="checkbox" name="check_5" onchange="showPrice()" id="check_5" @if(old('check_5')) checked @endif value="1"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="invoice-table table table-borderless table-nowrap mb-0">
                            <thead class="align-middle">
                                <tr class="table-active">
                                    <th scope="col" style="width: 50px;">#</th>
                                    <th scope="col">{{ __('Features') }}</th>
                                    <th scope="col" style="width: 120px;"></th>
                                </tr>
                            </thead>
                            <tbody id="newlink">
                                @if(old('features') && count(old('features')) != 0)
                                    @foreach(old('features') as $key => $item)
                                        <tr id="{{ $key+1 }}" class="product">
                                            <th scope="row" class="product-id">{{ $key+1 }}</th>
                                            <td class="text-start">
                                                <div class="mb-2">
                                                    <input type="text" class="form-control bg-light border-0" id="feature-{{ $key+1 }}" value="{{ old('features')[$key] }}" name="features[]" required />
                                                </div>
                                            </td>
                                            <td class="product-removal">
                                                <a href="javascript:void(0)" class="btn btn-success">{{ __('Delete') }}</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr id="1" class="product">
                                        <th scope="row" class="product-id">1</th>
                                        <td class="text-start">
                                            <div class="mb-2">
                                                <input type="text" class="form-control bg-light border-0" id="feature-1" name="features[]" required />
                                            </div>
                                        </td>
                                        <td class="product-removal">
                                            <a href="javascript:void(0)" class="btn btn-success">{{ __('Delete') }}</a>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                            <tbody>
                                <tr id="newForm" style="display: none;"><td class="d-none" colspan="5"><p>{{ __('Add New Form') }}</p></td></tr>
                                <tr>
                                    <td colspan="8">
                                        <a href="javascript:new_link()" id="add-item" class="btn btn-soft-secondary fw-medium"><i class="ri-add-fill me-1 align-bottom"></i> {{ __('Add Item') }}</a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <!--end table-->
                    </div>

                    <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                        <button type="submit" class="btn btn-success"><i class="ri-printer-line align-bottom me-1"></i> {{ __('Save') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!--end col-->
</div>

@stop

@section('js')
<!-- cleave.js -->
<script src="{{ asset('assets/libs/cleave.js/cleave.min.js') }}"></script>

<!--Invoice create init js-->
<script>
    var count = 1;
    document.addEventListener("DOMContentLoaded", function(){
        @if(old('features') && count(old('features')) != 0)
            @foreach(old('features') as $key => $item)
                calc({{ $key+1 }});
            @endforeach
        @endif
        remove();
        resetRow();
        showPrice();
    });

    @if(old('features') && count(old('features')) != 0)
        @foreach(old('features') as $key => $item)
            @if($key != 0)
                count++;
            @endif
        @endforeach
    @endif

    function new_link() {
        count++;
        var e = document.createElement("tr"),
            t = (e.id = count, e.className = "product", '<tr><th scope="row" class="product-id">' + count + '</th><td class="text-start"><div class="mb-2"><input class="form-control bg-light border-0" type="text" name="features[]" id="feature-' + count + '" ></div></td><td class="product-removal"><a class="btn btn-success">{{ __("Delete") }}</a></td></tr>'),
            t = (e.innerHTML = document.getElementById("newForm").innerHTML + t, document.getElementById("newlink").appendChild(e), document.querySelectorAll("[data-trigger]"));
        Array.from(t).forEach(function(e) {
            new Choices(e, {
                placeholderValue: "This is a placeholder set in the config",
                searchPlaceholderValue: "This is a search placeholder"
            })
        }), remove(), resetRow()
    }

    function remove() {
        Array.from(document.querySelectorAll(".product-removal a")).forEach(function(e) {
            e.addEventListener("click", function(e) {
                count--;
                removeItem(e), resetRow()
            })
        })
    }

    function removeItem(e) {
        e.target.closest("tr").remove()
    }

    function resetRow() {
        Array.from(document.getElementById("newlink").querySelectorAll("tr")).forEach(function(e, t) {
            t += 1;
            e.querySelector(".product-id").innerHTML = t
        })
    }

    function showPrice() {
        // Get the checkbox
        var check_1 = document.getElementById("check_1");
        var check_2 = document.getElementById("check_2");
        var check_3 = document.getElementById("check_3");
        var check_4 = document.getElementById("check_4");
        var check_5 = document.getElementById("check_5");
        // Get the output text
        var price_1 = document.getElementById("price_1");
        var price_2 = document.getElementById("price_2");
        var price_3 = document.getElementById("price_3");
        var price_4 = document.getElementById("price_4");
        var price_5 = document.getElementById("price_5");

        // If the checkbox is checked, display the output text
        if (check_1.checked == true){
            price_1.style.display = "block";
        } else {
            price_1.style.display = "none";
            price_1.value = "";
        }

        if (check_2.checked == true){
            price_2.style.display = "block";
        } else {
            price_2.style.display = "none";
            price_2.value = "";
        }

        if (check_3.checked == true){
            price_3.style.display = "block";
        } else {
            price_3.style.display = "none";
            price_3.value = "";
        }

        if (check_4.checked == true){
            price_4.style.display = "block";
        } else {
            price_4.style.display = "none";
            price_4.value = "";
        }

        if (check_5.checked == true){
            price_5.style.display = "block";
        } else {
            price_5.style.display = "none";
            price_5.value = "";
        }

    }

</script>

@stop
