@extends('admin.layout.app')

@section('content')

    <div class="col-xxl-9">
        <div class="card mt-xxl-n5">
            <div class="card-header">
                <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#generalSetting" role="tab">
                            <i class="fas fa-home"></i> {{ __('About Us') }}
                        </a>
                    </li>
                </ul>
            </div>
            <div class="card-body p-4">
                <form action="{{ route('c-panel.about') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="tab-content">
                        <div class="tab-pane active" id="generalSetting" role="tabpanel">
                            <div class="row">
                                <div class="col-lg-12">
                                    <label for="image">{{ __('Image') }}</label>
                                    <div class="mb-3">
                                        <div class="position-relative d-inline-block" style="width: 30%">
                                            <input type='file' onchange="loadFile_image(image)" name="image"
                                                id="image" class="@error('image') is-invalid @enderror"
                                                style="display:none;" />
                                            <button id="output_image" type="button" class="bg-light"
                                                onclick="document.getElementById('image').click();" value="emad"
                                                style="
                                            width: 100%;
                                            height: 150px;
                                            border-radius: 2px;
                                            background-repeat: no-repeat;
                                            @if($about->image) background-image: url({{ asset('storage/' . ($about->image ?? '')) }}); @endif
                                            background-size: cover;
                                            background-position: center;
                                            border:none;
                                            "></button>
                                            <div class="position-absolute top-100 start-100 translate-middle">
                                                <label for="product-image-input"
                                                    onclick="document.getElementById('image').click();" class="mb-0"
                                                    title="Select Image">
                                                    <div class="avatar-xs">
                                                        <div
                                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                            <i class="ri-image-fill"></i>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <script>
                                            var loadFile_image = function(image) {
                                                var image = document.getElementById('output_image');
                                                var src = URL.createObjectURL(event.target.files[0]);
                                                image.style.backgroundImage = 'url(' + src + ')';
                                            };
                                        </script>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">{{ __('English Title') }}</label>
                                        <input type="text" class="form-control" id="title" name="title"
                                            value="{{ old('title', $about->title ?? '') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="title_ar" class="form-label">{{ __('Arabic Title') }}</label>
                                        <input type="text" class="form-control" id="title_ar" name="title_ar"
                                            value="{{ old('title_ar', $about->title_ar ?? '') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="sub_title" class="form-label">{{ __('English Sub Title') }}</label>
                                        <input type="text" class="form-control" id="sub_title" name="sub_title"
                                            value="{{ old('sub_title', $about->sub_title ?? '') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="sub_title_ar" class="form-label">{{ __('Arabic Sub Title') }}</label>
                                        <input type="text" class="form-control" id="sub_title_ar" name="sub_title_ar"
                                            value="{{ old('sub_title_ar', $about->sub_title_ar ?? '') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="description" class="form-label">{{ __('English Description') }}</label>
                                        <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $about->description ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="description_ar"
                                            class="form-label">{{ __('Arabic Description') }}</label>
                                        <textarea class="form-control" id="description_ar" name="description_ar" rows="3">{{ old('description_ar', $about->description_ar ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="vision" class="form-label">{{ __('English Vision') }}</label>
                                        <textarea class="form-control" id="vision" name="vision" rows="3">{{ old('vision', $about->vision ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="vision_ar" class="form-label">{{ __('Arabic Vision') }}</label>
                                        <textarea class="form-control" id="vision_ar" name="vision_ar" rows="3">{{ old('vision_ar', $about->vision_ar ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="mission" class="form-label">{{ __('English Mission') }}</label>
                                        <textarea class="form-control" id="mission" name="mission" rows="3">{{ old('mission', $about->mission ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="mission_ar" class="form-label">{{ __('Arabic Mission') }}</label>
                                        <textarea class="form-control" id="mission_ar" name="mission_ar" rows="3">{{ old('mission_ar', $about->mission_ar ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="message" class="form-label">{{ __('English Message') }}</label>
                                        <textarea class="form-control" id="message" name="message" rows="3">{{ old('message', $about->message ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3 pb-2">
                                        <label for="message_ar" class="form-label">{{ __('Arabic Message') }}</label>
                                        <textarea class="form-control" id="message_ar" name="message_ar" rows="3">{{ old('message_ar', $about->message_ar ?? '') }}</textarea>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </div>
                        <!--end tab-pane-->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!--end col-->
@stop


@section('js')
    <!-- profile-setting init js -->
    <script src="{{ asset('assets/js/pages/profile-setting.init.js') }}"></script>
@stop
