<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'type', 'domin_id', 'plan_id', 'price_type', 'price',
        'start_date', 'subscrip_date', 'due_date', 'end_date', 'status',
        'status_0', 'discount', 'currancy', 'tax'
    ];

    public function customer()
    {
        # code...
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function domin()
    {
        # code...
        return $this->belongsTo(Domin::class, 'domin_id', 'id');
    }

    public function plan()
    {
        # code...
        return $this->belongsTo(Plan::class, 'plan_id', 'id');
    }
}
