<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\Contact;
use App\Models\Group;
use App\Models\Menu;
use App\Models\Partner;
use App\Models\Slider;
use App\Models\Team;
use App\Models\Work;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class HomeController extends Controller
{
    public function index()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }
        $main_slider = Slider::first();
        $sliders = Slider::latest()->take(5)->get();
        $groups = Group::latest()->take(6)->get();
        $works = Work::latest()->take(5)->get();
        $plans = Group::where('id', 10)->first()->plans()->take(3)->get();
        $partners = Partner::latest()->get();

        return view('front.index',[
            'main_slider' => $main_slider,
            'menu' => $menu,
            'sliders' => $sliders,
            'groups' => $groups,
            'works' => $works,
            'plans' => $plans,
            'partners' => $partners,
        ]);
    }

    public function contactPost(Request $request)
    {
        # code...
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'message' => 'required|string',
        ],[
            'name.required' => __('حقل الاسم مطلوب'),
            'email.required' => __('حقل الايميل مطلوب'),
            'email.email' => __('صيغة الايميل خاطئة'),
            'message.required' => __('حقل الرسالة مطلوب'),
        ]);

        if ($validator->fails()) {
            return redirect(route('view.home') . '#contactSection')
                        ->withErrors($validator)
                        ->withInput();
        }

        Contact::create($request->all());

        return redirect(route('view.home') . '#contactSection')->with('success', __('Your request has been sent successfully'));
    }

    public function about()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $about = About::first();
        $teams = Team::get();

        return view('front.about', [
            'menu' => $menu,
            'teams' => $teams,
            'about' => $about,
        ]);
    }

    public function about2()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $about = About::first();

        return view('front.about-2', [
            'menu' => $menu,
            'about' => $about,
        ]);
    }

    public function partners()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $partners = Partner::get();

        return view('front.partners', [
            'menu' => $menu,
            'partners' => $partners,
        ]);
    }

    public function ourWorks()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $groups = Group::get();

        return view('front.our-job', [
            'menu' => $menu,
            'groups' => $groups,
        ]);
    }
}
