<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use App\Models\WebsiteSetting;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $this->authorize('viewAny', WebsiteSetting::class);
        if ($request->ajax()) {
            // dd($request->all());
            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Menu::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Menu::select('count(*) as allcount')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                ->count();

            $menus = Menu::select('menus.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('menus.id', 'desc')
                ->get();


            $records = [];

            foreach($menus as $item)
            {
                $records[] = [
                    'id' => $item->id,
                    'name' =>  $item->name,
                    'name_ar' =>  $item->name_ar,
                    'actions' => view('admin.menus.datatable.buttons',[ 'item' => $item ])->render() ,
                ];
            }

            $response = [
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $records
            ];

            return response()->json($response);

        }

        return view('admin.menus.index');
    }

    public function update(Request $request, Menu $menu)
    {
        # code...
        $this->authorize('viewAny', WebsiteSetting::class);
        $request->validate([
            'name' => 'string|required|max:255',
            'name_ar' => 'string|required|max:255',
        ]);

        $menu->update($request->all());

        return redirect()->route('c-panel.menus.index')->with('success', __('Updated Done !'));
    }
}

