<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<script src="//cdn.ckeditor.com/4.16.0/full/ckeditor.js"></script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('pageTitle'); ?>
<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0"><?php echo e(__('Create Subscription')); ?></h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(__('Subscriptions')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(__('Create Subscription')); ?></li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row justify-content-center">
    <div class="col-xxl-9">
        <div class="card">
            <form action="<?php echo e(route('c-panel.subscriptions.store')); ?>" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate id="invoice_form">
                <?php echo csrf_field(); ?>
                <div class="card-body p-4">
                    <div class="row g-3 mb-5">
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="customer_id"><?php echo e(__('Customer')); ?></label>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('createCustomer', App\Models\User::class)): ?>
                                <button type="button" class="btn btn-outline-success" style="padding: 0px 4px;margin: 6px 10px;" data-bs-toggle="modal" data-bs-target="#addSeller">
                                    <i class="ri-add-circle-line"></i>
                                </button>
                                <?php endif; ?>
                                <select class="js-example-basic-single" name="customer_id">
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php if(old('customer_id') == $customer->id): ?> selected <?php endif; ?> value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="type"><?php echo e(__('Subscription Type')); ?></label>
                                <select class="form-control " id="type" name="type">
                                    <option <?php if(old('type') == '0'): ?> selected <?php endif; ?> value="0"><?php echo e(__('Service')); ?></option>
                                    <option <?php if(old('type') == '1'): ?> selected <?php endif; ?> value="1"><?php echo e(__('Domin')); ?></option>
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <div id="service"  style="display: none;">
                        <div class="row g-3 mb-3" >
                            <div class="col-lg-4 col-sm-12">
                                <label for="group_id"><?php echo e(__('Services')); ?></label>
                                <select class="form-control " id="group_id" name="group_id">
                                    <option value=""><?php echo e(__('Choose Service')); ?></option>
                                    <?php $__currentLoopData = App\Models\Group::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php if(old('group_id') == $group->id): ?> selected <?php endif; ?> value="<?php echo e($group->id); ?>"><?php echo e($group->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <!--end col-->
                            <div class="col-lg-4 col-sm-12">
                                <label for="plan_id"><?php echo e(__('Plan')); ?></label>
                                <select class="form-control " id="plan_id" name="plan_id">
                                    <option value=""><?php echo e(__('Choose Service First')); ?></option>
                                </select>
                            </div>
                            <!--end col-->
                            <div class="col-lg-4 col-sm-12">
                                <label for="price_type"><?php echo e(__('Price Type')); ?></label>
                                <select class="form-control " id="price_type" name="price_type">
                                    <option value=""><?php echo e(__('Choose Plan first')); ?></option>
                                </select>
                            </div>
                            <!--end col-->
                        </div>
                    </div>
                    <div id="domin" style="display: none;">
                        <div class="row g-3 mb-3" >
                            <div class="col-lg-12 col-sm-12">
                                <div>
                                    <label for="domin_id"><?php echo e(__('Domins')); ?></label>
                                    <select class="form-control " id="domin_id" name="domin_id">
                                        <option value=""><?php echo e(__('Choose Domin')); ?></option>
                                        <?php $__currentLoopData = App\Models\Domin::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $domin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if(old('domin_id') == $domin->id): ?> selected <?php endif; ?> value="<?php echo e($domin->id); ?>"><?php echo e($domin->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <!--end col-->
                        </div>
                    </div>
                    <div class="row g-3 mb-5">
                        <div class="col-lg-4 col-sm-12">
                            <div>
                                <label for="price"><?php echo e(__('Price')); ?></label>
                                <input type="text" class="form-control" data-price="0" name="price" id="price" readonly>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-12">
                            <div>
                                <label for="tax"><?php echo e(__('Tax')); ?></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="tax" onkeyup="calcPrice()" id="tax" value="<?php echo e(old('tax', 0)); ?>">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-12">
                            <div>
                                <label for="discount"><?php echo e(__('Discount')); ?></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="discount" onkeyup="calcPrice()" id="discount" value="<?php echo e(old('discount', 0)); ?>">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <div class="row g-3">
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="start_date"><?php echo e(__('Service Start Date')); ?></label>
                                <input type="date" class="form-control " value="<?php echo e(old('start_date')); ?>" id="start_date" name="start_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="subscrip_date"><?php echo e(__('Subscription Date')); ?></label>
                                <input type="date" class="form-control " value="<?php echo e(old('subscrip_date')); ?>" id="subscrip_date" name="subscrip_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="due_date"><?php echo e(__('Due Date')); ?></label>
                                <input type="date" class="form-control " value="<?php echo e(old('due_date')); ?>" id="due_date" name="due_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="end_date"><?php echo e(__('Service End Date')); ?></label>
                                <input type="date" class="form-control " id="end_date" value="<?php echo e(old('end_date')); ?>" name="end_date">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="status1"><?php echo e(__('Subscription Status')); ?></label>
                                <select class="form-control" id="status1" name="status">
                                    <option <?php if(old('status') == "0"): ?> selected <?php endif; ?> value="0"><?php echo e(__('Active')); ?></option>
                                    <option <?php if(old('status') == "1"): ?> selected <?php endif; ?> value="1"><?php echo e(__('Canceled')); ?></option>
                                    <option <?php if(old('status') == "2"): ?> selected <?php endif; ?> value="2"><?php echo e(__('Stopped')); ?></option>
                                    <option <?php if(old('status') == "3"): ?> selected <?php endif; ?> value="3"><?php echo e(__('Not Enabled')); ?></option>
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6 col-sm-12">
                            <div>
                                <label for="status1"><?php echo e(__('Payment Status')); ?></label>
                                <select class="form-control" id="status_0" name="status_0">
                                    <option <?php if(old('status') == "0"): ?> selected <?php endif; ?> value="0"><?php echo e(__('Paid')); ?></option>
                                    <option <?php if(old('status') == "1"): ?> selected <?php endif; ?> value="1"><?php echo e(__('Worthy')); ?></option>
                                </select>
                            </div>
                        </div>
                        <!--end col-->

                    </div>
                    <!--end row-->
                    <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                        <button type="submit" class="btn btn-success"><i class="ri-printer-line align-bottom me-1"></i> <?php echo e(__('Save')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!--end col-->
</div>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('createCustomer', App\Models\User::class)): ?>
 <!-- Modal -->
 <div class="modal fade zoomIn" id="addSeller" tabindex="-1" aria-labelledby="addSellerLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addSellerLabel"><?php echo e(__('Add Customer')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('c-panel.customers.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <label for="firstnameInput" class="form-label"><?php echo e(__('Image')); ?></label>
                        <div class="col-lg-12">
                            <div class="mb-3">
                                <div class="position-relative d-inline-block">
                                    <input type='file' onchange="loadFile_image(image)" name="image" id="image"
                                        class="<?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" style="display:none;" />
                                    <button id="output_image" type="button" class="bg-light"
                                        onclick="document.getElementById('image').click();" value="emad"
                                        style="
                                                width: 100px;
                                                height: 100px;
                                                border-radius: 2px;
                                                background-repeat: no-repeat;
                                                background-size: cover;
                                                background-position: center;
                                                border:none;
                                                "></button>
                                    <div class="position-absolute top-100 start-100 translate-middle">
                                        <label for="product-image-input"
                                            onclick="document.getElementById('image').click();" class="mb-0"
                                            title="Select Image">
                                            <div class="avatar-xs">
                                                <div
                                                    class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                    <i class="ri-image-fill"></i>
                                                </div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                <script>
                                    var loadFile_image = function(image) {
                                        var image = document.getElementById('output_image');
                                        var src = URL.createObjectURL(event.target.files[0]);
                                        image.style.backgroundImage = 'url(' + src + ')';
                                    };
                                </script>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="name" class="form-label"><?php echo e(__('Name')); ?></label>
                                <input type="text" class="form-control" id="name" name="name"
                                    value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Enter customer name')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="department_id" class="form-label"><?php echo e(__('Department')); ?></label>
                                <select class="form-control" name="department_id" id="department_id">
                                    <?php $__currentLoopData = App\Models\Department::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php if(old('department_id') == $department->id): ?> selected <?php endif; ?>
                                            value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="association" class="form-label"><?php echo e(__('Association')); ?></label>
                                <input type="text" class="form-control" id="association" name="association"
                                    value="<?php echo e(old('association')); ?>"
                                    placeholder="<?php echo e(__('Enter association name')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="phone" class="form-label"><?php echo e(__('Phone Number')); ?></label>
                                <input type="text" class="form-control" id="phone" name="phone"
                                    value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(__('Enter phone number')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="country" class="form-label"><?php echo e(__('Country')); ?></label>
                                <input type="text" class="form-control" id="country" name="country"
                                    value="<?php echo e(old('country')); ?>" placeholder="<?php echo e(__('Enter country')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="city" class="form-label"><?php echo e(__('City')); ?></label>
                                <input type="text" class="form-control" id="city" name="city"
                                    value="<?php echo e(old('city')); ?>" placeholder="<?php echo e(__('Enter city')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="website" class="form-label"><?php echo e(__('Website')); ?></label>
                                <input type="text" class="form-control" id="website" name="website"
                                    value="<?php echo e(old('website')); ?>" placeholder="<?php echo e(__('Enter website')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                <input type="email" class="form-control" id="email" name="email"
                                    value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('Enter customer email')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="password" class="form-label"><?php echo e(__('Password')); ?></label>
                                <input type="password" class="form-control" id="password" name="password"
                                    value="<?php echo e(old('password')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <label for="password_confirmation"
                                    class="form-label"><?php echo e(__('Confirm Password')); ?></label>
                                <input type="password" class="form-control" id="password_confirmation"
                                    name="password_confirmation" value="<?php echo e(old('password_confirmation')); ?>">
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-lg-12">
                            <div class="hstack gap-2 justify-content-end">
                                <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                    data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                    <?php echo e(__('Close')); ?></button>
                                <button type="submit" class="btn btn-primary"><i
                                        class="ri-save-3-line align-bottom me-1"></i> <?php echo e(__('Save')); ?></button>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                </form>
            </div>
        </div>
    </div>
</div>
<!--end modal-->
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- cleave.js -->
<script src="<?php echo e(asset('assets/libs/cleave.js/cleave.min.js')); ?>"></script>

<!--Invoice create init js-->
<script>
        var type = document.getElementById('type'),
            service = document.getElementById('service'),
            domin = document.getElementById('domin');

        function selectService() {
            if(type.value == '0'){
                service.style.display = 'block';
                domin.style.display = 'none';
                $('#price').val('');
                document.getElementById('price').setAttribute('data-price',0);
                getPlanPrice($('#price_type').val(),$('#plan_id').val());
            } else {
                service.style.display = 'none';
                domin.style.display = "block";
                $('#price').val('');
                document.getElementById('price').setAttribute('data-price',0);
                getDominPrice($('#domin_id').val());
            }
        }

        type.onchange = function () {
            selectService()
        };

        // Department Change
        $('#group_id').change(function () {

            // Department id
            var id = $(this).val();
            getPlans(id);

        });

        // Department Change
        $('#plan_id').change(function () {

            // Department id
            var id = $(this).val();
            getPlanPrices(id);

        });

        // Department Change
        $('#price_type').change(function () {

            // Department id
            var price_type = $(this).val();
            var plan = $('#plan_id').val()

            getPlanPrice(price_type, plan);
        });

        // Department Change
        $('#domin_id').change(function () {

            // Department id
            var id = $(this).val();
            getDominPrice(id);

        });

        function getPlans(id){
            // AJAX request
            $.ajax({
                url: '/c-panel/group/ajax/' + id,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('');
                    document.getElementById('price').setAttribute('data-price',0);
                    $('#plan_id').empty();
                    $('#plan_id').append('<option value=""><?php echo e(__("Choose Plan")); ?></option>')
                    $.each(data, function (key, value) {
                        // console.log(value.name)
                        $('#plan_id').append('<option value="' + value.id + '">' + value.title + '</option>')
                    });

                }
            });
        }

        function getPlanPrices(id){
            // AJAX request
            $.ajax({
                url: '/c-panel/plan/ajax/' + id,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('');
                    document.getElementById('price').setAttribute('data-price',0);
                    $('#price_type').empty();
                    $('#price_type').append('<option value=""><?php echo e(__("Choose Pierod")); ?></option>')
                    $.each(data, function (key, value) {
                        // console.log(value.name)
                        var name = '';
                        if(value.type == 1){
                            name = '<?php echo e(__("Quarterly")); ?>';
                        } else if(value.type == 2) {
                            name = '<?php echo e(__("Biannual")); ?>';
                        } else if(value.type == 3) {
                            name = '<?php echo e(__("Annual")); ?>';
                        } else if(value.type == 4) {
                            name = '<?php echo e(__("Two Years")); ?>';
                        } else if(value.type == 5) {
                            name = '<?php echo e(__("Three Years")); ?>';
                        }

                        $('#price_type').append('<option value="' + value.type + '">' + name + '</option>')
                    });

                }
            });
        }

        function getPlanPrice(price_type, plan){
            // AJAX request
            $.ajax({
                url: '/c-panel/group/price/ajax/' + price_type + '/' + plan,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('')
                    $('#price').val(data.price);
                    document.getElementById('price').setAttribute('data-price',data.price);
                    calcPrice();
                }
            });
        }

        function getDominPrice(id){
            // AJAX request
            $.ajax({
                url: '/c-panel/domin/price/ajax/' + id,
                type: 'get',
                data: "json",
                success: function (data) {
                    $('#price').val('')
                    $('#price').val(data.price);
                    // $('#price').data().price = data.price;
                    // console.log($('#price').data().price);
                    document.getElementById('price').setAttribute('data-price',data.price);
                    calcPrice();
                }
            });
        }

        window.onload = function() {
            selectService();
            calcPrice();
            if(type == '0'){
                getPlans($('#group_id').val());
                getPlanPrices($('#plan_id').val());
                getPlanPrice($('#price_type').val(),$('#plan_id').val());
            } else {
                getDominPrice($('#domin_id').val());
            }
        };


        function calcPrice(){
            var priceInput = document.getElementById('price');
            var tax = document.getElementById('tax');
            var discount = document.getElementById('discount');
            var price = document.getElementById('price').getAttribute('data-price');

            // console.log(price.value + '-' + discount.value + '-' + tax.value);
            if (discount.value < 0) discount.value = 0;
            if (discount.value > 100) discount.value = 100;
            if (tax.value < 0) tax.value = 0;
            if (tax.value > 100) tax.value = 100;

            var totelTax = 0, totelDiscount = 0;
            var totelValue = 0;

            if(discount.value)
            {
                totelDiscount = (discount.value * price)/100;
            }

            if(tax.value)
            {
                totelTax = (tax.value * price)/100;
            }

            totelValue = (parseFloat(price) + parseFloat(totelTax)) - parseFloat(totelDiscount);

            priceInput.value = Number(totelValue.toFixed(2));
        }
</script>

<!--select2 cdn-->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script src="<?php echo e(asset('assets/js/pages/select2.init.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmdivvat/public_html/resources/views/admin/subscriptions/create.blade.php ENDPATH**/ ?>