<?php $__env->startSection('pageTitle'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0"><?php echo e(__('Customer')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(__('Department')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(__('All Customers')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <form action="<?php echo e(route('c-panel.customers.index')); ?>" method="GET">
        <div class="card">
            <div class="card-header border-0 rounded">
                <div class="row g-2">

                    <div class="col-xl-3">
                        <div class="search-box">
                            <input type="text" name="search" class="form-control search"
                                placeholder="<?php echo e(__('Search for customer')); ?>"> <i class="ri-search-line search-icon"></i>
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-xl-2 ms-auto">
                        <div>
                            <select class="form-control" name="department_id" data-choices data-choices-search-false>
                                <option value=""><?php echo e(__('Select Department')); ?></option>
                                <?php $__currentLoopData = App\Models\Department::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-lg-auto">
                        <div class="hstack gap-2">
                            <button type="submit" class="btn btn-danger"><i
                                    class="ri-equalizer-fill me-1 align-bottom"></i>
                                <?php echo e(__('Filters')); ?></button>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('createCustomer', App\Models\User::class)): ?>
                                <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addSeller"><i
                                        class="ri-add-fill me-1 align-bottom"></i> <?php echo e(__('Add Customer')); ?></button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->
            </div>
        </div>
    </form>

    <div class="row mt-4">
        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xl-3 col-lg-6">
                <div class="card ribbon-box right overflow-hidden">
                    <div class="card-body text-center p-4">
                        <img src="<?php if($customer->image): ?><?php echo e(asset('storage/' . $customer->image)); ?><?php else: ?><?php echo e(asset('client-logo.jpeg')); ?><?php endif; ?>" alt="" height="45">
                        <h5 class="mb-1 mt-4"><a href="javascript:;" data-bs-toggle="modal"
                                data-bs-target="#editSeller<?php echo e($customer->id); ?>"
                                class="link-primary"><?php echo e($customer->name); ?></a></h5>
                        <p class="text-muted mb-4"><?php echo e($customer->department->name ?? __('حساب جديد')); ?></p>

                        <div class="row mt-4">
                            <div class="col-lg-6 border-end-dashed border-end">
                                <h5>0</h5>
                                <span class="text-muted"><?php echo e(__('Projects')); ?></span>
                            </div>
                            <div class="col-lg-6">
                                <h5>$0</h5>
                                <span class="text-muted"><?php echo e(__('Amount owed')); ?></span>
                            </div>
                        </div>
                        <div class="mt-4 d-flex">
                            <a href="<?php echo e(route('c-panel.customers.show', $customer->id)); ?>" class="btn btn-light m-1"><?php echo e(__('View Details')); ?></a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('updateCustomer', $customer)): ?>
                            <a href="javascript:;" class="btn btn-primary m-1" data-bs-toggle="modal" data-bs-target="#editSeller<?php echo e($customer->id); ?>"><i class="ri-edit-box-line"></i></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('deleteCustomer', $customer)): ?>
                            <a href="javascript:;" class="btn btn-danger m-1" data-bs-toggle="modal" data-bs-target="#delete-item-<?php echo e($customer->id); ?>"><i class="ri-delete-bin-6-line"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <!--end row-->

    <div class="row g-0 text-center text-sm-start align-items-center mb-3">
        <!-- end col -->
        <div class="col-sm-12">
            <?php echo e($customers->links('vendor.pagination.semantic-ui')); ?>

        </div><!-- end col -->
    </div><!-- end row -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('createCustomer', App\Models\User::class)): ?>
    <!-- Modal -->
    <div class="modal fade zoomIn" id="addSeller" tabindex="-1" aria-labelledby="addSellerLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSellerLabel"><?php echo e(__('Add Customer')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('c-panel.customers.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <label for="firstnameInput" class="form-label"><?php echo e(__('Image')); ?></label>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <div class="position-relative d-inline-block">
                                        <input type='file' onchange="loadFile_image(image)" name="image" id="image"
                                            class="<?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" style="display:none;" />
                                        <button id="output_image" type="button" class="bg-light"
                                            onclick="document.getElementById('image').click();" value="emad"
                                            style="
                                                    width: 100px;
                                                    height: 100px;
                                                    border-radius: 2px;
                                                    background-repeat: no-repeat;
                                                    background-size: cover;
                                                    background-position: center;
                                                    border:none;
                                                    "></button>
                                        <div class="position-absolute top-100 start-100 translate-middle">
                                            <label for="product-image-input"
                                                onclick="document.getElementById('image').click();" class="mb-0"
                                                title="Select Image">
                                                <div class="avatar-xs">
                                                    <div
                                                        class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                        <i class="ri-image-fill"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                    <script>
                                        var loadFile_image = function(image) {
                                            var image = document.getElementById('output_image');
                                            var src = URL.createObjectURL(event.target.files[0]);
                                            image.style.backgroundImage = 'url(' + src + ')';
                                        };
                                    </script>
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label"><?php echo e(__('Name')); ?></label>
                                    <input type="text" class="form-control" id="name" name="name"
                                        value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Enter customer name')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="department_id" class="form-label"><?php echo e(__('Department')); ?></label>
                                    <select class="form-control" name="department_id" id="department_id">
                                        <?php $__currentLoopData = App\Models\Department::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if(old('department_id') == $department->id): ?> selected <?php endif; ?>
                                                value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="association" class="form-label"><?php echo e(__('Association')); ?></label>
                                    <input type="text" class="form-control" id="association" name="association"
                                        value="<?php echo e(old('association')); ?>"
                                        placeholder="<?php echo e(__('Enter association name')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label"><?php echo e(__('Phone Number')); ?></label>
                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(__('Enter phone number')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="country" class="form-label"><?php echo e(__('Country')); ?></label>
                                    <input type="text" class="form-control" id="country" name="country"
                                        value="<?php echo e(old('country')); ?>" placeholder="<?php echo e(__('Enter country')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="city" class="form-label"><?php echo e(__('City')); ?></label>
                                    <input type="text" class="form-control" id="city" name="city"
                                        value="<?php echo e(old('city')); ?>" placeholder="<?php echo e(__('Enter city')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="website" class="form-label"><?php echo e(__('Website')); ?></label>
                                    <input type="text" class="form-control" id="website" name="website"
                                        value="<?php echo e(old('website')); ?>" placeholder="<?php echo e(__('Enter website')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                    <input type="email" class="form-control" id="email" name="email"
                                        value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('Enter customer email')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label"><?php echo e(__('Password')); ?></label>
                                    <input type="password" class="form-control" id="password" name="password"
                                        value="<?php echo e(old('password')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password_confirmation"
                                        class="form-label"><?php echo e(__('Confirm Password')); ?></label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        name="password_confirmation" value="<?php echo e(old('password_confirmation')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                        data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                        <?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-primary"><i
                                            class="ri-save-3-line align-bottom me-1"></i> <?php echo e(__('Save')); ?></button>
                                </div>
                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end modal-->
    <?php endif; ?>

    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('updateCustomer', $customer)): ?>
        <!-- Modal -->
        <div class="modal fade zoomIn" id="editSeller<?php echo e($customer->id); ?>" tabindex="-1"
            aria-labelledby="addSellerLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addSellerLabel"><?php echo e(__('Edit Customer')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('c-panel.customers.update', $customer->id)); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">
                                <label for="firstnameInput" class="form-label"><?php echo e(__('Image')); ?></label>
                                <div class="col-lg-12">
                                    <div class="mb-3">
                                        <div class="position-relative d-inline-block">
                                            <input type='file'
                                                onchange="loadFile_image<?php echo e($customer->id); ?>(image<?php echo e($customer->id); ?>)"
                                                name="image" id="image<?php echo e($customer->id); ?>"
                                                class="<?php $__errorArgs = ['image<?php echo e($customer->id); ?>'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                style="display:none;" />
                                            <button id="output_image<?php echo e($customer->id); ?>" type="button" class="bg-light"
                                                onclick="document.getElementById('image<?php echo e($customer->id); ?>').click();"
                                                value="emad"
                                                style="
                                                    width: 100px;
                                                    height: 100px;
                                                    border-radius: 2px;
                                                    background-repeat: no-repeat;
                                                    background-image: url(<?php echo e(asset('storage/' . ($customer->image ?? ''))); ?>);
                                                    background-size: cover;
                                                    background-position: center;
                                                    border:none;
                                                    "></button>
                                            <div class="position-absolute top-100 start-100 translate-middle">
                                                <label for="product-image-input"
                                                    onclick="document.getElementById('image<?php echo e($customer->id); ?>').click();"
                                                    class="mb-0" title="Select Image">
                                                    <div class="avatar-xs">
                                                        <div
                                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                            <i class="ri-image-fill"></i>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <script>
                                            var loadFile_image<?php echo e($customer->id); ?> = function(image<?php echo e($customer->id); ?>) {
                                                var image<?php echo e($customer->id); ?> = document.getElementById('output_image<?php echo e($customer->id); ?>');
                                                var src = URL.createObjectURL(event.target.files[0]);
                                                image<?php echo e($customer->id); ?>.style.backgroundImage = 'url(' + src + ')';
                                            };
                                        </script>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label"><?php echo e(__('Name')); ?></label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            value="<?php echo e(old('name', $customer->name)); ?>"
                                            placeholder="<?php echo e(__('Enter customer name')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="department_id" class="form-label"><?php echo e(__('Department')); ?></label>
                                        <select class="form-control" name="department_id" id="department_id">
                                            <?php $__currentLoopData = App\Models\Department::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if(old('department_id', $customer->department_id) == $department->id): ?> selected <?php endif; ?>
                                                    value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="association" class="form-label"><?php echo e(__('Association')); ?></label>
                                        <input type="text" class="form-control" id="association" name="association"
                                            value="<?php echo e(old('association', $customer->association)); ?>"
                                            placeholder="<?php echo e(__('Enter association name')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="phone" class="form-label"><?php echo e(__('Phone Number')); ?></label>
                                        <input type="text" class="form-control" id="phone" name="phone"
                                            value="<?php echo e(old('phone', $customer->phone)); ?>"
                                            placeholder="<?php echo e(__('Enter phone number')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="country" class="form-label"><?php echo e(__('Country')); ?></label>
                                        <input type="text" class="form-control" id="country" name="country"
                                            value="<?php echo e(old('country', $customer->country)); ?>"
                                            placeholder="<?php echo e(__('Enter country')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="city" class="form-label"><?php echo e(__('City')); ?></label>
                                        <input type="text" class="form-control" id="city" name="city"
                                            value="<?php echo e(old('city', $customer->city)); ?>"
                                            placeholder="<?php echo e(__('Enter city')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="website" class="form-label"><?php echo e(__('Website')); ?></label>
                                        <input type="text" class="form-control" id="website" name="website"
                                            value="<?php echo e(old('website', $customer->website)); ?>"
                                            placeholder="<?php echo e(__('Enter website')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            value="<?php echo e(old('email', $customer->email)); ?>"
                                            placeholder="<?php echo e(__('Enter customer email')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="password" class="form-label"><?php echo e(__('Password')); ?></label>
                                        <input type="password" class="form-control" id="password" name="password"
                                            value="<?php echo e(old('password')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="password_confirmation"
                                            class="form-label"><?php echo e(__('Confirm Password')); ?></label>
                                        <input type="password" class="form-control" id="password_confirmation"
                                            name="password_confirmation" value="<?php echo e(old('password_confirmation')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <div class="form-check form-switch form-switch-md">
                                            <input type="checkbox" class="form-check-input" value="1"
                                                name="status" id="customSwitchsizemd"
                                                <?php if(old('status', $customer->status) == '1'): ?> checked <?php endif; ?>>
                                            <label for="status"
                                                class="form-label"><?php echo e(__('Activation Status')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                            data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                            <?php echo e(__('Close')); ?></button>
                                        <button type="submit" class="btn btn-primary"><i
                                                class="ri-save-3-line align-bottom me-1"></i> <?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end modal-->
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('deleteCustomer', $customer)): ?>
        <!-- Delete Modal -->
        <div class="modal fade zoomIn" id="delete-item-<?php echo e($customer->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                            id="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <form action=" <?php echo e(route('c-panel.customers.destroy', $customer->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <div class="mt-2 text-center">
                                <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop"
                                    colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px">
                                </lord-icon>
                                <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                    <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                                    <p class="text-muted mx-4 mb-0">
                                        <?php echo e(__('Are you Sure You want to Remove this Record ?')); ?></p>
                                </div>
                            </div>
                            <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                <button type="button" class="btn w-sm btn-light"
                                    data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                <button type="submit" class="btn w-sm btn-danger "
                                    id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end delete modal -->
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmdivvat/public_html/resources/views/admin/customers/index.blade.php ENDPATH**/ ?>