<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        
        
        <li>
            <a class="dropdown-item edit-item-btn" data-bs-toggle="modal" data-bs-target="#view-item-<?php echo e($item->id); ?>">
                <i class="ri-eye-line align-bottom me-2 text-muted"></i> <?php echo e(__('Show')); ?>

            </a>
        </li>
        
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal"
                data-bs-target="#delete-item-<?php echo e($item->id); ?>">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Delete')); ?>

            </a>
        </li>
        
    </ul>
</div>



<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                    id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" <?php echo e(route('c-panel.contacts.destroy', $item->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop"
                            colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                            <p class="text-muted mx-4 mb-0"><?php echo e(__('Are you Sure You want to Remove this Record ?')); ?>

                            </p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light"
                            data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn w-sm btn-danger "
                            id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->



<div class="modal fade" id="view-item-<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered service-modal">
        <div class="modal-content">
            <div class="modal-header bg-light p-3">
                <h5 class="modal-title ms-3" id="exampleModalLabel"><?php echo e(__('Show Contact')); ?></h5>
                <button type="button" class="btn-close me-3" data-bs-dismiss="modal" aria-label="Close"
                    id="close-modal"></button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label"><?php echo e(__('Name')); ?></label>
                                <p style="border: 0.5px solid #bbb3b3; font-weight: bold; padding: 8px 10px; border-radius: 5px;"><?php echo e($item->name); ?></p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                <p style="border: 0.5px solid #bbb3b3; font-weight: bold; padding: 8px 10px; border-radius: 5px;"><?php echo e($item->email); ?></p>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="message" class="form-label"><?php echo e(__('Message')); ?></label>
                                <p style="border: 0.5px solid #bbb3b3; font-weight: bold; padding: 8px 10px; border-radius: 5px;"><?php echo e($item->message); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="hstack gap-2 justify-content-end">
                    <button type="button" id="close-modal<?php echo e($item->id); ?>" class="btn btn-light"
                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).on('click', '#view-item-<?php echo e($item->id); ?>', function (e) {
        e.preventDefault();
        $.ajax({
            type:'GET',
            enctype: 'multipart/form-data',
            url: "<?php echo e(route('c-panel.contacts.show', $item->id)); ?>",
            cache:false,
            contentType: false,
            processData: false,
            success: (response) => {
                $("#contacts-list-table").DataTable().draw();
            },
        });
    });
</script>
<?php /**PATH C:\xampp\htdocs\crm\resources\views/admin/contacts/datatable/buttons.blade.php ENDPATH**/ ?>