<?php $__env->startSection('pageTitle'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0"><?php echo e(__('Edit Work')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(__('Work')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(__('All Works')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">

        <div class="card ">
        <div class="col-lg-8 m-5"> 
                
                <form action="<?php echo e(route('c-panel.works.update', $item->id )); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="modal-body">
                        <label for="image"><?php echo e(__('Image')); ?></label>
                        <div class="mb-3">
                            <div class="position-relative d-inline-block" style="width: 40%">
                                <input type='file'
                                    onchange="loadFile_image<?php echo e($item->id); ?>(image<?php echo e($item->id); ?>)"
                                    name="image" id="image<?php echo e($item->id); ?>"
                                    class="<?php $__errorArgs = ['image<?php echo e($item->id); ?>'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    style="display:none;" />
                                <button id="output_image<?php echo e($item->id); ?>" type="button" class="bg-light"
                                    onclick="document.getElementById('image<?php echo e($item->id); ?>').click();"
                                    value="emad"
                                    style="
                                        width: 100%;
                                        height: 150px;
                                        border-radius: 2px;
                                        background-repeat: no-repeat;
                                        background-image: url(<?php echo e(asset('storage/works/' . ($item->image ?? ''))); ?>);
                                        background-size: cover;
                                        background-position: center;
                                        border:none;
                                        "></button>
                                <div class="position-absolute top-100 start-100 translate-middle">
                                    <label for="product-image-input"
                                        onclick="document.getElementById('image<?php echo e($item->id); ?>').click();"
                                        class="mb-0" title="Select Image">
                                        <div class="avatar-xs">
                                            <div
                                                class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                <i class="ri-image-fill"></i>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                            <script>
                                var loadFile_image<?php echo e($item->id); ?> = function(image<?php echo e($item->id); ?>) {
                                    var image<?php echo e($item->id); ?> = document.getElementById('output_image<?php echo e($item->id); ?>');
                                    var src = URL.createObjectURL(event.target.files[0]);
                                    image<?php echo e($item->id); ?>.style.backgroundImage = 'url(' + src + ')';
                                };
                            </script>
                        </div>
                        <div class="mb-3">
                            <label for="image" class="form-label"><?php echo e(__('اختر صور العمل')); ?></label>
                            <input type="file" id="image" name="work_images[]" class="form-control" multiple >  
                         </div>
                         <div class="row"> 
                            <?php $__currentLoopData = $item->work_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <div class="col-4 mb-3 R_album<?php echo e($a->id); ?> ">
                                          <img src="<?php echo e(asset('storage/works/'.$a->image)); ?>"  alt="<?php echo e($a->name); ?>" width="100" >  
                                        <span class="form-text "> <a href="#" class="deletem_b" deletem_b="<?php echo e($a->id); ?> "> ازالة الصورة </a></span> 
                                        
                               </div>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </div>
                        <div class="mb-3">
                            <label for="title" class="form-label"><?php echo e(__('English Title')); ?></label>
                            <input type="text" id="title" name="title" class="form-control" value="<?php echo e(old('title', $item->title)); ?>" placeholder="<?php echo e(__('English Title')); ?>"  />
                        </div>
                        <div class="mb-3">
                            <label for="title_ar" class="form-label"><?php echo e(__('Arabic Title')); ?></label>
                            <input type="text" id="title_ar" name="title_ar" class="form-control" value="<?php echo e(old('title_ar', $item->title_ar)); ?>" placeholder="<?php echo e(__('Arabic Title')); ?>"  />
                        </div>
                        <div class="mb-3">
                            <label for="group_id" class="form-label"><?php echo e(__('الفئة')); ?></label>
                            <select name="category_id" class="form-control" id="category_id">
                                <option value="">  الفئة</option>
                                <?php $__currentLoopData = App\Models\Category::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php if(old('category_id', $item->category_id) == $category->id): ?> selected <?php endif; ?> value="<?php echo e($category->id); ?>">
                                        <?php if(LaravelLocalization::getCurrentLocale() == 'ar'): ?>
                                            <?php echo e($category->title_ar); ?> <?php else: ?> <?php echo e($category->title); ?>

                                        <?php endif; ?>
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>  
                        <div class="mb-3 ">
                            <label for="description" class="form-label"><?php echo e(__('English Description')); ?></label>
                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo e(old('description', $item->description ?? '')); ?></textarea>
                        </div> 
                        <div class="mb-3 ">
                            <label for="description_ar" class="form-label"><?php echo e(__('Arabic Description')); ?></label>
                            <textarea class="form-control" id="description_ar" name="description_ar" rows="3"><?php echo e(old('description_ar', $item->description_ar ?? '')); ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="date" class="form-label"><?php echo e(__('التاريخ')); ?></label>
                            <input type="date" id="date" name="date" class="form-control" value="<?php echo e(old('date', $item->date)); ?>"   />
                        </div>
                        <div class="mb-3">
                            <label for="client" class="form-label"><?php echo e(__(' العميل')); ?></label>
                            <input type="text" id="client" name="client" class="form-control" value="<?php echo e(old('client', $item->client)); ?>"  />
                        </div>
                        <div class="mb-3">
                            <label for="link" class="form-label"><?php echo e(__('Link')); ?></label>
                            <input type="url" id="link" name="link" class="form-control" value="<?php echo e(old('link', $item->link)); ?>" placeholder="<?php echo e(__('Link')); ?>" />
                        </div>
                        <div class="mb-3">
                            <label for="b_link" class="form-label"><?php echo e(__('Video Link')); ?></label>
                            <input type="url" id="v_link" name="v_link" class="form-control" value="<?php echo e(old('v_link', $item->v_link)); ?>" placeholder="<?php echo e(__('video Link')); ?>" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                             <button type="submit" class="btn btn-success" id="add-btn"><?php echo e(__('Update')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!--end col-->
    </div>
 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.5.0.min.js" integrity="sha256-xNzN2a4ltkB44Mc/Jz3pT4iU1cmeR0FkXs4pru/JxaQ=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 
    <!-- App js -->

 
<script>
    $('.deletem_b').on("click", function (e) {
     e.preventDefault();
        
    var id = $(this).attr('deletem_b');
    
    
    $.ajax({
         type: "post",
         url: "<?php echo e(route('c-panel.delete_work_photo')); ?>",
         data: { _token: '<?php echo e(csrf_token()); ?>',
              "id" : id },
             dataType: 'json',  // let's set the expected response format
             success: function (data) {
                 $(".R_album"+ data.id).remove();
                
             },
             error: function (err) {
                 if (err.status == 422) { // when status code is 422, it's a validation issue
                     console.log(err.responseJSON);
                     $('#success_message_notifications').fadeIn().html('<div class="alert alert-danger border-0 alert-dismissible">' + err.responseJSON.message +'</div>');
    
    
                 }
             }
         });   
    
    });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\crm\resources\views/admin/works/edit.blade.php ENDPATH**/ ?>