<?php $__env->startSection('title'); ?>
    <?php echo e(__('Blogs')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row" style="margin-top: 30px;">
        <div class="col-lg-12">
            <div class="card">
                <form action="<?php echo e(route('c-panel.blogs.update', $blog->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="card-header">
                        <h5 class="card-title mb-0 flex-grow-1"><?php echo e(__('Update')); ?></h5>
                    </div>
                    <div class="card-body">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="name" class="form-label"><?php echo e(__('Main Image')); ?></label>
                                    <div class="mb-3">
                                        <div class="position-relative d-inline-block">
                                            <input type='file' onchange="loadFile_main_image(main_image)"
                                                name="main_image" id="main_image"
                                                class="<?php $__errorArgs = ['main_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" style="display:none;" />
                                            <button id="output_main_image" type="button" class="bg-light"
                                                onclick="document.getElementById('main_image').click();" value="emad"
                                                style="
                                                        width: 100px;
                                                        height: 100px;
                                                        border-radius: 2px;
                                                        background-repeat: no-repeat;
                                                        background-image: url(<?php echo e(asset('storage/works/' . ($blog->main_image ?? ''))); ?>);
                                                        background-size: cover;
                                                        background-position: center;
                                                        border:none;
                                                        "></button>
                                            <div class="position-absolute top-100 start-100 translate-middle">
                                                <label for="product-image-input"
                                                    onclick="document.getElementById('main_image').click();" class="mb-0"
                                                    title="Select Image">
                                                    <div class="avatar-xs">
                                                        <div
                                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                            <i class="ri-image-fill"></i>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <script>
                                            var loadFile_main_image = function(main_image) {
                                                var main_image = document.getElementById('output_main_image');
                                                var src = URL.createObjectURL(event.target.files[0]);
                                                main_image.style.backgroundImage = 'url(' + src + ')';
                                            };
                                        </script>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label"><?php echo e(__('English Title')); ?></label>
                                        <input type="text" id="title" name="title" class="form-control"
                                            value="<?php echo e(old('title', $blog->title)); ?>" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title_ar" class="form-label"><?php echo e(__('Arabic Title')); ?></label>
                                        <input type="text" id="title_ar" name="title_ar" class="form-control"
                                            value="<?php echo e(old('title_ar', $blog->title_ar)); ?>" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title" class="form-label"><?php echo e(__('English Sub Title')); ?></label>
                                        <input type="text" id="sub_title" name="sub_title" class="form-control"
                                            value="<?php echo e(old('sub_title', $blog->sub_title)); ?>" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title_ar" class="form-label"><?php echo e(__('Arabic Sub Title')); ?></label>
                                        <input type="text" id="sub_title_ar" name="sub_title_ar" class="form-control"
                                            value="<?php echo e(old('sub_title_ar', $blog->sub_title_ar)); ?>" required />
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description" class="form-label"><?php echo e(__('English Description')); ?></label>
                                        <textarea id="description" rows="5" name="description" class="form-control"><?php echo e(old('description', $blog->description)); ?> </textarea>
                                        <script>
                                            CKEDITOR.replace('description', {
                                                                filebrowserUploadUrl: "<?php echo e(route('ckeditor.upload', ['_token' => csrf_token() ])); ?>",
                                                                filebrowserUploadMethod: 'form'
                                                            });
                                        </script>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description_ar"
                                            class="form-label"><?php echo e(__('Arabic Description')); ?></label>
                                        <textarea id="description_ar" rows="5" name="description_ar" class="form-control"><?php echo e(old('description_ar', $blog->description_ar)); ?> </textarea>
                                        <script>
                                            CKEDITOR.replace('description_ar', {
                                                                filebrowserUploadUrl: "<?php echo e(route('ckeditor.upload', ['_token' => csrf_token() ])); ?>",
                                                                filebrowserUploadMethod: 'form'
                                                            });
                                        </script>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="tag" class="form-label"><?php echo e(__('English Tags')); ?></label>
                                        <input type="text" class="form-control" id="tag" name="tag" <?php if(old('tag')): ?> value="<?php echo e(old('tag')); ?>" <?php elseif($blog->tag): ?> value="<?php $__currentLoopData = $blog->tag; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($tag); ?><?php if(!$loop->last): ?><?php echo e(','); ?><?php endif; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>" <?php endif; ?>>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="tag_ar" class="form-label"><?php echo e(__('Arabic Tags')); ?></label>
                                        <input type="text" class="form-control" id="tag_ar" name="tag_ar" <?php if(old('tag_ar')): ?> value="<?php echo e(old('tag_ar')); ?>" <?php elseif($blog->tag_ar): ?> value="<?php $__currentLoopData = $blog->tag_ar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($tag); ?><?php if(!$loop->last): ?><?php echo e(','); ?><?php endif; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>" <?php endif; ?>>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="gallery" class="form-label"><?php echo e(__('Other Images')); ?></label>
                                        <input type="file" id="gallery" name="gallery[]" class="form-control"
                                            multiple>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="submit" class="btn btn-success me-4"
                                id="add-btn"><?php echo e(__('Add')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!--end col-->
        <?php if(count($blog->images) != 0 ): ?>
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('Uploaded Image')); ?></h4>
                </div>
                <div class="card-body pt-3 pb-3">
                    <div class="row">
                        <?php $__empty_1 = true; $__currentLoopData = $blog->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-md-4 col-xl-3" id="<?php echo e($value->image); ?>">
                                <div class="card border-0 text-white">
                                    <img class="card-img" style="height: 150px;"
                                        src="<?php echo e(asset('storage/works/' . $value->image)); ?>" alt="Card image">
                                    <div class="card-img-overlay">
                                        <a class="dz-remove deleteImage btn btn-primary" title="حذف الصورة"
                                            style=" border-color: #ee4747 !important; background-color: #d50404 !important;padding:3px 5px; margin-top: -43px; margin-right: -23px;"
                                            href="javascript:undefined;" img-name="<?php echo e($value->image); ?>" data-blog="<?php echo e($blog->id); ?>"
                                            data-dz-remove="">X</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <!--end row-->



<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script>
        $('body').on('click', '.deleteImage', function() {

            var name = $(this).attr('img-name');
            var blog = $(this).attr('data-blog');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
                },
                type: 'POST',
                url: "<?php echo e(route('c-panel.blogs.delete-images')); ?>",
                data: {
                    filename: name,
                    blog: blog,
                },
                success: function(data) {
                    document.getElementById(data.name).remove();
                    console.log("File has been successfully removed!!");
                },
                error: function(e) {
                    console.log(e);
                }
            });

        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmdivvat/public_html/resources/views/admin/blogs/edit.blade.php ENDPATH**/ ?>