<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
        data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $item)): ?>
        <li>
            <a class="dropdown-item edit-item-btn" data-bs-toggle="modal" data-bs-target="#edit-item-<?php echo e($item->id); ?>">
                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Edit')); ?>

            </a>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $item)): ?>
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#delete-item-<?php echo e($item->id); ?>">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> <?php echo e(__('Delete')); ?>

            </a>
        </li>
        <?php endif; ?>
    </ul>
</div>


<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $item)): ?>
<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" <?php echo e(route('c-panel.domins.destroy',$item->id)); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                            <p class="text-muted mx-4 mb-0"><?php echo e(__('Are you Sure You want to Remove this Record ?')); ?></p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn w-sm btn-danger " id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
<?php endif; ?>


<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $item)): ?>
<!-- Edit Modal -->
<div class="modal fade" id="edit-item-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light p-3">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Edit Domin')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
            </div>
            <form action="<?php echo e(route('c-panel.domins.update', $item->id )); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label"><?php echo e(__('Domin Name')); ?></label>
                        <input type="text" id="name" name="name" value="<?php echo e($item->name); ?>" class="form-control" required />
                    </div>
                    <div class="mb-3">
                        <label for="price" class="form-label"><?php echo e(__('Domin Price')); ?></label>
                        <input type="text" id="price" name="price" value="<?php echo e($item->price); ?>" class="form-control" required />
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label"><?php echo e(__('Description')); ?></label>
                        <textarea id="description" name="description" class="form-control"> <?php echo e($item->description); ?> </textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="hstack gap-2 justify-content-end">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-success" id="add-btn"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!--end edit modal -->
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\crm\resources\views/admin/domins/datatable/buttons.blade.php ENDPATH**/ ?>