<?php $__env->startSection('pageTitle'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0"><?php echo e(__('Roles')); ?></h4>

                <div class="page-title-right">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addRole"><i
                        class="ri-add-fill me-1 align-bottom"></i> <?php echo e(__('Add Role')); ?></button>
                </div>


            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row mt-4">
        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $routes = [];
                foreach ($role->routes as $key => $value) {
                    # code...
                    $routes[] = $value->id;
                }
            ?>
            <div class="col-xl-3 col-lg-6">
                <div class="card ribbon-box right overflow-hidden">
                    <div class="card-body p-4">
                        <h3 class="mb-3 mt-4"><a href="javascript:;" data-bs-toggle="modal"
                                data-bs-target="#editRole<?php echo e($role->id); ?>"
                                class="link-primary"><?php echo e($role->name); ?></a></h3>
                        <?php if(in_array(1, $routes) || in_array(2, $routes) || in_array(3, $routes) || in_array(4, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Departments')); ?></p><?php endif; ?>
                        <?php if(in_array(6, $routes) || in_array(7, $routes) || in_array(8, $routes) || in_array(9, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Services')); ?></p><?php endif; ?>
                        <?php if(in_array(11, $routes) || in_array(12, $routes) || in_array(13, $routes) || in_array(14, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Plans')); ?></p><?php endif; ?>
                        <?php if(in_array(16, $routes) || in_array(17, $routes) || in_array(18, $routes) || in_array(19, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Domins')); ?></p> <?php endif; ?>
                        <?php if(in_array(21, $routes) || in_array(22, $routes) || in_array(23, $routes) || in_array(24, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Subscriptions')); ?></p><?php endif; ?>
                        <?php if(in_array(26, $routes) || in_array(27, $routes) || in_array(28, $routes) || in_array(29, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Offers')); ?></p><?php endif; ?>
                        <?php if(in_array(31, $routes) || in_array(32, $routes) || in_array(33, $routes) || in_array(34, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Invoices')); ?></p><?php endif; ?>
                        <?php if(in_array(36, $routes) || in_array(37, $routes) || in_array(38, $routes) || in_array(39, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('All Customers')); ?></p><?php endif; ?>
                        <?php if(in_array(40, $routes)): ?><p>- <?php echo e(__('Manage')); ?> <?php echo e(__('Content')); ?></p><?php endif; ?>
                        <div class="mt-4 d-flex">
                            <a href="javascript:;" class="btn btn-primary m-1" data-bs-toggle="modal" data-bs-target="#editRole<?php echo e($role->id); ?>"><i class="ri-edit-box-line"></i></a>
                            <a href="javascript:;" class="btn btn-danger m-1" data-bs-toggle="modal" data-bs-target="#delete-item-<?php echo e($role->id); ?>"><i class="ri-delete-bin-6-line"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <!--end row-->

    <div class="row g-0 text-center text-sm-start align-items-center mb-3">
        <!-- end col -->
        <div class="col-sm-12">
            <?php echo e($roles->links('vendor.pagination.semantic-ui')); ?>

        </div><!-- end col -->
    </div><!-- end row -->

    <!-- Modal -->
    <div class="modal fade zoomIn" id="addRole" tabindex="-1" aria-labelledby="addSellerLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSellerLabel"><?php echo e(__('Add Role')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('c-panel.roles.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-5">
                                    <label for="name" class="form-label"><?php echo e(__('Role Name')); ?></label>
                                    <input type="text" class="form-control" id="name" name="name"
                                        value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Enter role name')); ?>">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12">
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-3"><label class="form-label"><?php echo e(__('Role Permissions')); ?></label></div>
                                        <div class="col-9">
                                            <div class="form-check">
                                                <input class="form-check-input" onchange="selectAll()" type="checkbox" id="select-all">
                                                <label class="form-check-label" for="select-all">
                                                    <?php echo e(__('Select All')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <table class="table table-nowrap text-start">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('Permission')); ?></th>
                                                <th><?php echo e(__('View')); ?></th>
                                                <th><?php echo e(__('Create')); ?></th>
                                                <th><?php echo e(__('Update')); ?></th>
                                                <th><?php echo e(__('Delete')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td><?php echo e(__('Departments')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route1" name="routes[]" value="1"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route2" name="routes[]" value="2"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route3" name="routes[]" value="3"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route4" name="routes[]" value="4"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Customer')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route36" name="routes[]" value="36"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route37" name="routes[]" value="37"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route38" name="routes[]" value="38"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route39" name="routes[]" value="39"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Services')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route6" name="routes[]" value="6"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route7" name="routes[]" value="7"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route8" name="routes[]" value="8"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route9" name="routes[]" value="9"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Plans')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route11" name="routes[]" value="11"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route12" name="routes[]" value="12"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route13" name="routes[]" value="13"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route14" name="routes[]" value="14"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Domins')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route16" name="routes[]" value="16"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route17" name="routes[]" value="17"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route18" name="routes[]" value="18"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route19" name="routes[]" value="19"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Subscriptions')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route21" name="routes[]" value="21"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route22" name="routes[]" value="22"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route23" name="routes[]" value="23"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route24" name="routes[]" value="24"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Offers')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route26" name="routes[]" value="26"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route27" name="routes[]" value="27"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route28" name="routes[]" value="28"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route29" name="routes[]" value="29"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Invoices')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route31" name="routes[]" value="31"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route32" name="routes[]" value="32"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route33" name="routes[]" value="33"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route34" name="routes[]" value="34"></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo e(__('Content Managment')); ?></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route40" name="routes[]" value="40"></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                        data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                        <?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-primary"><i
                                            class="ri-save-3-line align-bottom me-1"></i> <?php echo e(__('Save')); ?></button>
                                </div>
                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end modal-->

    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Modal -->
        <div class="modal fade zoomIn" id="editRole<?php echo e($role->id); ?>" tabindex="-1"
            aria-labelledby="addSellerLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addSellerLabel"><?php echo e(__('Edit Role')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('c-panel.roles.update', $role->id)); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="mb-5">
                                        <label for="name" class="form-label"><?php echo e(__('Role Name')); ?></label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            value="<?php echo e(old('name', $role->name)); ?>" placeholder="<?php echo e(__('Enter role name')); ?>">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="mb-2">
                                        <div class="row">
                                            <div class="col-4"><label class="form-label"><?php echo e(__('Role Permissions')); ?></label></div>
                                            <div class="col-8">
                                                <div class="form-check">
                                                    <input class="form-check-input" onchange="selectAll<?php echo e($role->id); ?>()" type="checkbox" id="select-all<?php echo e($role->id); ?>">
                                                    <label class="form-check-label" for="select-all">
                                                        <?php echo e(__('Select All')); ?>

                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <!--end col-->
                                <?php
                                    $route_ids = [];
                                    foreach ($role->routes as $key => $value) {
                                        # code...
                                        $route_ids[] = $value->id;
                                    }
                                ?>
                                <div class="col-lg-12">
                                    <div class="mb-3">
                                        <table class="table table-nowrap text-start">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('Permission')); ?></th>
                                                    <th><?php echo e(__('View')); ?></th>
                                                    <th><?php echo e(__('Create')); ?></th>
                                                    <th><?php echo e(__('Update')); ?></th>
                                                    <th><?php echo e(__('Delete')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td><?php echo e(__('Departments')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route1" name="routes[]" <?php if(in_array(1, $route_ids)): ?> checked <?php endif; ?> value="1"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route2" name="routes[]" <?php if(in_array(2, $route_ids)): ?> checked <?php endif; ?> value="2"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route3" name="routes[]" <?php if(in_array(3, $route_ids)): ?> checked <?php endif; ?> value="3"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route4" name="routes[]" <?php if(in_array(4, $route_ids)): ?> checked <?php endif; ?> value="4"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Customer')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route36" name="routes[]" <?php if(in_array(36, $route_ids)): ?> checked <?php endif; ?> value="36"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route37" name="routes[]" <?php if(in_array(37, $route_ids)): ?> checked <?php endif; ?> value="37"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route38" name="routes[]" <?php if(in_array(38, $route_ids)): ?> checked <?php endif; ?> value="38"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route39" name="routes[]" <?php if(in_array(39, $route_ids)): ?> checked <?php endif; ?> value="39"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Services')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route6" name="routes[]" <?php if(in_array(6, $route_ids)): ?> checked <?php endif; ?> value="6"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route7" name="routes[]" <?php if(in_array(7, $route_ids)): ?> checked <?php endif; ?> value="7"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route8" name="routes[]" <?php if(in_array(8, $route_ids)): ?> checked <?php endif; ?> value="8"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route9" name="routes[]" <?php if(in_array(9, $route_ids)): ?> checked <?php endif; ?> value="9"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Plans')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route11" name="routes[]" <?php if(in_array(11, $route_ids)): ?> checked <?php endif; ?> value="11"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route12" name="routes[]" <?php if(in_array(12, $route_ids)): ?> checked <?php endif; ?> value="12"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route13" name="routes[]" <?php if(in_array(13, $route_ids)): ?> checked <?php endif; ?> value="13"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route14" name="routes[]" <?php if(in_array(14, $route_ids)): ?> checked <?php endif; ?> value="14"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Domins')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route16" name="routes[]" <?php if(in_array(16, $route_ids)): ?> checked <?php endif; ?> value="16"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route17" name="routes[]" <?php if(in_array(17, $route_ids)): ?> checked <?php endif; ?> value="17"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route18" name="routes[]" <?php if(in_array(18, $route_ids)): ?> checked <?php endif; ?> value="18"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route19" name="routes[]" <?php if(in_array(19, $route_ids)): ?> checked <?php endif; ?> value="19"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Subscriptions')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route21" name="routes[]" <?php if(in_array(21, $route_ids)): ?> checked <?php endif; ?> value="21"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route22" name="routes[]" <?php if(in_array(22, $route_ids)): ?> checked <?php endif; ?> value="22"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route23" name="routes[]" <?php if(in_array(23, $route_ids)): ?> checked <?php endif; ?> value="23"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route24" name="routes[]" <?php if(in_array(24, $route_ids)): ?> checked <?php endif; ?> value="24"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Offers')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route26" name="routes[]" <?php if(in_array(26, $route_ids)): ?> checked <?php endif; ?> value="26"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route27" name="routes[]" <?php if(in_array(27, $route_ids)): ?> checked <?php endif; ?> value="27"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route28" name="routes[]" <?php if(in_array(28, $route_ids)): ?> checked <?php endif; ?> value="28"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route29" name="routes[]" <?php if(in_array(29, $route_ids)): ?> checked <?php endif; ?> value="29"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Invoices')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route31" name="routes[]" <?php if(in_array(31, $route_ids)): ?> checked <?php endif; ?> value="31"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route32" name="routes[]" <?php if(in_array(32, $route_ids)): ?> checked <?php endif; ?> value="32"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route33" name="routes[]" <?php if(in_array(33, $route_ids)): ?> checked <?php endif; ?> value="33"></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route34" name="routes[]" <?php if(in_array(34, $route_ids)): ?> checked <?php endif; ?> value="34"></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(__('Content Managment')); ?></td>
                                                    <td><input class="form-check-input edit-check<?php echo e($role->id); ?>"  onchange="chechAll<?php echo e($role->id); ?>()" type="checkbox" id="<?php echo e($role->id); ?>route40" name="routes[]" <?php if(in_array(40, $route_ids)): ?> checked <?php endif; ?> value="40"></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                            data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                            <?php echo e(__('Close')); ?></button>
                                        <button type="submit" class="btn btn-primary"><i
                                                class="ri-save-3-line align-bottom me-1"></i> <?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end modal-->

        <!-- Delete Modal -->
        <div class="modal fade zoomIn" id="delete-item-<?php echo e($role->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                            id="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <form action=" <?php echo e(route('c-panel.roles.destroy', $role->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <div class="mt-2 text-center">
                                <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop"
                                    colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px">
                                </lord-icon>
                                <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                    <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                                    <p class="text-muted mx-4 mb-0">
                                        <?php echo e(__('Are you Sure You want to Remove this Record ?')); ?></p>
                                </div>
                            </div>
                            <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                <button type="button" class="btn w-sm btn-light"
                                    data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                <button type="submit" class="btn w-sm btn-danger "
                                    id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end delete modal -->
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    

    <script>
        var select_all = document.getElementById("select-all");
        var allInputs = document.getElementsByClassName('create-check');
        function selectAll(){
            if(select_all.checked == true){
                for (let i = 0; i < allInputs.length; i++) {
                    allInputs[i].checked = true;
                };
            } else {
                for (let i = 0; i < allInputs.length; i++) {
                    allInputs[i].checked = false;
                };
            }

        }

        function chechAll(){
            var count = 0;

            for (let i = 0; i < allInputs.length; i++) {
                if(allInputs[i].checked == true){
                    count++;
                } else {
                    count--;
                }
            };

            if(count == allInputs.length){
                select_all.checked = true;
            } else {
                select_all.checked = false;
            }
        }

        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            var select_all<?php echo e($role->id); ?> = document.getElementById("select-all<?php echo e($role->id); ?>");
            var allInputs<?php echo e($role->id); ?> = document.getElementsByClassName('edit-check<?php echo e($role->id); ?>');
            function selectAll<?php echo e($role->id); ?>(){
                if(select_all<?php echo e($role->id); ?>.checked == true){
                    for (let i = 0; i < allInputs<?php echo e($role->id); ?>.length; i++) {
                        allInputs<?php echo e($role->id); ?>[i].checked = true;
                    };
                } else {
                    for (let i = 0; i < allInputs<?php echo e($role->id); ?>.length; i++) {
                        allInputs<?php echo e($role->id); ?>[i].checked = false;
                    };
                }

            }

            function chechAll<?php echo e($role->id); ?>(){
                var count<?php echo e($role->id); ?> = 0;

                for (let i = 0; i < allInputs<?php echo e($role->id); ?>.length; i++) {
                    if(allInputs<?php echo e($role->id); ?>[i].checked == true){
                        count<?php echo e($role->id); ?>++;
                    } else {
                        count<?php echo e($role->id); ?>--;
                    }
                };

                if(count<?php echo e($role->id); ?> == allInputs<?php echo e($role->id); ?>.length){
                    select_all<?php echo e($role->id); ?>.checked = true;
                } else {
                    select_all<?php echo e($role->id); ?>.checked = false;
                }
            }


            window.onload = function() {
                chechAll<?php echo e($role->id); ?>();
            };
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crmdivvat/public_html/resources/views/admin/roles/index.blade.php ENDPATH**/ ?>