@extends('front.layout.app')

@section('title')
        
@stop
 

@section('content')
  
<section id="page-title background-dark">
    <div class="container">
    <div class="page-title">
    <div data-animate="fadeIn">
    <h1 class="text-white">{{ $work->title_ar }}</h1>
    </div>
    <div class="portfolio-attributes style1">
    <div class="attribute" data-animate="fadeInUp" data-animate-delay="1000">
    <strong>العميل:</strong>{{ $work->client }}</div>
    <div class="attribute" data-animate="fadeInUp" data-animate-delay="1200"><strong>Date:</strong>
        {{ $work->date  }}</div>
    @if ($work->category)
    <div class="attribute" data-animate="fadeInUp" data-animate-delay="1400">
        <strong>الخدمة:</strong>{{ $work->category->title_ar}}</div> 
    @endif
    </div>
    <div class="portfolio-share" data-animate="fadeIn" data-animate-delay="1600">
    <h4 class="text-white">شارك العمل</h4>
    <div class="align-center">
    <a class="btn btn-xs btn-slide btn-light"href="https://www.facebook.com/sharer/sharer.php?u={{ url('/') }}/work/{{$work->id}}&display=popup" target="_blank">
    <i class="fab fa-facebook-f"></i>
    <span>Facebook</span>
    </a>
    <a class="btn btn-xs btn-slide btn-light" href="https://twitter.com/intent/tweet?url={{ url('/') }}/work/{{$work->id}}" target="_blank" data-width="100">
    <i class="fab fa-twitter"></i>
    <span>Twitter</span>
    </a> 
    </div>
    </div>
    </div>
    </div>
    </section>
    
    
    <section id="page-content background-dark" class="p-b-0">
    <div class="container">
    <div class="grid-layout grid-2-columns" data-item="grid-item" data-margin="30" data-lightbox="gallery">
    <div class="grid-item large-width">
    <a title="Saiba Chair" data-lightbox="gallery-image" href="{{ asset('storage/works/' . ($work->image ?? '')) }}">
    <img src="{{ asset('storage/works/' . ($work->image ?? '')) }}">
    </a>
    </div>
    @foreach ($work->work_images as $item)
    <div class="grid-item">
        <a title="Saiba Chair" data-lightbox="gallery-image" href="{{ asset('storage/works/' . ($item->image ?? '')) }}">
        <img src="{{ asset('storage/works/' . ($item->image ?? '')) }}">
        </a>
        </div>
    @endforeach
    
     
    </div>
    <hr class="space">
    <div class="row m-b-40">
    <div class="col-lg-8 center">
    @if ($work->description_ar)
    <div class="project-description">
        <h2 class="text-white">وصف العمل</h2>
        <h3 class="text-white">{{ $work->description_ar }}</h3>
        </div>
    @endif 
    <div class="portfolio-attributes">
    <div class="attribute"><strong>العميل:</strong>{{ $work->client }}</div>
    @if ($work->link)
    <div class="attribute"><strong>Website:</strong> <a href="{{ $work->link }}" title="Mindsparkle Shop" target="_blank">mindsparkleshop.com</a></div>

    @endif
    <div class="attribute"><strong>التاريخ:</strong> {{ $work->date }}</div>
    @if ($work->category)
    <div class="attribute" >
        <strong>الخدمة:</strong>{{ $work->category->title_ar}}</div> 
    @endif 
    </div>
    @if ($work->link)
    <div> <a href="{{ $work->link }}" class="btn btn-dark btn-outline">زيارة الموقع</a></div>
        
    @endif
    </div>
    </div>
    </div>
     
    </section>
    
     
@endsection

@section('js')
    
@endsection

