@extends('front.layout.app')

@section('title')
        
@stop
 

@section('content') 
<section id="page-title">
   <div class="container">
      <div class="page-title">
         <h1><a href="{{ route('view.package',$package->id) }}">@if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $package->title_ar }}@else{{  $package->title }}
        @endif</h1>
         
      </div>
      <div class="breadcrumb">
         <ul>
            <li> <a href="{{ route('view.home') }}"> الصفحة الرئيسية </a> </li> 
                    <li class="active"> <a >  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                        {{ $menu['ar']['view.packages'] }}@else{{ $menu['en']['view.packages'] }}
                    @endif   </a> </li>
         </ul>
      </div>
   </div>
</section>
<section id="content">
   <div class="container">
      <div class="heading-text heading-line text-center pb-5">
         <h4>خطط الباقة</h4>
      </div>
      
 @if (Session::has('success'))  
 <div class="alert alert-success p-2">

 <h5 class="text-center pt-1"> {{ Session::get('success') }}</h5>

</div> 

@endif
@if (Session::has('error'))  
 <p class="text-center text-danger">   {{ Session::get('error') }}
</p> 
@endif
@if ($errors->any())   
<div class="alert alert-danger p-2">
 <ul>
     @foreach ($errors->all() as $error)
         <li>{{ $error }}</li>
     @endforeach
 </ul>
</div> 
@endif

      <div class="row pricing-table">
         @foreach ($package->plans as $plan)
         <div class="col-lg-4 col-md-12 col-12">
            <div class="plan">
               <div class="plan-header">
                  <h4 style="color: black">@if (LaravelLocalization::getCurrentLocale() == 'ar')
                     {{ $plan->title_ar }}@else{{$plan->title}}
                     @endif  </h4>
                  <p class="text-muted">@if (LaravelLocalization::getCurrentLocale() == 'ar')
                     {{ $plan->sub_title_ar }}@else{{  $plan->sub_title }}
                     @endif</p>
                  <div class="plan-price" style="color: black"><sup>$</sup>{{  $plan->price }} </div> 
               </div>
               <div class="plan-list">
                  <ul>
                      @foreach ( $plan->features as $feature)
                     <li style="color: black"><i> -</i> {{ $feature->name }} </li> 
                      @endforeach
                  </ul>
                  <div class="plan-button"> 
                     <a data-target="#modal-{{ $plan->id }}" data-toggle="modal" href="#" class="btn btn-light">اطلب الان</a>
                  </div>
               </div>
            </div>
         </div>
         
         @endforeach 
      </div>
   </div>
</section>
@foreach ($package->plans as $plan1)

<div class="modal fade" id="modal-{{ $plan1->id }}" tabindex="-1" role="modal" aria-labelledby="modal-label-2" aria-hidden="true" >
   <div class="modal-dialog" >
      <div class="modal-content" style="background-color: white">
         <div class="modal-header">
            <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
            <h3 class="text-uppercase" style="color:black" >يسعدنا تواصلك معنا</h3>
            <h4 class="text-uppercase"  style="color:rgb(83, 83, 83)" >@if (LaravelLocalization::getCurrentLocale() == 'ar')
               {{ $plan1->title_ar }}@else{{$plan1->title}}
               @endif </h4> 
           <div class="m-t-30"> <div id="success_message_subscriber"></div>
           <form enctype="multipart/form-data" method="post" action="{{ route('view.order') }}">
           @csrf
           <input type="hidden" name="package_plan_id" value="{{ $plan1->id }}">
           <input type="hidden" name="package_id" value="{{ $package->id }}">

           <div class="row">
           <div class="form-group col-md-6">
           <label for="name">الاسم</label>
           <input type="text" aria-required="true" id="contactName" name="name" required class="form-control required name" placeholder="ادخل اسمك" style="background-color: white; color:black"> 
           </div>
           <div class="form-group col-md-6">
           <label for="email">االبريد الالكتروني</label>
           <input type="email" id="contactEmail" aria-required="true" name="email" class="form-control " placeholder="ادخل بريدك الالكتروني" style="background-color: white; color:black">  
           </div>
           <div class="form-group col-md-6">
            <label for="phone">رقم الجوال</label>
            <input type="text" id="phone" aria-required="true" name="phone" required class="form-control " placeholder="ادخل رقم الجوال" style="background-color: white; color:black">
            </div>
            <div class="form-group col-md-8">
               <label for="message">ملاحظات</label>
               <textarea type="text" name="description" id="contactMassage" required rows="5" class="form-control " placeholder="ادخل ملاحظاتك" style="background-color: white; color:black"></textarea>
             </div>
           
            </div> 
           
           <button class="btn" id="form-submit"  type="submit"><i class="fa fa-paper-plane"></i>&nbsp;ارسل </button>
           </form>
         </div>
         </div>
      </div>
   </div>
</div>
@endforeach 

@endsection

@section('js')
    
@endsection

