@extends('front.layout.app')

@section('title')
    @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.our-job'] }}@else{{ $menu['en']['view.our-job'] }}
    @endif
@stop

@section('slider')
     <!-- Banner -->
     <div class="header-banner bg-theme-grad">
        <div class="nk-banner">
            <div class="banner banner-page">
                <div class="banner-wrap">
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-xl-6 col-lg-9">
                                <div class="banner-caption cpn tc-light text-center">
                                    <div class="cpn-head">
                                        <h2 class = "title ttu">
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $menu['ar']['view.our-job'] }}@else{{ $menu['en']['view.our-job'] }}
                                            @endif
                                        </h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- .nk-banner -->
        <div class="nk-ovm shape-a-sm"></div>
    </div>
    <!-- .header-banner -->
@endsection

@section('content')
<main class="nk-pages">


    <section class="section bg-light">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-6">
                    <div class="section-head section-head-s2">
                        <h2 class="title title-xl animated fadeInUp" data-animate="fadeInUp" data-delay="0.1" title="FAQS" style="visibility: visible; animation-delay: 0.1s;">
                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ $menu['ar']['view.our-job'] }}@else{{ $menu['en']['view.our-job'] }}
                            @endif
                        </h2>
                        <p class="animated fadeInUp" data-animate="fadeInUp" data-delay="0.2" style="visibility: visible; animation-delay: 0.2s;">{{ __('هذا ما نبدع في انجازه ونفتخر بتقديمه لعملاءنا.') }}</p>
                    </div>
                </div>
            </div>
            <!-- Block -->
            <div class="nk-block">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <ul class="nav tab-nav tab-nav-btn tab-nav-btn-bdr tab-nav-center pdb-r animated fadeInUp" data-animate="fadeInUp" data-delay="0.3" style="visibility: visible; animation-delay: 0.3s;">
                            @foreach($groups as $group)
                                <li>
                                    <a @if($loop->first) class="active" @endif data-bs-toggle="tab" href="#tab-2-{{ $group->id }}">
                                        @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                            {{ $group->name_ar }} @else {{ $group->name }}
                                        @endif
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                        <div class="tab-content">
                            @foreach($groups as $group)
                            <div class="tab-pane fade @if($loop->first) active show @endif " id="tab-2-{{ $group->id }}">
                                <div class="nk-block nk-block-text-wrap">
                                    <div class="nk-block-text">
                                        <div class="beta-product text-center">

                                            <div class="row justify-content-center gutter-vr-30px">
                                                @foreach($group->works as $work)
                                                <div class="col-lg-4">
                                                    <a href="#" class="product-box">
                                                        <h5 class="product-name">
                                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                                {{ $work->title_ar }} @else {{ $work->title }}
                                                            @endif
                                                        </h5>
                                                        <div class="product-image"><img src="{{ asset('storage/'.$work->image) }}" alt="{{ $work->title }}"></div>
                                                    </a>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div><!-- .nk-block @e -->
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div><!-- .block -->
        </div>
    </section>
</main>
@endsection
