<!DOCTYPE html>
<html lang="ar" class="js" dir="rtl">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <!-- App favicon -->
    <link rel="shortcut icon" href="@if($setting->footer_logo){{ asset('storage/'.$setting->footer_logo) }}@else{{ asset('assets/images/favicon.ico') }}@endif">

    <!-- Site Title  -->
    <title>
        @if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $setting->title_ar }}@else{{ $setting->title }}
        @endif | @yield('title')
    </title>
    <!-- Bundle and Base CSS -->
    <link rel="stylesheet" href="{{ asset('front/assets/css/vendor.bundle.css?ver=200') }}">
    <link rel="stylesheet" href="{{ asset('front/assets/css/style-salvia.css?ver=200') }}">

    <!-- Extra CSS -->
    <link rel="stylesheet" href="{{ asset('front/assets/css/theme.css?ver=200') }}">
    <link rel="stylesheet" href="{{ asset('front/assets/css/rtl.css?ver=200') }}">
</head>

<body class="nk-body body-wider mode-onepage has-rtl" dir="rtl">
    <x-alerts />
    <div class="nk-body body-wider mode-onepage">
        <div class="nk-wrap">
            <header class="nk-header page-header is-transparent is-sticky is-shrink  @if(\Request::route()->getName() == 'view.home') is-split @endif" id="header">
                <!-- Header -->
                <div class="header-main">
                    <div class="container container-xxl">
                        <div class="header-wrap">
                            <!-- Logo -->
                            <div class="header-logo logo animated" data-animate="fadeInDown" data-delay=".65">
                                <a href="./" class="logo-link">
                                    <img class="logo-dark" src="{{ asset('storage/'.$setting->main_logo) }}" srcset="{{ asset('storage/'.$setting->main_logo) }}" alt="logo">
                                    <img class="logo-light" src="{{ asset('storage/'.$setting->footer_logo) }}" srcset="{{ asset('storage/'.$setting->footer_logo) }}" alt="logo">
                                </a>
                            </div>
                            <!-- Menu Toogle -->
                            <div class="header-nav-toggle">
                                <a href="#" class="navbar-toggle" data-menu-toggle="header-menu">
                                    <div class="toggle-line">
                                        <span></span>
                                    </div>
                                </a>
                            </div>
                            <!-- Menu -->
                            <div class="header-navbar header-navbar-s2 flex-grow-1 animated" data-animate="fadeInDown" data-delay=".75">
                                <nav class="header-menu header-menu-s2" id="header-menu">
                                    <ul class="menu mx-auto">
                                        <li class="menu-item">
                                            <a class="menu-link nav-link" href="{{ route('view.home') }}">
                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                    {{ $menu['ar']['view.home'] }}@else{{ $menu['en']['view.home'] }}
                                                @endif
                                            </a>
                                        </li>
                                        <li class="menu-item">
                                            <a class="menu-link nav-link" href="{{ route('view.about') }}">
                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                    {{ $menu['ar']['view.about'] }}@else{{ $menu['en']['view.about'] }}
                                                @endif
                                            </a>
                                        </li>
                                        <li class="menu-item">
                                            <a class="menu-link nav-link menu-toggle" href="#">
                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                    {{ $menu['ar']['view.services'] }}@else{{ $menu['en']['view.services'] }}
                                                @endif
                                            </a>

                                        </li>
                                        <li class="menu-item">
                                            <a class="menu-link nav-link" href="{{ route('view.our-job') }}">
                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                    {{ $menu['ar']['view.our-job'] }}@else{{ $menu['en']['view.our-job'] }}
                                                @endif
                                            </a>

                                        </li>

                                        <li class="menu-item has-sub">
                                            <a class="menu-link nav-link menu-toggle" href="#">
                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                    {{ $menu['ar']['view.hosting-services'] }}@else{{ $menu['en']['view.hosting-services'] }}
                                                @endif
                                            </a>
                                            <div class = "menu-sub menu-drop menu-mega menu-mega-2clmn">
                                                <div class = "menu-mega-innr">
                                                    <ul class = "menu-mega-list">
                                                        <li class = "menu-item">
                                                            <a href="#">
                                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                                    {{ $menu['ar']['view.shared-hosting'] }}@else{{ $menu['en']['view.shared-hosting'] }}
                                                                @endif
                                                            </a>
                                                        </li>
                                                        <li class = "menu-item">
                                                            <a href="#">
                                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                                    {{ $menu['ar']['view.hosting'] }}@else{{ $menu['en']['view.hosting'] }}
                                                                @endif
                                                            </a>
                                                        </li>

                                                    </ul>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="menu-item">
                                            <a class="menu-link nav-link" href="{{ route('view.home') }}#contactSection">
                                                @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                    {{ $menu['ar']['view.contact-us'] }}@else{{ $menu['en']['view.contact-us'] }}
                                                @endif
                                            </a>
                                        </li>
                                    </ul>
                                    <ul class="menu-btns">
                                        @if(Auth::user())
                                        <li> <a href="#" onclick="document.getElementById('logout').submit()" class="btn btn-md btn-auto btn-secondary btn-outline no-change">  <span> {{ __('تسجيل الخروج') }} </span> </a> </li>
                                            <li> <a href="{{ route('client.login') }}" class="btn btn-md btn-auto btn-secondary no-change focus"> <span> {{ __('لوحة التحكم') }} </span> </a> </li>
                                            <form action="{{ route('logout') }}" method="post" class="d-none" id="logout">
                                                @csrf
                                                <button type="submit"></button>
                                            </form>
                                        @else
                                        {{-- <li> <a href="#" class="btn btn-md btn-auto btn-secondary btn-outline no-change">  <span> {{ __('فتح تذكرة') }} </span> </a> </li> --}}
                                        <li> <a href="{{ route('client.login') }}" class="btn btn-md btn-auto btn-secondary no-change focus"> <span> {{ __('تسجيل الدخول') }} </span> </a> </li>
                                        @endif
                                    </ul>
                                </nav>
                            </div><!-- .header-navbar -->
                        </div>
                    </div>
                </div><!-- .header-main -->
                @yield('slider')
            </header>

            @yield('content')

            <!-- Footer -->
            <footer class="nk-footer bg-theme ov-h">
                <section class="section section-m section-footer tc-light bg-transparent ov-h">
                    <div class="container">
                        <!-- Block -->
                        <div class="nk-block block-footer mgb-m30">
                            <div class="row justify-content-between">
                                <div class="col-sm-6 mb-sm-0 col-12">
                                    <div class="wgs wgs-menu animated" data-animate="fadeInUp" data-delay="0.1">
                                        <h6 class = "wgs-title">
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $setting->title_ar }}@else{{ $setting->title }}
                                            @endif
                                        </h6>
                                         <p>
                                            @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $setting->bio_ar }}@else{{ $setting->bio }}
                                            @endif
                                         </p>
                                    </div>
                                </div><!-- .col -->
                                <div class="col-sm-2 mb-sm-0 col-0">

                                </div><!-- .col -->
                                <div class="col-sm-2 mb-sm-0 col-6">
                                    <div class="wgs wgs-menu animated" data-animate="fadeInUp" data-delay="0.2">
                                        <h6 class = "wgs-title"> القائمة </h6>
                                            <div class = "wgs-body">
                                                <ul class = "wgs-links">
                                                    <li> <a href="{{ route('view.home') }}"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                        {{ $menu['ar']['view.home'] }}@else{{ $menu['en']['view.home'] }}
                                                    @endif </a> </li>
                                                    <li> <a href="#">
                                                        @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                            {{ $menu['ar']['view.services'] }}@else{{ $menu['en']['view.services'] }}
                                                        @endif
                                                    </a> </li>
                                                    <li> <a href="#">
                                                        @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                            {{ $menu['ar']['view.our-job'] }}@else{{ $menu['en']['view.our-job'] }}
                                                        @endif
                                                    </a> </li>
                                                    <li> <a href="#">
                                                        @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                            {{ $menu['ar']['view.hosting'] }}@else{{ $menu['en']['view.hosting'] }}
                                                        @endif
                                                    </a> </li>
                                                </ul>
                                            </div>
                                    </div>
                                </div><!-- .col -->

                                <div class="col-sm-2 mb-sm-0 col-6">
                                    <div class="wgs wgs-menu animated" data-animate="fadeInUp" data-delay="0.4">
                                        <h6 class = "wgs-title"> {{ __('التواصل') }} </h6>
                                            <div class = "wgs-body">
                                                <ul class = "wgs-links">
                                                    {{-- <li> <a href="#"> {{ __('فتح تذكرة') }} </a> </li> --}}
                                                    @if(Auth::user())
                                                    <li> <a href="{{ route('client.login') }}"> {{ __('لوحة التحكم') }} </a> </li>
                                                    @else
                                                    <li> <a href="{{ route('client.login') }}"> {{ __('تسجيل دخول') }}</a> </li>
                                                    <li> <a href="{{ route('register') }}"> {{ __('حساب جديد') }} </a> </li>
                                                    @endif
                                                    <li> <a href="#"> {{ __('طلب خدمة') }} </a> </li>
                                                </ul>
                                            </div>
                                    </div>
                                </div><!-- .col -->
                            </div><!-- .row -->
                        </div><!-- .block -->
                    </div>
                </section>
                <div class="section section-fb pt-0 footer-bottom animated" data-animate="fadeInUp" data-delay="0.5">
                    <div class="container">
                        <div class="row justify-content-md-between align-items-center">
                            <div class="col-lg-6 col-md-3 col-sm-4">
                                <a href="./" class="wgs-logo-s2 d-inline-block mb-2 mb-md-0">
                                    <img src="images/logo-full-white.png" srcset="{{ asset('storage/'.$setting->footer_logo) }}" alt="logo">
                                </a>
                            </div>
                            <div class="col-lg-6 col-md-8">
                                <div class="copyright-text">
                                    <ul class="d-flex justify-content-between align-items-center flex-wrap flex-md-nowrap">
                                        <li> <a href="#"> {{ __('اتفاقية المستخدم') }} </a> </li>
                                        <li> <a href="#"> {{ __('سياسة الخصوصية') }} </a> </li>
                                        <li>
                                            <p> &copy; {{ __('تشفير ICO. كل الحقوق محفوظة') }} </p>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nk-ovm shape-z7 ov-h"></div>
            </footer>
        </div>
        <!-- preloader -->
        <div class="preloader preloader-alt no-split"><span class="spinner spinner-alt"><img class="spinner-brand" src="images/logo-full-white.png" alt=""></span></div>
        <!-- JavaScript -->
        <script src="{{ asset('front/assets/js/jquery.bundle.js?ver=200') }}"></script>
        <script src="{{ asset('front/assets/js/scripts.js?ver=200') }}"></script>
        <script src="{{ asset('front/assets/js/charts.js?ver=200') }}"></script>
        <script src="{{ asset('front/assets/js/charts.js?ver=200') }}"></script>

        @yield('js')
    </div>
</body>
</html>
