<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta name="viewport" content="width=device-width, initial-scale=1" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" /> <meta name="author" content="INSPIRO" />
<meta name="description" content="Themeforest Template Polo, html template">
<link rel="shortcut icon" href="@if($setting->footer_logo){{ asset('storage/works/'.$setting->footer_logo) }}@else{{ asset('assets/images/favicon.ico') }}@endif">
<meta http-equiv="X-UA-Compatible" content="IE=edge">

<title>
    @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $setting->title_ar }}@else{{ $setting->title }}
    @endif | @yield('title')
</title>
<link href="{{ asset('front/css/plugins.css') }}" rel="stylesheet">
<link href="{{ asset('front/css/style.css') }}" rel="stylesheet">

</head>
<body class="background-black text-right dark" dir="rtl" style="text-align: right !important;">

<div class="body-inner">

<header id="header" class="header-mini dark">
<div class="header-inner">
<div class="container">

<div id="logo">
    <a href="{{ route('view.home') }}">
        <span class="logo-default"><img src="{{ asset('storage/works/'.$setting->main_logo) }}" height="143" width="652"/></span>
        <span class="logo-dark"><img src="{{ asset('storage/works/'.$setting->main_logo) }}" height="143" width="652"/></span>
    </a>
</div>

<div id="search"><a id="btn-search-close" class="btn-search-close" aria-label="Close search form"><i class="icon-x"></i></a>
<form class="search-form" action="search-results-page.html" method="get">
<input class="form-control" name="q" type="text" placeholder="اكتب وابحث ..." />
<span class="text-muted">ابدأ الكتابة واضغط على "Enter" أو "ESC" للإغلاق</span>
</form>
</div> 

<div class="header-extras">
<ul>
<li> <a id="btn-search" href="#"> <i class="icon-search"></i></a> </li>
<li>
<div class="p-dropdown"> <a href="#"><i class="icon-globe"></i><span>EN</span></a>
<ul class = "p-dropdown-content">

<li> <a href="#"> الإنجليزية </a> </li>
</ul>
</div>
</li>
</ul>
</div>

<div id="mainMenu-trigger"> <a class="lines-button x"><span class="lines"></span></a> </div>

<div id="mainMenu">
<div class="container" >
<nav>
<ul >
    <li> <a href="{{ route('view.home') }}">   @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.home'] }}@else{{ $menu['en']['view.home'] }}
    @endif</a> </li>
    <li class = "dropdown" > <a href="{{ route('view.about') }}"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.about'] }}@else{{ $menu['en']['view.about'] }}
    @endif</a>
</li>
<li class = "dropdown"> <a href="{{ route('view.about') }}"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
    {{ $menu['ar']['view.services'] }}@else{{ $menu['en']['view.services'] }}
@endif </a>
</li>
<li class = "dropdown  mega-menu-item"> <a href="{{ route('view.works') }}"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
    {{ $menu['ar']['view.our-job'] }}@else{{ $menu['en']['view.our-job'] }}
@endif</a>
</li>
<li class="dropdown"><a href="{{ route('view.partners') }}">@if (LaravelLocalization::getCurrentLocale() == 'ar')
    {{ $menu['ar']['view.partners'] }}@else{{ $menu['en']['view.partners'] }}
@endif</a>
</li>
<li class="dropdown"><a href="#">@if (LaravelLocalization::getCurrentLocale() == 'ar')
    {{ $menu['ar']['view.packages'] }}@else{{ $menu['en']['view.packages'] }}
@endif</a>
<ul class="dropdown-menu"> 
    @foreach (App\Models\Package::get() as $package)
    <li><a href="{{ route('view.package',$package->id) }}">@if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $package->title_ar }}@else{{  $package->title }}
    @endif</a></li>
        
    @endforeach
     </ul>
</li>
 
<li class="dropdown mega-menu-item"><a href="{{ route('view.blogs') }}">@if (LaravelLocalization::getCurrentLocale() == 'ar')
    {{ $menu['ar']['view.blogs'] }}@else{{ $menu['en']['view.blogs'] }}
@endif</a>
</li>
<li class="dropdown mega-menu-item"><a href="{{ route('view.contact_us') }}"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
    {{ $menu['ar']['view.contact-us'] }}@else{{ $menu['en']['view.contact-us'] }}
@endif </a>
</li>
</ul>
</nav>
</div>
</div>

</div>
</div>
</header>

@yield('content')

    <footer id="footer">
        <div class="footer-content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="widget">
                            <div class="widget-title">
                                <a href="{{ route('view.home') }}">
                                    <p class="logo-footer">
                                        <img src="{{ asset('storage/works/'.$setting->footer_logo) }}"/>
                                    </p>
                                </a>
                            </div>
                            <p class="mb-3"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ $setting->bio_ar }}@else{{ $setting->bio }}
                            @endif  </p>
                            <a href="https://themeforest.net/item/polo-responsive-multipurpose-html5-template/13708923" class="btn btn-inverted" target="_blank">شراء الآن</a>
                        </div>
                    </div>

                    <div class="col-xl-2 col-lg-2 col-md-4">

                        <div class="widget">
                            <h4>القائمة</h4>
                            <ul class="list">
                                <li><a href="#">تعرف علينا </a></li>
                                <li><a href="#">خدماتنا</a></li>
                                <li><a href="#">معرض الاعمال</a></li>
                                <li><a href="#">المدونة</a></li>
                            </ul>
                        </div>

                    </div>
                    <div class="col-xl-2 col-lg-2 col-md-4">

                        <div class="widget">
                            <h4>روابط تهمك</h4>
                            <ul class="list">
                                <li><a href="#">الباقات والعروض</a></li>
                                <li><a href="#">شركاء النجاح </a></li>
                                <li><a href="#">طلب عرض سعر</a></li>
                                <li><a href="#">انضم الي فريقنا</a></li>
                            </ul>
                        </div>

                    </div>
                    <div class="col-lg-3  col-lg-2 col-md-4">

                        <div class="widget  widget-contact-us" style="background-image: url('{{ asset('front/images/world-map-dark.png') }}'); background-position: 50% 20px;    background-size: cover; background-repeat: no-repeat">
                            <h4>تواصل معنا</h4>
                            <ul class="list-icon">
                                <li><i class="fa fa-map-marker-alt"></i>@if (LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $setting->address_ar }}@else{{ $setting->address }}
                                @endif</li>
                                <li><i class="fa fa-phone"></i><a href="tel:{{ $setting->phone }}"> {{ $setting->phone }}</a></li>
                                <li><i class="far fa-envelope"></i> <a href="mailto:{{ $setting->email }}"> {{ $setting->email }}</a> </li>

                            </ul>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="copyright-content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">

                        <div class="social-icons social-icons-colored float-left">
                            <ul>
                                @if ($setting->facebook)
                                <li class="social-facebook"><a href="{{ $setting->facebook }}"><i class="fab fa-facebook-f"></i></a></li>
                                @endif
                                @if ($setting->twitter)
                                <li class="social-twitter"><a href="{{ $setting->twitter }}"><i class="fab fa-twitter"></i></a></li>
                                @endif
                                @if ($setting->youtube)
                                <li class="social-youtube"><a href="{{ $setting->youtube }}"><i class="fab fa-youtube"></i></a></li>
                                @endif
                                @if ($setting->instagram)
                                <li class="social-instagram"><a href="{{ $setting->instagram }}"><i class="fab fa-instagram"></i></a></li>
                                @endif
                                @if ($setting->whatsapp)
                                <li class="social-whatsapp"><a href="{{ $setting->whatsapp }}"><i class="fab fa-whatsapp"></i></a></li>

                                @endif

                            </ul>
                        </div>

                    </div>
                    <div class="col-lg-6">
                        <div class="copyright-text text-right">جميع الحقوق محفوظة لشركة ديفات.</div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>


<a id="scrollTop"><i class="icon-chevron-up"></i><i class="icon-chevron-up"></i></a>

<script src="{{ asset('front/js/jquery.js') }}"></script>
<script src="{{ asset('front/js/plugins.js') }}"></script> 
<script src="{{ asset('front/js/functions.js') }}"></script>
@yield('js')
</body>
</html>