@extends('front.layout.app')

@section('title')
    @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $menu['ar']['view.home'] }}@else{{ $menu['en']['view.home'] }}
    @endif
@stop
 

@section('content')
<div id="slider" class="inspiro-slider background-black" data-height-xs="360">
   <div class="slide" style="background-image:url('{{ asset('storage/' . ($main_slider->image ?? '')) }}');">
      <div class="bg-overlay" data-style="10"></div>
      <div class="container">
         <div class="slide-captions text-center text-light">
            <h3>  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                {{ $main_slider->title_ar }}@else{{ $main_slider->title }}
                @endif  </h3>
            <h2><span class="text-rotator" data-animation="flip" data-speed="5000"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
                {{ $main_slider->sub_title_ar }}@else{{ $main_slider->sub_title }}
                @endif  </span></h2>
            <button type="button" class="btn btn-danger" data-target="#modal-2" data-toggle="modal" href="#"><span class="btn-label"><i class="fa fa-check"></i></span>احصل على عرض أسعار</button>
            
 @if (Session::has('success'))  
 <div class="alert alert-success p-2">

 <h5 class="text-center pt-1"> {{ Session::get('success') }}</h5>

</div> 

@endif
@if (Session::has('error'))  
 <p class="text-center text-danger">   {{ Session::get('error') }}
</p> 
@endif
@if ($errors->any())   
<div class="alert alert-danger p-2">
 <ul>
     @foreach ($errors->all() as $error)
         <li>{{ $error }}</li>
     @endforeach
 </ul>
</div> 
@endif
         </div>
      </div>
   </div>
</div>
<div class="modal fade" id="modal-2" tabindex="-1" role="modal" aria-labelledby="modal-label-2" aria-hidden="true">
   <div class="modal-dialog">
      <div class="modal-content" style="background-color: white">
         <div class="modal-header">
            <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
            <h3 class="text-uppercase" style="color:black" >ابقى على تواصل</h3>
            <p class="mb-3" style="color:black"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
               {{ $setting->bio_ar }}@else{{ $setting->bio }}
           @endif  </p> 
           <div class="m-t-30"> <div id="success_message_subscriber"></div>
           <form enctype="multipart/form-data" method="post" action="{{ route('view.order') }}">
            @csrf 
            <div class="row">
            <div class="form-group col-md-6">
            <label for="name">الاسم</label>
            <input type="text" aria-required="true" id="contactName" name="name" required class="form-control required name" placeholder="ادخل اسمك" style="background-color: white; color:black"> 
            </div>
            <div class="form-group col-md-6">
            <label for="email">االبريد الالكتروني</label>
            <input type="email" id="contactEmail" aria-required="true" name="email" class="form-control " placeholder="ادخل بريدك الالكتروني" style="background-color: white; color:black">  
            </div>
            <div class="form-group col-md-6">
             <label for="phone">رقم الجوال</label>
             <input type="text" id="phone" aria-required="true" name="phone" required class="form-control " placeholder="ادخل رقم الجوال" style="background-color: white; color:black">
             </div>
             <div class="form-group col-md-6">
               <label for="package">اختر الخدمة</label>
               <select  id="package_id" name="package_id" class="form-control " style="background-color: white; color:black">
                  <option value="">{{ __('يجب اختيار خدمة') }}</option> 
                      @foreach (App\Models\Package::get() as $item)
                          <option value="{{ $item->id }}"
                              @if ($item->id == old('package_id')) selected @endif>{{ $item->title_ar }}
                          </option>
                      @endforeach
               </select>
               </div>
             <div class="form-group col-md-8">
                <label for="message">ملاحظات</label>
                <textarea type="text" name="description" id="contactMassage" required rows="5" class="form-control " placeholder="ادخل ملاحظاتك" style="background-color: white; color:black"></textarea>
              </div>
            
             </div> 
            
            <button class="btn" id="form-submit"  type="submit"><i class="fa fa-paper-plane"></i>&nbsp;ارسل </button>
            </form>
         </div>
         </div>
      </div>
   </div>
</div>
<section class="background-black">
   <div class="container">
      <div class="portfolio">
         <nav class="grid-filter gf-outline gf-light" data-layout="#portfolio">
            <ul>
               <li class = "active"> <a href="#" data-category="*"> إظهار الكل </a> </li>
               @foreach ($categories as $category)
               <li> <a href="#" data-category=".c{{ $category->id }}">{{ $category->title_ar }}</a> </li>
               @endforeach 
            </ul>
         </nav>
         <div id="portfolio" class="grid-layout portfolio-4-columns" data-margin="10">
            @foreach ($categories as $category) 
            @foreach ($category->workes as $item)
            <div class="portfolio-item img-zoom c{{ $category->id }}">  
                <div class="portfolio-item-wrap">
                    <div class="portfolio-image">
                       <a href="{{ route('view.work',$item->id )}}"><img src="{{ asset('storage/works/' . ($item->image ?? '')) }}" alt=""></a>
                    </div>
                    <div class="portfolio-description">
                        @if ($item->v_link)
                        <a title="Paper Pouch!" data-lightbox="iframe" href="{{$item->v_link}}"><i class="fa fa-play"></i></a>
                        @endif 
                        <a href="{{ route('view.work',$item->id )}}">
                          <h3>@if (LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $item->title_ar }}@else{{ $item->title }}
                            @endif
                          </h3> 
                       </a>
                    </div>
                 </div> 
            </div>
            @endforeach 
            @endforeach 
             
         </div>
      </div>
   </div>
</section>
     
@endsection

@section('js')
     
@endsection

