@extends('front.layout.app')

@section('title')
     اتصل بنا
@stop
 

@section('content')
  
     
<section id="page-title" data-bg-parallax="{{ asset('front/images/parallax/5.jpg') }}">
    <div class="container">
    <div class="page-title">
        <h1> اتصل بنا </h1> 
            </div>
            <div class = "breadcrumb">
            <ul>
            <li> <a href="{{ route('view.home') }}"> الصفحة الرئيسية </a> </li> 
            <li class = "active"> <a href="#"> اتصل بنا </a> </li>
    </ul>
    </div>
    </div>
    </section>
    
    
    <section>
    <div class="container">
    <div class="row">
    <div class="col-lg-6">
    <h3 class="text-uppercase">ابقى على تواصل</h3>
     <p class="mb-3"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $setting->bio_ar }}@else{{ $setting->bio }}
    @endif  </p> 
    <div class="m-t-30"> <div id="success_message_subscriber"></div>
    <form class="widget-contact-form" name="subscriber" id="subscriber" enctype="multipart/form-data" method="post" action="">
    @csrf
    <div class="row">
    <div class="form-group col-md-6">
    <label for="name">الاسم</label>
    <input type="text" aria-required="true" id="contactName" name="name" required class="form-control required name" placeholder="ادخل اسمك">
    <small id="name_qerror" class="form-text text-danger"></small>

    </div>
    <div class="form-group col-md-6">
    <label for="email">االبريد الالكتروني</label>
    <input type="email" id="contactEmail" aria-required="true" name="email" required class="form-control required email" placeholder="ادخل بريدك الالكتروني">
    <small id="email_qerror" class="form-text text-danger"></small>

    </div>
    </div> 
    <div class="form-group">
    <label for="message">الرسالة</label>
    <textarea type="text" name="message" id="contactMassage" required rows="5" class="form-control required" placeholder="ادخل رساتك"></textarea>
    <small id="message_qerror" class="form-text text-danger"></small> 
    </div>
    
    <button class="btn" id="form-submit"  type="submit"><i class="fa fa-paper-plane"></i>&nbsp;ارسل رسالة</button>
    </form>
    
    </div>
    </div>
    <div class="col-lg-6">
    <h3 class="text-uppercase">بيانات التواصل </h3>
     <address>
    <strong>   @if (LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $setting->title_ar }}@else{{ $setting->title }}
    @endif </strong> 
       <br>
     </address>
        <div class="widget  widget-contact-us">
            <h4>تواصل معنا</h4>
            <ul class="list-icon">
                <li><i class="fa fa-map-marker-alt"></i>@if (LaravelLocalization::getCurrentLocale() == 'ar')
                    {{ $setting->address_ar }}@else{{ $setting->address }}
                @endif</li>
                <li><i class="fa fa-phone"></i><a href="tel:{{ $setting->phone }}"> {{ $setting->phone }}</a></li>
                <li><i class="far fa-envelope"></i> <a href="mailto:{{ $setting->email }}"> {{ $setting->email }}</a> </li>

            </ul>
        </div>
        <div class="social-icons m-t-30 social-icons-colored">
            <ul>
                @if ($setting->facebook)
                                <li class="social-facebook"><a href="{{ $setting->facebook }}"><i class="fab fa-facebook-f"></i></a></li>
                                @endif
                                @if ($setting->twitter)
                                <li class="social-twitter"><a href="{{ $setting->twitter }}"><i class="fab fa-twitter"></i></a></li>
                                @endif
                                @if ($setting->youtube)
                                <li class="social-youtube"><a href="{{ $setting->youtube }}"><i class="fab fa-youtube"></i></a></li>
                                @endif
                                @if ($setting->instagram)
                                <li class="social-instagram"><a href="{{ $setting->instagram }}"><i class="fab fa-instagram"></i></a></li>
                                @endif
                                @if ($setting->whatsapp)
                                <li class="social-whatsapp"><a href="{{ $setting->whatsapp }}"><i class="fab fa-whatsapp"></i></a></li>

                                @endif
            </ul>
        </div>
    </div>
    </div>
    </div>
    </section>
    
     
@endsection

@section('js')
<script>
    $('#form-submit').on('click' , function (e) {
                
               // $(document).find('#errsu').remove();
                e.preventDefault(); 
                 $("#name_qerror").text("");
                $("#email_qerror").text("");
                $("#message_qerror").text("");
                $.ajax({
                    type: "post",
                    url: "{{ route('view.contact') }}",
                    data: $("#subscriber").serialize(),
                    dataType: 'json',              // let's set the expected response format
                    success: function (data) {
                        //console.log(data);
                        $('#success_message_subscriber').fadeIn().html('<div class="text-success border-0">' + data.message +'</div>');
                        // document.body.scrollTop = document.documentElement.scrollTop = 0;
                        $('#form-submit').prop('disabled', true); 
    
                    },
                    error: function (reject) {
                var response = $.parseJSON(reject.responseText);
                $.each(response.errors, function (key, val) {
                    $("#" + key + "_qerror").text(val[0]);
                });
            },
                });
    
            });
    </script>
@endsection

