@extends('front.layout.app')

@section('title')
        
@stop
 

@section('content')
<section id="page-title" data-bg-parallax="images/parallax/14.jpg">
   <div class="bg-overlay"></div>
   <div class="container">
      <div class="page-title">
         <h1 class="text-uppercase text-medium"> @if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $menu['ar']['view.blogs'] }}@else{{ $menu['en']['view.blogs'] }}
        @endif   </h1>
        </div>
            <div class="breadcrumb mt-5">
                <ul>
                    <li> <a href="{{ route('view.home') }}"> الصفحة الرئيسية </a> </li> 
                    <li class="active"> <a >  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                        {{ $menu['ar']['view.blogs'] }}@else{{ $menu['en']['view.blogs'] }}
                    @endif   </a> </li>
                </ul>
            </div>
      </div>
   </div>
</section>
<section id="page-content">
   <div class="container">
      <div id="blog" class="grid-layout post-3-columns m-b-30" data-item="post-item">
         @foreach ($blogs as $blog)
         <div class="post-item border">
            <div class="post-item-wrap">
               <div class="post-image">
                  <a href="{{ route('view.blog',$blog->id) }}">
                  <img alt="" src="{{ asset('storage/works/'.$blog->main_image) }}">
                  </a> 
               </div>
               <div class = "post-item-description">
                  <span class = "post-meta-date"> <i class = "fa fa-calendar-o"> </i>{{$blog->created_at->format('y-M-d')}}</span>
                   <h2> <a href="{{ route('view.blog',$blog->id) }}">@if (LaravelLocalization::getCurrentLocale() == 'ar')
                     {{  $blog->title_ar }}@else{{$blog->title}}
                 @endif</a> </h2>
                  <p style="color:black">@if (LaravelLocalization::getCurrentLocale() == 'ar')
                     {{  $blog->sub_title_ar }}@else{{$blog->sub_title}}
                     @endif   </p>
                  <a href="{{ route('view.blog',$blog->id) }}" class="item-link">قراءة المزيد <i class="icon-chevron-right"></i></a>
               </div>
            </div>
         </div>   
         @endforeach
         
      </div>
      {{-- <div id = "showMore">
         <a href="#" class="btn btn-rounded btn-light"> <i class = "icon-Refresh-cw"> </i> تحميل المزيد من المشاركات </a>
      </div> --}}
   </div>
</section>
    
     
@endsection

@section('js')
    
@endsection

