@extends('front.layout.app')

@section('title')
        
@stop
 

@section('content')
<section id="page-title" class="page-title-center text-light" style="background-image:url({{ asset('storage/works/'.$blog->main_image) }});">
   <div class="bg-overlay"></div>
   <div class="container">
      <div class="page-title">
         <span class = "post-meta-category"> <a href="">  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                                                               {{  $blog->title_ar }}@else{{$blog->title}}
                                                         @endif </a> </span> 
          <h1>  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                     {{  $blog->sub_title_ar }}@else{{$blog->sub_title}}
               @endif</h1>
         <div class = "small m-b-20">{{$blog->created_at->format('y-M-d')}}|  </div>
         <div class="align-center">
            <a class="btn btn-xs btn-slide btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u={{ url('/') }}/blog/{{$blog->id}}&display=popup" target="_blank" >
            <i class="fab fa-facebook-f"></i>
            <span>Facebook</span>
            </a>
            <a class="btn btn-xs btn-slide btn-twitter" href="https://twitter.com/intent/tweet?url={{ url('/') }}/blog/{{$blog->id}}" target="_blank" data-width="100">
            <i class="fab fa-twitter"></i>
            <span>Twitter</span>
            </a>
            
         </div>
      </div>
   </div>
</section>
<section id="page-content" class="sidebar-right ">
   <div class="container">
      <div id="blog" class="single-post col-lg-10 center">
         <div class="post-item">
            <div class="post-item-wrap background-black p-10">
               <div class="post-item-description " >
                  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                  {!!  $blog->description_ar !!}@else{!! $blog->description !!} 
                     @endif
               </div>
               @if(count($blog->images) != 0 )
               <div class="col-lg-12">  
                           <h4 class="card-title">{{ __('صور اضافية') }}</h4>  
                              <div class="row">
                                 @forelse($blog->images as $value)
                                    <div class="col-md-4 col-xl-3" id="{{ $value->image }}"> 
                                             <img class="card-img" style="height: 150px;"
                                                src="{{ asset('storage/works/' . $value->image) }}" alt="Card image"> 
                                    </div>
                                 @empty
                                 @endforelse 
                           </div> 
                     </div>
               </div>
               @endif
               <div class="post-tags p-10">
                  @if (LaravelLocalization::getCurrentLocale() == 'ar')
                  @if ($blog->tag_ar)
                  @foreach ( $blog->tag_ar as $tag)
                  <a href="#"> {{ $tag }} </a> 
                  @endforeach
                  @endif
                  
                  @else 
                  @if ($blog->tag)
                  @foreach ( $blog->tag as $tag)
                  <a href="#"> {{ $tag }} </a> 
                  @endforeach
                  @endif
                  
                  @endif 
               </div> 
            </div>
         </div>
      </div>
   </div>
</section>
    
     
@endsection

@section('js')
    
@endsection

