@if (Session::has('success') || $errors->any() || Session::has('error'))
    <!-- Sweet Alerts js -->
    <script src="{{ asset('assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ asset('assets/js/pages/sweetalerts.init.js') }}"></script>
    <!-- Sweet Alert css-->
    <link href="{{ asset('assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    @if (Session::has('success'))
    <script>
        document.addEventListener("DOMContentLoaded",function(){
            var t;
            Swal.fire({
                title: "{{ Session::get('success') }}",
                icon: "success",
                timer: 5e3,
                timerProgressBar: !0,
                cancelButtonClass: "btn btn-danger w-xs mt-2",
                showCloseButton: !0,
                didOpen: function() {
                    t = setInterval(function() {
                        var t = Swal.getHtmlContainer();
                        t && (t = t.querySelector("b")) && (t.textContent = Swal.getTimerLeft())
                    }, 100)
                },
                onClose: function() {
                    clearInterval(t)
                }
            }).then(function(t) {
                t.dismiss === Swal.DismissReason.timer && console.log("I was closed by the timer")
            })
        });
    </script>
    @endif

    @if ($errors->any())
        <script>
            document.addEventListener("DOMContentLoaded",function(){
                Swal.fire({
                    title: "Error",
                    html: '<div class="alert alert-danger p-2"> <ul style="margin-top: 1rem !important; text-align: right; font-size: 15px;"> @foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach </ul> </div>',
                    showCloseButton: !0,
                })
            })
        </script>
    @endif

    @if (Session::has('error'))
        <script>
            document.addEventListener("DOMContentLoaded",function(){
                Swal.fire({
                    title: "Error",
                    icon: "error",
                    html: '<span style="color: red;">{{ Session::get('error') }}</span>',
                    showCloseButton: !0,
                })
            })
        </script>
    @endif

@endif
