@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __('Edit Work') }}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Work') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('All Works') }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
@stop

@section('css')
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }
    </style>
@stop

@section('content')

    <div class="row">

        <div class="card ">
        <div class="col-lg-8 m-5"> 
                
                <form action="{{ route('c-panel.works.update', $item->id ) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                        <label for="image">{{ __('Image') }}</label>
                        <div class="mb-3">
                            <div class="position-relative d-inline-block" style="width: 40%">
                                <input type='file'
                                    onchange="loadFile_image{{ $item->id }}(image{{ $item->id }})"
                                    name="image" id="image{{ $item->id }}"
                                    class="@error('image{{ $item->id }}') is-invalid @enderror"
                                    style="display:none;" />
                                <button id="output_image{{ $item->id }}" type="button" class="bg-light"
                                    onclick="document.getElementById('image{{ $item->id }}').click();"
                                    value="emad"
                                    style="
                                        width: 100%;
                                        height: 150px;
                                        border-radius: 2px;
                                        background-repeat: no-repeat;
                                        background-image: url({{ asset('storage/works/' . ($item->image ?? '')) }});
                                        background-size: cover;
                                        background-position: center;
                                        border:none;
                                        "></button>
                                <div class="position-absolute top-100 start-100 translate-middle">
                                    <label for="product-image-input"
                                        onclick="document.getElementById('image{{ $item->id }}').click();"
                                        class="mb-0" title="Select Image">
                                        <div class="avatar-xs">
                                            <div
                                                class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                <i class="ri-image-fill"></i>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                            <script>
                                var loadFile_image{{ $item->id }} = function(image{{ $item->id }}) {
                                    var image{{ $item->id }} = document.getElementById('output_image{{ $item->id }}');
                                    var src = URL.createObjectURL(event.target.files[0]);
                                    image{{ $item->id }}.style.backgroundImage = 'url(' + src + ')';
                                };
                            </script>
                        </div>
                        <div class="mb-3">
                            <label for="image" class="form-label">{{ __('اختر صور العمل') }}</label>
                            <input type="file" id="image" name="work_images[]" class="form-control" multiple >  
                         </div>
                         <div class="row"> 
                            @foreach($item->work_images as $a)
                               <div class="col-4 mb-3 R_album{{$a->id}} ">
                                          <img src="{{asset('storage/works/'.$a->image)}}"  alt="{{$a->name}}" width="100" >  
                                        <span class="form-text "> <a href="#" class="deletem_b" deletem_b="{{$a->id}} "> ازالة الصورة </a></span> 
                                        
                               </div>
                             @endforeach
                          </div>
                        <div class="mb-3">
                            <label for="title" class="form-label">{{ __('English Title') }}</label>
                            <input type="text" id="title" name="title" class="form-control" value="{{ old('title', $item->title) }}" placeholder="{{ __('English Title') }}"  />
                        </div>
                        <div class="mb-3">
                            <label for="title_ar" class="form-label">{{ __('Arabic Title') }}</label>
                            <input type="text" id="title_ar" name="title_ar" class="form-control" value="{{ old('title_ar', $item->title_ar) }}" placeholder="{{ __('Arabic Title') }}"  />
                        </div>
                        <div class="mb-3">
                            <label for="group_id" class="form-label">{{ __('الفئة') }}</label>
                            <select name="category_id" class="form-control" id="category_id">
                                <option value="">  الفئة</option>
                                @foreach (App\Models\Category::get() as $category)
                                    <option @if(old('category_id', $item->category_id) == $category->id) selected @endif value="{{ $category->id }}">
                                        @if(LaravelLocalization::getCurrentLocale() == 'ar')
                                            {{ $category->title_ar }} @else {{ $category->title }}
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                        </div>  
                        <div class="mb-3 ">
                            <label for="description" class="form-label">{{ __('English Description') }}</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $item->description ?? '') }}</textarea>
                        </div> 
                        <div class="mb-3 ">
                            <label for="description_ar" class="form-label">{{ __('Arabic Description') }}</label>
                            <textarea class="form-control" id="description_ar" name="description_ar" rows="3">{{ old('description_ar', $item->description_ar ?? '') }}</textarea>
                        </div>
                        <div class="mb-3">
                            <label for="date" class="form-label">{{ __('التاريخ') }}</label>
                            <input type="date" id="date" name="date" class="form-control" value="{{ old('date', $item->date) }}"   />
                        </div>
                        <div class="mb-3">
                            <label for="client" class="form-label">{{ __(' العميل') }}</label>
                            <input type="text" id="client" name="client" class="form-control" value="{{ old('client', $item->client) }}"  />
                        </div>
                        <div class="mb-3">
                            <label for="link" class="form-label">{{ __('Link') }}</label>
                            <input type="url" id="link" name="link" class="form-control" value="{{ old('link', $item->link) }}" placeholder="{{ __('Link') }}" />
                        </div>
                        <div class="mb-3">
                            <label for="b_link" class="form-label">{{ __('Video Link') }}</label>
                            <input type="url" id="v_link" name="v_link" class="form-control" value="{{ old('v_link', $item->v_link) }}" placeholder="{{ __('video Link') }}" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                             <button type="submit" class="btn btn-success" id="add-btn">{{ __('Update') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!--end col-->
    </div>
 
@stop

@section('js')
<script src="https://code.jquery.com/jquery-3.5.0.min.js" integrity="sha256-xNzN2a4ltkB44Mc/Jz3pT4iU1cmeR0FkXs4pru/JxaQ=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 
    <!-- App js -->

 
<script>
    $('.deletem_b').on("click", function (e) {
     e.preventDefault();
        
    var id = $(this).attr('deletem_b');
    
    
    $.ajax({
         type: "post",
         url: "{{ route('c-panel.delete_work_photo') }}",
         data: { _token: '{{ csrf_token() }}',
              "id" : id },
             dataType: 'json',  // let's set the expected response format
             success: function (data) {
                 $(".R_album"+ data.id).remove();
                
             },
             error: function (err) {
                 if (err.status == 422) { // when status code is 422, it's a validation issue
                     console.log(err.responseJSON);
                     $('#success_message_notifications').fadeIn().html('<div class="alert alert-danger border-0 alert-dismissible">' + err.responseJSON.message +'</div>');
    
    
                 }
             }
         });   
    
    });
    </script>
@stop