@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __('User') }}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Users') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('All Users') }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
@stop

@section('css')
@stop

@section('content')

    <form action="{{ route('c-panel.users.index') }}" method="GET">
        <div class="card">
            <div class="card-header border-0 rounded">
                <div class="row g-2">

                    <div class="col-xl-3">
                        <div class="search-box">
                            <input type="text" name="search" class="form-control search"
                                placeholder="{{ __('Search for User') }}"> <i class="ri-search-line search-icon"></i>
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-xl-2 ms-auto">
                        <div>
                            <select class="form-control" name="role_id" data-choices data-choices-search-false>
                                <option value="">{{ __('Select Role') }}</option>
                                @foreach (App\Models\Role::get() as $role)
                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-lg-auto">
                        <div class="hstack gap-2">
                            <button type="submit" class="btn btn-danger"><i
                                    class="ri-equalizer-fill me-1 align-bottom"></i>
                                {{ __('Filters') }}</button>
                            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addUser"><i
                                    class="ri-add-fill me-1 align-bottom"></i> {{ __('Add User') }}</button>
                        </div>
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->
            </div>
        </div>
    </form>

    <div class="row mt-4">
        @foreach ($users as $user)
            <div class="col-xl-3 col-lg-6">
                <div class="card ribbon-box right overflow-hidden">
                    <div class="card-body text-center p-4">
                        <h5 class="mb-1 mt-4"><a href="javascript:;" data-bs-toggle="modal"
                                data-bs-target="#editSeller{{ $user->id }}"
                                class="link-primary">{{ $user->name }}</a></h5>
                        <p class="text-muted mb-4">{{ $user->role->name ?? '' }}</p>


                        <div class="mt-4 d-flex">
                            @if(!($user->id == 1) || auth()->id() == 1)
                                <a href="javascript:;" class="btn btn-primary m-1" data-bs-toggle="modal" data-bs-target="#editSeller{{ $user->id }}"><i class="ri-edit-box-line"></i></a>
                                @if(!(auth()->id() == $user->id))
                                    <a href="javascript:;" class="btn btn-danger m-1" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $user->id }}"><i class="ri-delete-bin-6-line"></i></a>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        @endforeach
    </div>
    <!--end row-->

    <div class="row g-0 text-center text-sm-start align-items-center mb-3">
        <!-- end col -->
        <div class="col-sm-12">
            {{ $users->links('vendor.pagination.semantic-ui') }}
        </div><!-- end col -->
    </div><!-- end row -->

    <!-- Modal -->
    <div class="modal fade zoomIn" id="addUser" tabindex="-1" aria-labelledby="addUserLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addUserLabel">{{ __('Add User') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('c-panel.users.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">

                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">{{ __('Name') }}</label>
                                    <input type="text" class="form-control" id="name" name="name"
                                        value="{{ old('name') }}" placeholder="{{ __('Enter user name') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="role_id" class="form-label">{{ __('Role') }}</label>
                                    <select class="form-control" name="role_id" id="role_id">
                                        @foreach (App\Models\Role::get() as $role)
                                            <option @if (old('role_id') == $role->id) selected @endif
                                                value="{{ $role->id }}">{{ $role->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">{{ __('Email') }}</label>
                                    <input type="email" class="form-control" id="email" name="email"
                                        value="{{ old('email') }}" placeholder="{{ __('Enter user email') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="{{ old('phone') }}" placeholder="{{ __('Enter phone number') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label">{{ __('Password') }}</label>
                                    <input type="password" class="form-control" id="password" name="password"
                                        value="{{ old('password') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password_confirmation"
                                        class="form-label">{{ __('Confirm Password') }}</label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        name="password_confirmation" value="{{ old('password_confirmation') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                        data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                        {{ __('Close') }}</button>
                                    <button type="submit" class="btn btn-primary"><i
                                            class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                                </div>
                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end modal-->

    @foreach ($users as $user)
        @if(!($user->id == 1) || auth()->id() == 1)
            <!-- Modal -->
            <div class="modal fade zoomIn" id="editSeller{{ $user->id }}" tabindex="-1"
                aria-labelledby="addUserLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="addUserLabel">{{ __('Edit Customer') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form action="{{ route('c-panel.users.update', $user->id) }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    @if(auth()->id() != $user->id && $user->id != 1)
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="name" class="form-label">{{ __('Name') }}</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                value="{{ old('name', $user->name) }}"
                                                placeholder="{{ __('Enter user name') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="role_id" class="form-label">{{ __('Role') }}</label>
                                            <select class="form-control" name="role_id" id="role_id">
                                                @foreach (App\Models\Role::get() as $role)
                                                    <option @if (old('role_id', $user->role_id) == $role->id) selected @endif
                                                        value="{{ $role->id }}">{{ $role->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    @else
                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="name" class="form-label">{{ __('Name') }}</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                value="{{ old('name', $user->name) }}"
                                                placeholder="{{ __('Enter user name') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    @endif
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="email" class="form-label">{{ __('Email') }}</label>
                                            <input type="email" class="form-control" id="email" name="email"
                                                value="{{ old('email', $user->email) }}"
                                                placeholder="{{ __('Enter user email') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                                            <input type="text" class="form-control" id="phone" name="phone"
                                                value="{{ old('phone', $user->phone) }}"
                                                placeholder="{{ __('Enter phone number') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="password" class="form-label">{{ __('Password') }}</label>
                                            <input type="password" class="form-control" id="password" name="password"
                                                value="{{ old('password') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="password_confirmation"
                                                class="form-label">{{ __('Confirm Password') }}</label>
                                            <input type="password" class="form-control" id="password_confirmation"
                                                name="password_confirmation" value="{{ old('password_confirmation') }}">
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <div class="form-check form-switch form-switch-md">
                                                <input type="checkbox" class="form-check-input" value="1"
                                                    name="status" id="customSwitchsizemd"
                                                    @if (old('status', $user->status) == '1') checked @endif>
                                                <label for="status"
                                                    class="form-label">{{ __('Activation Status') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-12">
                                        <div class="hstack gap-2 justify-content-end">
                                            <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                                data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                                {{ __('Close') }}</button>
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!--end modal-->
            @if(!(auth()->id() == $user->id))
                <!-- Delete Modal -->
                <div class="modal fade zoomIn" id="delete-item-{{ $user->id }}" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                                    id="btn-close"></button>
                            </div>
                            <div class="modal-body">
                                <form action=" {{ route('c-panel.users.destroy', $user->id) }}" method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <div class="mt-2 text-center">
                                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop"
                                            colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px">
                                        </lord-icon>
                                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                            <h4>{{ __('Are you Sure ?') }}</h4>
                                            <p class="text-muted mx-4 mb-0">
                                                {{ __('Are you Sure You want to Remove this Record ?') }}</p>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                        <button type="button" class="btn w-sm btn-light"
                                            data-bs-dismiss="modal">{{ __('Close') }}</button>
                                        <button type="submit" class="btn w-sm btn-danger "
                                            id="delete-record">{{ __('Yes, Delete It!') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end delete modal -->
            @endif
        @endif
    @endforeach

@stop
