@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __('Team Members') }}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Team Members') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('All Team Members') }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
@stop

@section('css')
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }

        @media (min-width: 576px){
            .service-modal {
                max-width: 800px;
            }
        }
    </style>
@stop

@section('content')

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex align-items-center ">
                    <h5 class="card-title mb-0 flex-grow-1">{{ __('Team Members') }}</h5>
                    <div>
                        <a href="javascript:;" class="btn btn-primary m-2" data-bs-toggle="modal" data-bs-target="#create_new">{{ __('Add New +') }}</a>
                        <button href="javascript:;" id="bulk-delete" class="btn btn-danger m-2" data-bs-toggle="modal" data-bs-target="#bulk-delete-items" disabled>{{ __('Delete Selected') }}</button>
                    </div>
                </div>
                <div class="card-body">
                    <table id="teams-list-table" class="table nowrap align-middle dt-responsive" style="width:100%">
                        <thead>
                            <tr>
                                <th scope="col" style="width: 10px;">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" id="record__select-all">
                                    </div>
                                </th>
                                <th>{{ __('#') }}</th>
                                <th>{{ __('Image') }}</th>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Position') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!--end col-->
    </div>
    <!--end row-->

    <div class="modal fade" id="create_new" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered service-modal">
            <div class="modal-content">
                <div class="modal-header bg-light p-3">
                    <h5 class="modal-title ms-3" id="exampleModalLabel">{{ __('Create New') }}</h5>
                    <button type="button" class="btn-close me-3" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
                </div>
                <form action="{{ route('c-panel.teams.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="image">{{ __('Image') }}</label>
                                    <div class="mb-3">
                                        <div class="position-relative d-inline-block" style="width: 30%">
                                            <input type='file' onchange="loadFile_image(image)" name="image" id="image"
                                                class="@error('image') is-invalid @enderror" style="display:none;" />
                                            <button id="output_image" type="button" class="bg-light"
                                                onclick="document.getElementById('image').click();" value="emad"
                                                style="
                                                        width: 100%;
                                                        height: 150px;
                                                        border-radius: 2px;
                                                        background-repeat: no-repeat;
                                                        background-size: cover;
                                                        background-position: center;
                                                        border:none;
                                                        "></button>
                                            <div class="position-absolute top-100 start-100 translate-middle">
                                                <label for="product-image-input"
                                                    onclick="document.getElementById('image').click();" class="mb-0"
                                                    title="Select Image">
                                                    <div class="avatar-xs">
                                                        <div
                                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                            <i class="ri-image-fill"></i>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <script>
                                            var loadFile_image = function(image) {
                                                var image = document.getElementById('output_image');
                                                var src = URL.createObjectURL(event.target.files[0]);
                                                image.style.backgroundImage = 'url(' + src + ')';
                                            };
                                        </script>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">{{ __('English Name') }}</label>
                                        <input type="text" id="name" name="name" class="form-control" value="{{ old('name') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="name_ar" class="form-label">{{ __('Arabic Name') }}</label>
                                        <input type="text" id="name_ar" name="name_ar" class="form-control" value="{{ old('name_ar') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="position" class="form-label">{{ __('English Position') }}</label>
                                        <input type="text" id="position" name="position" class="form-control" value="{{ old('position') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="position_ar" class="form-label">{{ __('Arabic Position') }}</label>
                                        <input type="text" id="position_ar" name="position_ar" class="form-control" value="{{ old('position_ar') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description" class="form-label">{{ __('English Description') }}</label>
                                        <textarea id="description" rows="5" name="description" class="form-control">{{ old('description') }} </textarea>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description_ar" class="form-label">{{ __('Arabic Description') }}</label>
                                        <textarea id="description_ar" rows="5" name="description_ar" class="form-control">{{ old('description_ar') }} </textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button type="submit" class="btn btn-success me-4" id="add-btn">{{ __('Add') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Delete Modal -->
    <div class="modal fade zoomIn" id="bulk-delete-items" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" action="{{ route('c-panel.teams.bulk-delete') }}">
                        @csrf
                        @method('delete')
                        <input type="hidden" name="record_ids" id="record-ids" value="[]">
                        <div class="mt-2 text-center">
                            <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                            <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                <h4>{{ __('Are you Sure ?') }}</h4>
                                <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Remove Selected Records ?') }}</p>
                            </div>
                        </div>
                        <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                            <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button type="submit" class="btn w-sm btn-danger " id="delete-record">{{ __('Yes, Delete It!') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end delete modal -->


@stop

@section('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script>

        $(document).ready(function() {
            $("#teams-list-table").DataTable({
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: '{{ route('c-panel.teams.index') }}'
                },
                columns: [
                    // columns according to JSON
                    {data: 'record_select', orderable: false},
                    {data: 'id', orderable: false},
                    {data: 'image', orderable: false},
                    {data: 'name', orderable: false},
                    {data: 'position', orderable: false},
                    {data: 'actions', orderable: false}
                ],
                order: [1],
                language: {
                    sLengthMenu: '{{ __('Show _MENU_') }}',
                    search: '{{ __('Search :') }}',
                    zeroRecords: '{{ __('No matching records found') }}',
                    info: "{{ __('Showing _PAGE_ to _PAGES_') }}",
                    infoEmpty: '{{ __('Show 0 pages') }}',
                    searchPlaceholder: '{{__('Search')}}..',
                    paginate: {
                        // remove previous & next text from pagination\
                        previous: '{{ __('Previous') }}',
                        next: '{{ __('Next') }}'
                    }
                },
            })
        });
    </script>



    <!-- App js -->

@stop
