@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __(' خطط الباقة')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{  __(' خطط الباقة') }}</a></li>
                        <li class="breadcrumb-item active">{{  __('الباقات') }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
@stop

@section('css')
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }

        @media (min-width: 576px){
            .service-modal {
                max-width: 930px;
            }
        }
    </style>
@stop

@section('content')

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex align-items-center ">
                    <h5 class="card-title mb-0 flex-grow-1">{{ __(' خطط') }} {{ $package->title_ar }} </h5>
                    <div>
                        <a href="javascript:;" class="btn btn-primary m-2" data-bs-toggle="modal" data-bs-target="#create_new">{{ __('Add New +') }}</a>
                     </div>
                </div>
                <div class="card-body">
                    <table id=" " class="table nowrap align-middle dt-responsive" style="width:100%">
                        <thead>
                            <tr> 
                                <th>{{ __('#') }}</th> 
                                <th>{{ __('Title') }}</th>
                                <th>{{ __('Price') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($package->plans as $item)
                            <tr>
                               <td> {{$loop->iteration}}</td>
                                <td>
                                     <span class="font-weight-bold">{{$item->title_ar}}</span>
                                </td> 
                                <td>
                                    {{$item->price}}
                                </td> 
                                <td>  
                                    <div class="dropdown d-inline-block">
                                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="ri-more-fill align-middle"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu">
                                            {{-- <li>
                                                <a href="#!" class="dropdown-item">
                                                    {{ __('View') }} <i class="ri-eye-fill align-bottom me-2 text-muted"></i>
                                                </a>
                                            </li> --}}
                                            {{-- @can('update', $item) --}}
                                            <li>
                                                <a class="dropdown-item edit-item-btn" href="{{ route('c-panel.package.plans.edit', $item->id ) }}"  >
                                                    <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> {{ __('Edit') }}
                                                </a>
                                            </li>
                                            {{-- @endcan
                                            @can('delete', $item) --}}
                                            <li>
                                                <a class="dropdown-item remove-item-btn" href="" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $item->id }}">
                                                    <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> {{ __('Delete') }}
                                                </a>
                                            </li>
                                            {{-- @endcan --}}
                                        </ul>
                                    </div>
                                    
                                    
                                    {{-- @can('delete', $item) --}}
                                    <!-- Delete Modal -->
                                    <div class="modal fade zoomIn" id="delete-item-{{ $item->id }}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action=" {{ route('c-panel.package.plans.destroy',$item->id) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <div class="mt-2 text-center">
                                                            <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                                                            <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                                                <h4>{{ __('Are you Sure ?') }}</h4>
                                                                <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Remove this Record ?') }}</p>
                                                            </div>
                                                        </div>
                                                        <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                                            <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                                                            <button type="submit" class="btn w-sm btn-danger " id="delete-record">{{ __('Yes, Delete It!') }}</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end delete modal -->
                                    {{-- @endcan --}}
                                     
                                    
                         
                                </td>
                            </tr>
                             @endforeach
                        </tbody> 
                    </table>
                </div>
            </div>
        </div>
        <!--end col-->
    </div>
    <!--end row-->

    <div class="modal fade" id="create_new" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered service-modal">
            <div class="modal-content">
                <div class="modal-header bg-light p-3">
                    <h5 class="modal-title ms-3" id="exampleModalLabel">{{ __('Create New') }}</h5>
                    <button type="button" class="btn-close me-3" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
                </div>
                <form action="{{ route('c-panel.package.plans.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden"  name="package_id" value="{{ $package->id }}" />

                    <div class="modal-body">
                        <div class="container">
                            <div class="row"> 
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">{{ __('العنوان بالعربي') }}</label>
                                        <input type="text" id="title" name="title" class="form-control" value="{{ old('title') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title_ar" class="form-label">{{ __('العنوان بالانجليزي') }}</label>
                                        <input type="text" id="title_ar" name="title_ar" class="form-control" value="{{ old('title_ar') }}" required />
                                    </div>
                                </div> 
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title" class="form-label">{{ __('العنوان الفرعي بالعربي') }}</label>
                                        <input type="text" id="sub_title" name="sub_title" class="form-control" value="{{ old('sub_title') }}" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان الفرعي بالانجليزي') }}</label>
                                        <input type="text" id="sub_title_ar" name="sub_title_ar" class="form-control" value="{{ old('sub_title_ar') }}" />
                                    </div>
                                </div> 
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="price" class="form-label">{{ __('السعر') }}</label>
                                        <input type="text" id="price" name="price" class="form-control" value="{{ old('price') }}" required />
                                    </div>
                                </div> 
                                <table class="invoice-table table table-borderless table-nowrap mb-0">
                                    <thead class="align-middle">
                                        <tr class="table-active">
                                            <th scope="col" style="width: 50px;">#</th>
                                            <th scope="col">{{ __('Features') }}</th>
                                            <th scope="col" style="width: 120px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="newlink">
                                        @if(old('features') && count(old('features')) != 0)
                                            @foreach(old('features') as $key => $item)
                                                <tr id="{{ $key+1 }}" class="product">
                                                    <th scope="row" class="product-id">{{ $key+1 }}</th>
                                                    <td class="text-start">
                                                        <div class="mb-2">
                                                            <input type="text" class="form-control bg-light border-0" id="feature-{{ $key+1 }}" value="{{ old('features')[$key] }}" name="features[]" required />
                                                        </div>
                                                    </td>
                                                    <td class="product-removal">
                                                        <a href="javascript:void(0)" class="btn btn-success">{{ __('Delete') }}</a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr id="1" class="product">
                                                <th scope="row" class="product-id">1</th>
                                                <td class="text-start">
                                                    <div class="mb-2">
                                                        <input type="text" class="form-control bg-light border-0" id="feature-1" name="features[]" required />
                                                    </div>
                                                </td>
                                                <td class="product-removal">
                                                    <a href="javascript:void(0)" class="btn btn-success">{{ __('Delete') }}</a>
                                                </td>
                                            </tr>
                                        @endif
                                    </tbody>
                                    <tbody>
                                        <tr id="newForm" style="display: none;"><td class="d-none" colspan="5"><p>{{ __('Add New Form') }}</p></td></tr>
                                        <tr>
                                            <td colspan="8">
                                                <a href="javascript:new_link()" id="add-item" class="btn btn-soft-secondary fw-medium"><i class="ri-add-fill me-1 align-bottom"></i> {{ __('Add Item') }}</a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button type="submit" class="btn btn-success me-4" id="add-btn">{{ __('Add') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

 


@stop

@section('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

        <script src="{{ asset('assets/libs/cleave.js/cleave.min.js') }}"></script>

        <!--Invoice create init js-->
        <script>
            var count = 1;
            document.addEventListener("DOMContentLoaded", function(){
                @if(old('features') && count(old('features')) != 0)
                    @foreach(old('features') as $key => $item)
                        calc({{ $key+1 }});
                    @endforeach
                @endif
                remove();
                resetRow();
                showPrice();
            });
        
            @if(old('features') && count(old('features')) != 0)
                @foreach(old('features') as $key => $item)
                    @if($key != 0)
                        count++;
                    @endif
                @endforeach
            @endif
        
            function new_link() {
                count++;
                var e = document.createElement("tr"),
                    t = (e.id = count, e.className = "product", '<tr><th scope="row" class="product-id">' + count + '</th><td class="text-start"><div class="mb-2"><input class="form-control bg-light border-0" type="text" name="features[]" id="feature-' + count + '" ></div></td><td class="product-removal"><a class="btn btn-success">{{ __("Delete") }}</a></td></tr>'),
                    t = (e.innerHTML = document.getElementById("newForm").innerHTML + t, document.getElementById("newlink").appendChild(e), document.querySelectorAll("[data-trigger]"));
                Array.from(t).forEach(function(e) {
                    new Choices(e, {
                        placeholderValue: "This is a placeholder set in the config",
                        searchPlaceholderValue: "This is a search placeholder"
                    })
                }), remove(), resetRow()
            }
        
            function remove() {
                Array.from(document.querySelectorAll(".product-removal a")).forEach(function(e) {
                    e.addEventListener("click", function(e) {
                        count--;
                        removeItem(e), resetRow()
                    })
                })
            }
        
            function removeItem(e) {
                e.target.closest("tr").remove()
            }
        
            function resetRow() {
                Array.from(document.getElementById("newlink").querySelectorAll("tr")).forEach(function(e, t) {
                    t += 1;
                    e.querySelector(".product-id").innerHTML = t
                })
            }
</script>        

@stop
