@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __(' الباقات')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('الباقات') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('الباقات') }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
@stop

@section('css')
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }

        @media (min-width: 576px){
            .service-modal {
                max-width: 930px;
            }
        }
    </style>
@stop

@section('content')

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex align-items-center ">
                    <h5 class="card-title mb-0 flex-grow-1">{{ __(' الباقات') }}</h5>
                    <div>
                        <a href="javascript:;" class="btn btn-primary m-2" data-bs-toggle="modal" data-bs-target="#create_new">{{ __('Add New +') }}</a>
                     </div>
                </div>
                <div class="card-body">
                    <table id=" " class="table nowrap align-middle dt-responsive" style="width:100%">
                        <thead>
                            <tr> 
                                <th>{{ __('#') }}</th> 
                                <th>{{ __('English Title') }}</th>
                                <th>{{ __('Arabic Title') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($packages as $item)
                            <tr>
                               <td> {{$loop->iteration}}</td>
                                <td>
                                     <span class="font-weight-bold">{{$item->title}}</span>
                                </td> 
                                <td>
                                    {{$item->title_ar}}
                                </td> 
                                <td>  
                                    <div class="dropdown d-inline-block">
                                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="ri-more-fill align-middle"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu">
                                            {{-- <li>
                                                <a href="#!" class="dropdown-item">
                                                    {{ __('View') }} <i class="ri-eye-fill align-bottom me-2 text-muted"></i>
                                                </a>
                                            </li> --}}
                                            {{-- @can('update', $item) --}}
                                            <li>
                                                <a class="dropdown-item edit-item-btn" href="" data-bs-toggle="modal" data-bs-target="#edit-item-{{ $item->id }}">
                                                    <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> {{ __('Edit') }}
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item edit-item-btn" href="{{ route('c-panel.package_plans',$item->id) }}" >
                                                    <i class="ri-eye-fill align-bottom me-2 text-muted"></i> {{ __('خطط الباقة') }}
                                                </a>
                                            </li>
                                            {{-- @endcan
                                            @can('delete', $item) --}}
                                            <li>
                                                <a class="dropdown-item remove-item-btn" href="" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $item->id }}">
                                                    <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> {{ __('Delete') }}
                                                </a>
                                            </li>
                                            {{-- @endcan --}}
                                        </ul>
                                    </div>
                                    
                                    
                                    {{-- @can('delete', $item) --}}
                                    <!-- Delete Modal -->
                                    <div class="modal fade zoomIn" id="delete-item-{{ $item->id }}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action=" {{ route('c-panel.packages.destroy',$item->id) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <div class="mt-2 text-center">
                                                            <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                                                            <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                                                <h4>{{ __('Are you Sure ?') }}</h4>
                                                                <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Remove this Record ?') }}</p>
                                                            </div>
                                                        </div>
                                                        <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                                            <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                                                            <button type="submit" class="btn w-sm btn-danger " id="delete-record">{{ __('Yes, Delete It!') }}</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end delete modal -->
                                    {{-- @endcan --}}
                                    
                                    
                                    <div class="modal fade" id="edit-item-{{ $item->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered service-modal">
                                            <div class="modal-content">
                                                <div class="modal-header bg-light p-3">
                                                    <h5 class="modal-title ms-3" id="exampleModalLabel">{{ __('Update') }}</h5>
                                                    <button type="button" class="btn-close me-3" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
                                                </div>
                                                <form action="{{ route('c-panel.packages.update', $item->id) }}" method="POST" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="modal-body">
                                                        <div class="container">
                                                            <div class="row">
                                                                 
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label for="title" class="form-label">{{ __('English Category Title') }}</label>
                                                                        <input type="text" id="title" name="title" class="form-control" value="{{ old('title', $item->title) }}" required />
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label for="title_ar" class="form-label">{{ __('Arabic Category Title') }}</label>
                                                                        <input type="text" id="title_ar" name="title_ar" class="form-control" value="{{ old('title_ar', $item->title_ar) }}" required />
                                                                    </div>
                                                                </div> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <div class="hstack gap-2 justify-content-end">
                                                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                                                            <button type="submit" class="btn btn-success me-4" id="add-btn">{{ __('Add') }}</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    
                                      
                         
                                </td>
                            </tr>
                             @endforeach
                        </tbody> 
                    </table>
                </div>
            </div>
        </div>
        <!--end col-->
    </div>
    <!--end row-->

    <div class="modal fade" id="create_new" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered service-modal">
            <div class="modal-content">
                <div class="modal-header bg-light p-3">
                    <h5 class="modal-title ms-3" id="exampleModalLabel">{{ __('Create New') }}</h5>
                    <button type="button" class="btn-close me-3" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
                </div>
                <form action="{{ route('c-panel.packages.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="container">
                            <div class="row"> 
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">{{ __('English Category Title') }}</label>
                                        <input type="text" id="title" name="title" class="form-control" value="{{ old('title') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title_ar" class="form-label">{{ __('Arabic Category Title') }}</label>
                                        <input type="text" id="title_ar" name="title_ar" class="form-control" value="{{ old('title_ar') }}" required />
                                    </div>
                                </div> 
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button type="submit" class="btn btn-success me-4" id="add-btn">{{ __('Add') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

 


@stop

@section('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

     
    <!-- App js -->

@stop
