@extends('admin.layout.app')
@section('title')
{{ __('Menus') }}
@stop

@section('css')
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }
    </style>
@stop

@section('content')

    <div class="row" style="margin-top: 30px;">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex align-items-center ">
                    <h5 class="card-title mb-0 flex-grow-1">{{ __('Menus') }}</h5>
                </div>
                <div class="card-body">
                    <table id="menus-list-table" class="table nowrap align-middle dt-responsive" style="width:100%">
                        <thead>
                            <tr>
                                <th>{{ __('ID') }}</th>
                                <th>{{ __('English Name') }}</th>
                                <th>{{ __('Arabic Name') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!--end col-->
    </div>
    <!--end row-->

@stop

@section('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script>

        $(document).ready(function() {
            $("#menus-list-table").DataTable({
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: '{{ route('c-panel.menus.index') }}'
                },
                columns: [
                    // columns according to JSON
                    {data: 'id', orderable: false},
                    {data: 'name', orderable: false},
                    {data: 'name_ar', orderable: false},
                    {data: 'actions', orderable: false}
                ],
                order: [1],
                language: {
                    sLengthMenu: '{{ __('Show _MENU_') }}',
                    search: '{{ __('Search :') }}',
                    zeroRecords: '{{ __('No matching records found') }}',
                    info: "{{ __('Showing _PAGE_ to _PAGES_') }}",
                    infoEmpty: '{{ __('Show 0 pages') }}',
                    searchPlaceholder: '{{__('Search')}}..',
                    paginate: {
                        // remove previous & next text from pagination\
                        previous: '{{ __('Previous') }}',
                        next: '{{ __('Next') }}'
                    }
                },
            })
        });
    </script>



    <!-- App js -->

@stop
