@extends('admin.layout.app')

@section('title')
    {{ __('Blogs') }}
@stop

@section('css')

@stop

@section('content')

    <div class="row" style="margin-top: 30px;">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('c-panel.blogs.update', $blog->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-header">
                        <h5 class="card-title mb-0 flex-grow-1">{{ __('Update') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="name" class="form-label">{{ __('Main Image') }}</label>
                                    <div class="mb-3">
                                        <div class="position-relative d-inline-block">
                                            <input type='file' onchange="loadFile_main_image(main_image)"
                                                name="main_image" id="main_image"
                                                class="@error('main_image') is-invalid @enderror" style="display:none;" />
                                            <button id="output_main_image" type="button" class="bg-light"
                                                onclick="document.getElementById('main_image').click();" value="emad"
                                                style="
                                                        width: 100px;
                                                        height: 100px;
                                                        border-radius: 2px;
                                                        background-repeat: no-repeat;
                                                        background-image: url({{ asset('storage/works/' . ($blog->main_image ?? '')) }});
                                                        background-size: cover;
                                                        background-position: center;
                                                        border:none;
                                                        "></button>
                                            <div class="position-absolute top-100 start-100 translate-middle">
                                                <label for="product-image-input"
                                                    onclick="document.getElementById('main_image').click();" class="mb-0"
                                                    title="Select Image">
                                                    <div class="avatar-xs">
                                                        <div
                                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                            <i class="ri-image-fill"></i>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <script>
                                            var loadFile_main_image = function(main_image) {
                                                var main_image = document.getElementById('output_main_image');
                                                var src = URL.createObjectURL(event.target.files[0]);
                                                main_image.style.backgroundImage = 'url(' + src + ')';
                                            };
                                        </script>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">{{ __('English Title') }}</label>
                                        <input type="text" id="title" name="title" class="form-control"
                                            value="{{ old('title', $blog->title) }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title_ar" class="form-label">{{ __('Arabic Title') }}</label>
                                        <input type="text" id="title_ar" name="title_ar" class="form-control"
                                            value="{{ old('title_ar', $blog->title_ar) }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title" class="form-label">{{ __('English Sub Title') }}</label>
                                        <input type="text" id="sub_title" name="sub_title" class="form-control"
                                            value="{{ old('sub_title', $blog->sub_title) }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title_ar" class="form-label">{{ __('Arabic Sub Title') }}</label>
                                        <input type="text" id="sub_title_ar" name="sub_title_ar" class="form-control"
                                            value="{{ old('sub_title_ar', $blog->sub_title_ar) }}" required />
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description" class="form-label">{{ __('English Description') }}</label>
                                        <textarea id="description" rows="5" name="description" class="form-control">{{ old('description', $blog->description) }} </textarea>
                                        <script>
                                            CKEDITOR.replace('description', {
                                                                filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",
                                                                filebrowserUploadMethod: 'form'
                                                            });
                                        </script>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description_ar"
                                            class="form-label">{{ __('Arabic Description') }}</label>
                                        <textarea id="description_ar" rows="5" name="description_ar" class="form-control">{{ old('description_ar', $blog->description_ar) }} </textarea>
                                        <script>
                                            CKEDITOR.replace('description_ar', {
                                                                filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",
                                                                filebrowserUploadMethod: 'form'
                                                            });
                                        </script>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="tag" class="form-label">{{ __('English Tags') }}</label>
                                        <input type="text" class="form-control" id="tag" name="tag" @if(old('tag')) value="{{ old('tag') }}" @elseif($blog->tag) value="@foreach($blog->tag as $tag){{ $tag }}@if(!$loop->last){{ ',' }}@endif @endforeach" @endif>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="tag_ar" class="form-label">{{ __('Arabic Tags') }}</label>
                                        <input type="text" class="form-control" id="tag_ar" name="tag_ar" @if(old('tag_ar')) value="{{ old('tag_ar') }}" @elseif($blog->tag_ar) value="@foreach($blog->tag_ar as $tag){{ $tag }}@if(!$loop->last){{ ',' }}@endif @endforeach" @endif>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="gallery" class="form-label">{{ __('Other Images') }}</label>
                                        <input type="file" id="gallery" name="gallery[]" class="form-control"
                                            multiple>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="submit" class="btn btn-success me-4"
                                id="add-btn">{{ __('Add') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!--end col-->
        @if(count($blog->images) != 0 )
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ __('Uploaded Image') }}</h4>
                </div>
                <div class="card-body pt-3 pb-3">
                    <div class="row">
                        @forelse($blog->images as $value)
                            <div class="col-md-4 col-xl-3" id="{{ $value->image }}">
                                <div class="card border-0 text-white">
                                    <img class="card-img" style="height: 150px;"
                                        src="{{ asset('storage/works/' . $value->image) }}" alt="Card image">
                                    <div class="card-img-overlay">
                                        <a class="dz-remove deleteImage btn btn-primary" title="حذف الصورة"
                                            style=" border-color: #ee4747 !important; background-color: #d50404 !important;padding:3px 5px; margin-top: -43px; margin-right: -23px;"
                                            href="javascript:undefined;" img-name="{{ $value->image }}" data-blog="{{ $blog->id }}"
                                            data-dz-remove="">X</a>
                                    </div>
                                </div>
                            </div>
                        @empty
                        @endforelse

                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
    <!--end row-->



@stop

@section('js')

    <script>
        $('body').on('click', '.deleteImage', function() {

            var name = $(this).attr('img-name');
            var blog = $(this).attr('data-blog');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                },
                type: 'POST',
                url: "{{ route('c-panel.blogs.delete-images') }}",
                data: {
                    filename: name,
                    blog: blog,
                },
                success: function(data) {
                    document.getElementById(data.name).remove();
                    console.log("File has been successfully removed!!");
                },
                error: function(e) {
                    console.log(e);
                }
            });

        })
    </script>
@stop
