@extends('admin.layout.app')

@section('title')
{{ __('Blogs') }}
@stop

@section('css')

@stop

@section('content')

    <div class="row" style="margin-top: 30px;">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('c-panel.blogs.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-header">
                        <h5 class="card-title mb-0 flex-grow-1">{{ __('Create Blogs') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="name" class="form-label">{{ __('Main Image') }}</label>
                                    <div class="mb-3">
                                        <div class="position-relative d-inline-block">
                                            <input type='file' onchange="loadFile_main_image(main_image)" name="main_image" id="main_image"
                                                class="@error('main_image') is-invalid @enderror" style="display:none;" />
                                            <button id="output_main_image" type="button" class="bg-light"
                                                onclick="document.getElementById('main_image').click();" value="emad"
                                                style="
                                                        width: 100px;
                                                        height: 100px;
                                                        border-radius: 2px;
                                                        background-repeat: no-repeat;
                                                        background-size: cover;
                                                        background-position: center;
                                                        border:none;
                                                        "></button>
                                            <div class="position-absolute top-100 start-100 translate-middle">
                                                <label for="product-image-input"
                                                    onclick="document.getElementById('main_image').click();" class="mb-0"
                                                    title="Select Image">
                                                    <div class="avatar-xs">
                                                        <div
                                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                                            <i class="ri-image-fill"></i>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <script>
                                            var loadFile_main_image = function(main_image) {
                                                var main_image = document.getElementById('output_main_image');
                                                var src = URL.createObjectURL(event.target.files[0]);
                                                main_image.style.backgroundImage = 'url(' + src + ')';
                                            };
                                        </script>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">{{ __('English Title') }}</label>
                                        <input type="text" id="title" name="title" class="form-control" value="{{ old('title') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title_ar" class="form-label">{{ __('Arabic Title') }}</label>
                                        <input type="text" id="title_ar" name="title_ar" class="form-control" value="{{ old('title_ar') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title" class="form-label">{{ __('English Sub Title') }}</label>
                                        <input type="text" id="sub_title" name="sub_title" class="form-control" value="{{ old('sub_title') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sub_title_ar" class="form-label">{{ __('Arabic Sub Title') }}</label>
                                        <input type="text" id="sub_title_ar" name="sub_title_ar" class="form-control" value="{{ old('sub_title_ar') }}" required />
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description" class="form-label">{{ __('English Description') }}</label>
                                        <textarea id="description" rows="5" name="description" class="form-control">{{ old('description') }} </textarea>
                                        <script>
                                            CKEDITOR.replace('description', {
                                                                filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",
                                                                filebrowserUploadMethod: 'form'
                                                            });
                                         </script>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="description_ar" class="form-label">{{ __('Arabic Description') }}</label>
                                        <textarea id="description_ar" rows="5" name="description_ar" class="form-control">{{ old('description_ar') }} </textarea>
                                        <script>
                                            CKEDITOR.replace('description_ar', {
                                                                filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",
                                                                filebrowserUploadMethod: 'form'
                                                            });
                                        </script>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="tag" class="form-label">{{ __('English Tags') }}</label>
                                        <input type="text" class="form-control" id="tag" name="tag" value="{{ old('tag') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="tag_ar" class="form-label">{{ __('Arabic Tags') }}</label>
                                        <input type="text" class="form-control" id="tag_ar" name="tag_ar" value="{{ old('tag_ar') }}">
                                    </div>
                                </div>
                                <!--end col-->

                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="gallery" class="form-label">{{ __('Other Images') }}</label>
                                        <input type="file" id="gallery" name="gallery[]" class="form-control" multiple>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="submit" class="btn btn-success me-4" id="add-btn">{{ __('Add') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!--end col-->
    </div>
    <!--end row-->



@stop

@section('js')


@stop
