<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id', 'date', 'end_date', 'currancy', 'description', 'file', 'status', 'totel',
        'note'
    ];

    public function customer()
    {
        # code...
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }

    public function services()
    {
        # code...
        return $this->hasMany(Service::class, 'offer_id', 'id');
    }
}
