<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'image', 'name_ar', 'description', 'description_ar'
    ];

    public function plans()
    {
        # code...
        return $this->hasMany(Plan::class, 'group_id', 'id');
    }

    public function works()
    {
        # code...
        return $this->hasMany(Work::class, 'group_id', 'id');
    }
}
