<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'title_ar', 'main_image', 'sub_title', 'sub_title_ar', 'description', 'description_ar', 'tag_ar', 'tag'
    ];

    protected $casts = [
        'tag' => 'array',
        'tag_ar' => 'array'
    ];

    public function images()
    {
        # code...
        return $this->hasMany(BlogImage::class, 'blog_id', 'id');
    }
}
