<?php

namespace App\Http\Controllers\Front;

use App\Models\Blog;
use App\Models\Menu;
use App\Models\Team;
use App\Models\Work;
use App\Models\About;
use App\Models\Group;
use App\Models\Slider;
use App\Models\Contact;
use App\Models\Order;
use App\Models\Package;
use App\Models\Partner;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class HomeController extends Controller
{
    public function index()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }
        $main_slider = Slider::latest()->first();
        $sliders = Slider::latest()->take(5)->get();
        $groups = Group::latest()->take(6)->get();
        $works = Work::latest()->take(5)->get();
        $plans = Group::where('id', 10)->first()->plans()->take(3)->get();
        $partners = Partner::latest()->get();

        return view('front.index',[
            'main_slider' => $main_slider,
            'menu' => $menu,
            'sliders' => $sliders,
            'groups' => $groups,
            'works' => $works,
            'plans' => $plans,
            'categories' => Category::get(),
            'partners' => $partners,
        ]);
    }

    
     public function contactPost(Request $request)
    {
        
        
        $this->validate($request, [
            'email' => ['required', 'string', 'email','email:rfc'],
            'message' => ['required', 'string' ],
            'name' => ['required',   'string'],
         
    ] ,[
        'name.required' => __('حقل الاسم مطلوب'),
        'email.required' => __('حقل الايميل مطلوب'),
        'email.email' => __('صيغة الايميل خاطئة'),
        'message.required' => __('حقل الرسالة مطلوب'),
    ]);
         
        Contact::create($request->all());
  
            return response()->json([
                'message' => __('شكرا.. تم الارسال!')
            ]);

        

    }
    public function contact()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        } 
        
        return view('front.contact',[ 
            'menu' => $menu, 
        ]);
    }
    public function about()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $about = About::first();
        $teams = Team::get();
        $partners = Partner::get();

        return view('front.about', [
            'menu' => $menu,
            'teams' => $teams,
            'about' => $about,
            'partners' => $partners,
        ]);
    }

    public function work( Work $work)
    {  $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }
        return view('front.work', [
            'work' => $work, 
            'menu' => $menu,
        ]);
    }
    public function works()
    {  $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }
        $works = Work::latest()->get();

        return view('front.works', [
            'works' => $works, 
            'menu' => $menu,
            'categories' => Category::get(),
        ]);
    }

    public function blogs()
    {  $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }
        $blogs = Blog::latest()->get();

        return view('front.blogs', [
            'blogs' => $blogs, 
            'menu' => $menu, 
        ]);
    }

    public function blog( Blog $blog)
    {  $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }
        return view('front.blog', [
            'blog' => $blog, 
            'menu' => $menu,
        ]);
    }

    public function package(Package $package)
    {  $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }
         
        return view('front.package', [
            'package' => $package, 
            'menu' => $menu, 
        ]);
    }

    public function about2()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $about = About::first();

        return view('front.about-2', [
            'menu' => $menu,
            'about' => $about,
        ]);
    }

    public function partners()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $partners = Partner::get();

        return view('front.partners', [
            'menu' => $menu,
            'partners' => $partners,
        ]);
    }

    public function ourWorks()
    {
        # code...
        $menu = ['ar' => [], 'en' => []];
        $menus = Menu::get();
        foreach($menus as $item){
            $menu['ar'][$item->route] = $item->name_ar;
            $menu['en'][$item->route] = $item->name;
        }

        $groups = Group::get();

        return view('front.our-job', [
            'menu' => $menu,
            'groups' => $groups,
        ]);
    }
    public function order(Request $request)
    {
        $request->validate([ 
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:255',
            'description' => 'nullable|string|max:500',
             
        ]);

        $data = $request->all(); 

        Order::create($data);

        return redirect()->back()->with('success', __('تم ارسال طلبك بنجاح!'));
    }
}
