<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Validation\Rules;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UsersController extends Controller
{
    public function index(Request $request)
    {
        # code...
        if($request->search != '' || $request->role_id != ''){
            if($request->search && $request->role_id)
                $users = User::where('role_id', '<>', 0)->where([['name','LIKE',"%$request->search%"], ['role_id',$request->role_id]])->paginate(12);
            else if($request->search)
                $users = User::where('role_id', '<>', 0)->where('name','LIKE',"%$request->search%")->paginate(12);
            else if($request->role_id)
                $users = User::where('role_id', '<>', 0)->where('role_id',$request->role_id)->paginate(12);
        }else{
            $users = User::where('role_id', '<>', 0)->paginate(12);
        }

        return view('admin.users.index',[
            'users' => $users
        ]);
    }

    public function store(Request $request)
    {
        # code...
        $request->validate([
            'name' => 'required|string|max:255',
            'password' => ['required','confirmed', Rules\Password::defaults()],
            'email' => 'email|required|unique:users,email',
            'role_id' => 'required|exists:roles,id',
            'phone' => 'required|string|max:255',
        ]);

        $data = $request->except(['password']);
        $data['password'] = Hash::make($request->password);

        User::create($data);

        return redirect()->back()->with('success', __('Added Done !'));
    }

    public function update(Request $request, User $user)
    {
        # code...
        $request->validate([
            'name' => 'required|string|max:255',
            'password' => ['nullable','confirmed', Rules\Password::defaults()],
            'phone' => 'required|string|max:255',
            'role_id' => 'required|exists:roles,id',
            'email' => 'email|required|unique:users,email,' . $user->id,
            'status' => 'nullable',
        ]);

        $data = $request->except(['password']);
        $data['role_id'] = 0;
        if($request->password)
            $data['password'] = Hash::make($request->password);

        $user->update($data);

        return redirect()->route('c-panel.users.index')->with('success', __('Updated Done !'));
    }

    public function destroy(User $user)
    {
        # code...
        $user->delete();
        return redirect()->route('c-panel.users.index')->with('success', __('Deleted Done !'));

    }
}
