<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Role;
use App\Models\RoleRoute;
use App\Models\Route;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    public function index()
    {
        # code...
        return view('admin.roles.index',[
            'roles' => Role::paginate(12),
        ]);
    }

    public function store(Request $request)
    {
        # code...
        // dd($request->all());
        $request->validate([
            'name' => 'required|string|max:255',
            'routes' => 'array|required',
            'routes.*' => 'required'
        ]);

        $role = Role::create([
            'name' => $request->name,
        ]);

        foreach($request->routes as $route){
            RoleRoute::create([
                'role_id' => $role->id,
                'route_id' => $route
            ]);
        }

        return redirect()->back()->with('success', __('Added Done !'));
    }

    public function update(Request $request, Role $role)
    {
        # code...
        // dd($request->all());
        $request->validate([
            'name' => 'required|string|max:255',
            'routes' => 'array|required',
            'routes.*' => 'required'
        ]);

        $role->update([
            'name' => $request->name,
        ]);

        RoleRoute::where('role_id', $role->id)->delete();
        foreach($request->routes as $route){
            RoleRoute::create([
                'role_id' => $role->id,
                'route_id' => $route
            ]);
        }

        return redirect()->back()->with('success', __('Updated Done !'));
    }

    public function destroy(Role $role)
    {
        # code...
        $role->delete();
        return redirect()->back()->with('success', __('Deleted Done !'));

    }
}
