<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Package;
use App\Models\Package_plan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PackageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    { 

        $packages = Package::get();
        return view('admin.packages.index',[
            'packages' => $packages,
        ]);
    }

    public function store(Request $request)
    {
        # code...
        // dd($request->all());
        $request->validate([ 
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
             
        ]);

        $data = $request->all(); 

        Package::create($data);

        return redirect()->route('c-panel.packages.index')->with('success', __('Added Done !'));
    }

    public function update(Request $request, Package $package)
    {
        # code...
        $request->validate([ 
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255', 
        ]);

        $data = $request->all(); 
        
        $package->update($data);

        return redirect()->route('c-panel.packages.index')->with('success', __('Updated Done !'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( Package $package)
    {
        // $this->authorize('delete', $department);
          $package->delete();
        return redirect()->route('c-panel.packages.index')->with('success',__('Deleted Done !'));
    }
    public function package_plans( Package $package)
    { 
        return view('admin.packages.plans',[
            'package' => $package,
        ]);
    }


    public function package_plan_store(Request $request)
    {
        # code...
        // dd($request->all());
        $request->validate([ 
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
            'sub_title' => 'string|max:255',
            'sub_title_ar' => 'string|max:255',
            'price' => 'required|max:255',
             
        ]);

        $data = $request->except(['features']); 

        $package_plan = Package_plan::create($data);

        foreach($request->features as $feature)
        {
            $package_plan->features()->create([
                'name' => $feature,
            ]);
        }
        return redirect()->back()->with('success', __('Added Done !'));
    }

    public function package_plan_edit(Package_plan $package_plan)
    {
         return view('admin.packages.edit',[
            'item' => $package_plan,
        ]);
    }
    public function package_plan_update(Request $request, Package_plan $package_plan)
    {
        # code...
        $request->validate([ 
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
            'sub_title' => 'string|max:255',
            'sub_title_ar' => 'string|max:255',
            'price' => 'required|max:255',
        ]);

        $data = $request->except(['features']);
        
        $package_plan->update($data);
        $package_plan->features()->delete();

        foreach($request->features as $feature)
        {
            $package_plan->features()->create([
                'name' => $feature,
            ]);
        }
        return redirect()->back()->with('success', __('Updated Done !'));
    }

    public function package_plan_destroy(Package_plan $package_plan)
    {
        // $this->authorize('delete', $department);
          $package_plan->delete();
        return redirect()->back()->with('success',__('Deleted Done !'));
    }
    
}
