<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            // dd($request->all());
            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Order::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Order::select('count(*) as allcount')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('phone', 'like', '%' . $searchValue . '%') 
                ->count();

            $orders = Order::select('orders.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('phone', 'like', '%' . $searchValue . '%') 
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('orders.id', 'desc')
                ->get();


            $records = [];

            foreach($orders as $item)
            { 
                $status = '';
                if($item->status == 0 ){
                  $status = '<span class="badge badge-soft-success " >لم يتم الرد</span>';
                }
                if($item->status == 1 ){
                    $status = '<span class="badge badge-soft-info" >تم الاتصال</span>';
                  }
                  if($item->status == 2 ){
                    $status = '<span class="badge badge-soft-warning" >مهم</span>';
                  }
                $records[] = [
                    'record_select' =>view('admin.orders.datatable.record',[ 'item' => $item ])->render(),
                    'id' => $item->id,
                    'name' => $item->name ,
                    'phone' => $item->phone ,
                    'package' => $item->package ? $item->package->title_ar : __(''),
                    'status' => $status ,
                    'date' => $item->created_at->translatedFormat('d F Y H:m'),
                    'actions' => view('admin.orders.datatable.buttons',[ 'item' => $item ])->render() ,
                ];
            }

            $response = [
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $records
            ];

            return response()->json($response);

        }

        return view('admin.orders.index');
    }
 
    public function update(Request $request,Order $order)
    {
        # code...
        $request->validate([
            'status' => 'required', 
        ]);

       $data = $request->all();   
       
       $order->update($data);


        return redirect()->back()->with('success',__('تم تعديل حالة الطلب بنجاح!'));;
    } 
    public function bulkDelete()
    {
        // dd(json_decode(request()->record_ids));
        if(count(json_decode(request()->record_ids)) != 0){
            foreach (json_decode(request()->record_ids) as $recordId) {
                $order = Order::FindOrFail($recordId);
                // $this->authorize('delete', $blog);
                $this->delete($order);
            }//end of for each
        }else{
            return redirect()->back()->with('error',__('Please Select Record Before Delete'));
        }

        return redirect()->back()->with('success',__('Selected  Deleted Done !'));
    }// end of bulkDelete
 
    private function delete(Order $order)
    {
        // $this->authorize('delete', $work); 
        $order->delete();
    }
}
