<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use App\Models\WebsiteSetting;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ContactsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $this->authorize('viewAny', WebsiteSetting::class);
        if ($request->ajax()) {
            // dd($request->all());
            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Contact::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Contact::select('count(*) as allcount')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->count();

            $contacts = Contact::select('contacts.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('contacts.id', 'desc')
                ->get();


            $records = [];

            foreach($contacts as $item)
            {
                $records[] = [
                    'record_select' =>view('admin.contacts.datatable.record',[ 'item' => $item ])->render(),
                    'name' => $item->name,
                    'email' => $item->email,
                    'status' => $item->status == '0' ? '<span class="badge badge-soft-danger text-uppercase" style="font-size:0.8125rem;">' . __('unread') . '</span>' : '<span class="badge badge-soft-success text-uppercase" style="font-size:0.8125rem;">' . __('read') . '</span>',
                    'created_at' => Carbon::parse($item->created_at)->format('Y-m-d / H:i'),
                    'actions' => view('admin.contacts.datatable.buttons',[ 'item' => $item ])->render() ,
                ];
            }

            $response = [
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $records
            ];

            return response()->json($response);

        }

        return view('admin.contacts.index');
    }

    public function show(Contact $contact)
    {
        # code...
        $this->authorize('viewAny', WebsiteSetting::class);
        $contact->update([
            'status' => '1',
        ]);

        return response()->json([
            'status' => 'success'
        ],200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( Contact $contact)
    {
        // $this->authorize('delete', $department);
        $this->authorize('viewAny', WebsiteSetting::class);
        $contact->delete();
        return redirect()->route('c-panel.contacts.index')->with('success',__('Deleted Done !'));
    }

    public function bulkDelete()
    {
        // dd(json_decode(request()->record_ids));
        $this->authorize('viewAny', WebsiteSetting::class);
        if(count(json_decode(request()->record_ids)) != 0){
            foreach (json_decode(request()->record_ids) as $recordId) {
                $contact = Contact::FindOrFail($recordId);
                // $this->authorize('delete', $contact);
                $this->delete($contact);
            }//end of for each
        }else{
            return redirect()->route('c-panel.contacts.index')->with('error',__('Please Select Record Before Delete'));
        }

        return redirect()->route('c-panel.contacts.index')->with('success',__('Selected  Deleted Done !'));
    }// end of bulkDelete

    private function delete(Contact $contact)
    {
        // $this->authorize('delete', $contact);
        $this->authorize('viewAny', WebsiteSetting::class);
        $contact->delete();
    }
}
