<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    { 

        $categories = Category::get();
        return view('admin.categories.index',[
            'categories' => $categories,
        ]);
    }

    public function store(Request $request)
    {
        # code...
        // dd($request->all());
        $request->validate([ 
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
             
        ]);

        $data = $request->all(); 

        Category::create($data);

        return redirect()->route('c-panel.categories.index')->with('success', __('Added Done !'));
    }

    public function update(Request $request, Category $category)
    {
        # code...
        $request->validate([ 
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255', 
        ]);

        $data = $request->all(); 
        
        $category->update($data);

        return redirect()->route('c-panel.categories.index')->with('success', __('Updated Done !'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( Category $category)
    {
        // $this->authorize('delete', $department);
          $category->delete();
        return redirect()->route('c-panel.categories.index')->with('success',__('Deleted Done !'));
    }

 
}
